/* ----------------------------------------------------------------
 *   FILE
 *	io.c
 *	
 *   NOTES
 *
 *   IDENTIFICATION
 *	$Header: /usr/local/devel/postgres/src/backend/parser/RCS/io.c,v 1.7 1992/12/30 17:39:17 marc Exp $
 * ----------------------------------------------------------------
 */

#include <stdio.h>
#include "utils/log.h"
#include "io.h"

int StringInput;
char *TheString;
char *Ch;

void
init_io()
{

    Ch = NULL;
}

char
input()
{
    char c;

    if (StringInput) {
	if (Ch == NULL) {
	    Ch = TheString;
	    return(*Ch++);
	} else if (*Ch == '\0') {
	    return(0);
	} else {
	    return(*Ch++);
	}
    } else {
	c = getchar();
	if (c == EOF) {
	    return(0);
	} else {
	    return(c);
	}
    }
}

void
unput(c)
char c;
{
    
    if (StringInput) {
	if (Ch == NULL) {
	    elog(FATAL, "Unput() failed.\n");
	    /* NOTREACHED */
	} else if (c != 0) {
	    *--Ch = c;
	}
    } else {
	ungetc(c, stdin);
    }
}
