.lf 1 tmac.an.nr
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/RCS/tmac.an.nr,v 1.1 1993/01/26 02:43:13 aoki Exp $
.ds II INGRES
.ds PG POSTGRES
.ds UU UNIX
.ds PQ POSTQUEL
.ds LI LIBPQ
.ds PV 4.1
.de (l 			\" fake "-me"-style lists
.nf
.ie '\\$1'M' .in +0n
.el .in +5n
..
.de )l
.fi
.in
..
.de (C			\" constant-width font blocks
.(l \\$1
.sp
..
.de )C
.sp
.)l
..
.de BH			\" reference manual "big header" for sections
.SH NAME
\&\\$1
..
.de SB			\" section/index stuff
..	\" no-op
.de SE
..	\" no-op
.de XA
..	\" no-op
.de XP
..	\" no-op
.de SP
..
.ds lq ""
.ds rq ""
.lf 1 postquel/postquel.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/src/ref/postquel/RCS/postquel.cmdsrc,v 1.18 1993/03/17 19:15:02 aoki Exp $
.TH INTRODUCTION COMMANDS 01/23/93
.XA 0 "Section 4 \(em \*(PQ Commands (COMMANDS)"
.BH "SECTION 4 \(em \*(PQ COMMANDS (COMMANDS)"
.XA 1 "General Information"
.SH DESCRIPTION
The following is a description of the general syntax of \*(PQ.
Individual \*(PQ statements and commands are treated separately in the
document; this section describes the syntactic classes from which the
constituent parts of \*(PQ statements are drawn.
.SH Comments
A
.IR comment
is an arbitrary sequence of characters bounded on the left by
\*(lq/*\*(rq and on the right by \*(lq*/\*(rq, e.g:
.(C
/* This is a comment */
.)C
.SH "Names"
.IR Names
in \*(PQ are sequences of not more than 16 alphanumeric characters,
starting with an alphabetic.  The underscore character (\*(lq_\*(rq)
is considered an alphabetic.
.SH "Keywords"
The following identifiers are reserved for use as
.IR keywords
and may not be used otherwise:
.PP
.\" .s3
.lf 1 obj/keyword.nr
.ft B
.nf
.if n .ta 5 +15 +15 +15
.if t .ta 0.5i +1.5i +1.5i +1.5i
	abort	define	is	quel
	acl	delete	ISNULL	relation
	addattr	demand	key	remove
	after	descending	leftouter	rename
	aggregate	destroy	light	replace
	all	destroydb	listen	retrieve
	always	do	load	returns
	and	empty	merge	rewrite
	append	end	move	rightouter
	archive	execute	never	rule
	arch_store	extend	new	setof
	arg	fetch	none	sort
	as	forward	nonulls	stdin
	ascending	from	not	stdout
	attachas	function	notify	store
	backward	group	NOTNULL	to
	before	heavy	NULL	transaction
	begin	in	on	type
	binary	index	once	union
	by	indexable	operator	unique
	cfunction	inherits	or	user
	change	input_proc	output_proc	using
	close	instance	parallel	vacuum
	cluster	instead	pfunction	version
	copy	intersect	portal	view
	create	into	postquel	where
	createdb	intotemp	priority	with
	current	iportal	purge	
.fi
.ft
.lf 33 postquel/postquel.cmdsrc
.PP
In addition, all \*(PG classes have several predefined attributes used
by the system.  For a list of these, see the section
.BR Fields ,
below.
.XA 1 "Constants"
.SH "Constants"
There are six types of
.IR constants
for use in \*(PQ.  They are described below.
.SH "Character Constants"
Single
.IR "character constants"
may be used in \*(PQ by surrounding them by single quotes, e.g., `n'.
.SH "String Constants"
.IR Strings
in \*(PQ are arbitrary sequences of ASCII characters bounded by double
quotes (" "). Upper case alphabetics within strings are accepted
literally.  Non-printing characters may be embedded within strings by
prepending them with a backslash, e.g., `\en'. Also, in order to embed
quotes within strings, it is necessary to prefix them with `\e' .  The
same convention applies to `\e' itself.  Because of the limitations on
instance sizes, string constants are currently limited to a length of
a little less than 8192 bytes.  Larger objects may be created using the
\*(PG Large Object interface.
.SH "Integer Constants"
.IR "Integer constants"
in \*(PQ are collection of ASCII digits with no decimal point.  Legal
values range from \(mi2147483647 to +2147483647.  This will vary
depending on the operating system and host machine.
.SH "Floating Point Constants"
.IR "Floating point constants"
consist of an integer part, a decimal point, and a fraction part or
scientific notation of the following format:
.(C
{<dig>} .{<dig>} [e [+-] {<dig>}]
.)C
Where <dig> is a digit.  You must include at least one <dig> after the
period and after the [+-] if you use those options.  An exponent with
a missing mantissa has a mantissa of 1 inserted.  There may be no
extra characters embedded in the string.  Floating constants are taken
to be double-precision quantities with a range of approximately
.if n -10**38 to +10**38
.if t \(mi10\x'-0.2v'\u\s-3\&38\s0\d to 10\u\x'-0.2v'\s-3\&38\s0\d
and a precision of 17 decimal digits.  This will vary depending on the
operating system and host machine.
.SH "Constants of \*(PG User Defined Types"
A constant of an
.IR arbitrary
type can be entered using the notation:
.(C
"string"::type-name
.)C
In this case the value inside the string is passed to the input
conversion routine for the type called type-name. The result is a
constant of the indicated type.
.SH "Array constants"
.IR "Array constants"
are arrays of any \*(PG type, including other arrays, string
constants, etc.  The general format of an array constant is the
following:
.(C
"{<val1><delim><val2><delim>}"
.)C
An example of an array constant is
.(C
"{{1,2,3},{4,5},{6,7,8,9}}"
.)C
This constant is an array consisting of three sub-arrays of integers.
.PP
Individual array elements can and should be placed between quotation marks 
whenever possible to avoid ambiguity problems with respect to leading white 
space.  Elements of single-element arrays (e.g., \*(lq{"1"}\*(rq) must be 
quoted.
.XA 1 "Fields and Attributes"
.SH "Fields"
A 
.IR field
is either an attribute of a given class or one of the following:
.(C
all
oid
tmin
tmax
xmin
xmax
cmin
cmax
vtype
.)C
As in \*(II, 
.IR all
is a shorthand for all normal attributes in a class, and may be used
profitably in the target list of a retrieve statement.
.PP
.IR Oid
stands for the unique identifier of an instance which is added by
\*(PG to all instances automatically. Oids are not reused and are 32
bit quantities.
.PP
.IR "Tmin, tmax, xmin, cmin, xmax"
and
.IR cmax
stand respectively for the time that the instance was inserted, the
time the instance was deleted, the identity of the inserting
transaction, the command identifier within the transaction, the
identity of the deleting transaction and its associated deleting
command.  For further information on these fields consult [STON87].
Times are represented internally as instances of the \*(lqabstime\*(rq
data type.  Transaction identifiers are 32 bit quantities which are
assigned sequentially starting at 512.  Command identifiers are 16 bit
objects; hence, it is an error to have more than 65535 \*(PQ commands
within one transaction.
.SH "Attributes"
An
.IR attribute
is a construct of the form:
.(C
Instance-variable{.composite_field}.field `['number`]'
.)C
.IR Instance-variable 
identifies a particular class and can be thought of as standing for
the instances of that class.  An instance variable is either a class
name, a surrogate for a class defined by means of a
.IR from
clause, or the keyword 
.BR new
or 
.BR current.
New and current can only appear in the action portion of a rule, while
other instance variables can be used in any \*(PQ command.
.IR Composite_field
is a field of of one of the \*(PG composite types indicated in the 
.IR information (commands)
section, while successive composite fields address attributes in the
class(s) to which the composite field evaluates.  Lastly,
.IR field
is a normal (base type) field in the class(s) last addressed.  If
.IR field 
is of type array, then the optional
.IR number 
designator indicates a specific element in the array.  If no number is
indicated, then all array elements are returned.
.XA 1 "Operators"
.SH "Operators"
Any built-in system, or user defined operator may be used in \*(PQ.
For the list of built-in and system operators consult
.BR "built-in types" (commands)
and
.BR "system types" (commands).
For a list of user defined operators consult your system administrator
or run a query on the pg_operator class.  Parentheses may be used for
arbitrary grouping of operators.
.XA 1 "Expressions"
.SH "Expressions (a_expr)"
An
.IR expression
is one of the following:
.(C
( a_expr )
constant
attribute
a_expr binary_operator a_expr
a_expr right_unary_operator
left_unary_operator a_expr
parameter
functional expressions 
aggregate expressions
set expressions \fB(not in Version \*(PV)\fP
class expression \fB(not in Version \*(PV)\fP
.)C
We have already discussed constants and attributes.  The two kinds of
operator expressions indicate respectively binary and left_unary
expressions.  The following sections discuss the remaining options.
.SH "Parameters"
A 
.IR parameter
is used to indicate a parameter in a \*(PQ function.  Typically this
is used in \*(PQ function definition statement.  The form of a
parameter is:
.(C
\'$' number
.)C
For example, consider the definition of a function, DEPT, as
.(C
define function DEPT 
	(language="postquel", returntype = dept)
    arg is (char16) as 
    retrieve (dept.all) where dept.name = $1
.)C
.SH "Functional Expressions"
A
.IR "functional expression"
is the name of a legal \*(PQ function, followed by its argument list
enclosed in parentheses, e.g.:
.(C
fn-name (a_expr{ , a_expr})
.)C
For example, the following computes the square root of an employee
salary.
.(C
sqrt(emp.salary)
.)C
.SH "Aggregate Expression"
An
.IR "aggregate expression"
represents a simple aggregate (i.e., one that computes a single value)
or an aggregate function (i.e., one that computes a set of values).
The syntax is the following:
.(C
aggregate_name `{' [unique [using] opr] a_expr
		[from from_list]
		[where qualification]`}'
.)C
Here, 
.IR aggregate_name 
must be a previously defined aggregate.  The 
.IR from_list 
indicates the class to be aggregated over while
.IR qualification
gives restrictions which must be satisfied by the instances to be
aggregated.  Next, the
.IR a_expr
gives the expression to be aggregated, while the
.IR unique
tag indicates whether all values should be aggregated or just the
unique values of
.IR a_expr .
Two expressions, 
.IR a_expr1
and
.IR a_expr2
are the same if
.IR "a_expr1 opr a_expr2"
evaluates to true.
.PP
In the case that all instance variables used in the aggregate
expression are defined in the 
.IR from 
list, a simple aggregate has been
defined.  For example, to sum employee salaries whose age is greater
than 30, one would write:
.(C
retrieve (total = sum {e.salary from e in emp
                                where e.age > 30} )
.)C
or
.(C
retrieve (total = sum {emp.salary where emp.age > 30})
.)C
In either case, \*(PG is instructed to find the instances in the
.IR from_list
which satisfy the qualification and then compute the aggregate of the
.IR a_expr 
indicated.  
.PP
On the other hand, if there are variables used in the aggregate
expression that are not defined in the 
.IR from
list, e.g:
.(C
avg {emp.salary where emp.age = e.age}
.)C
then this aggregate function has a value for each possible value taken on by
\*(lqe.age\*(rq.  For example, the following complete query finds the
average salary of each possible employee age over 18:
.(C
retrieve (e.age, avg {emp.salary where emp.age = e.age})
	from e in emp 
	where e.age > 18
.)C
Aggregate functions are not supported in Version \*(PV.
.PP
In general, the following aggregates
(i.e., the expression within the braces) will not work:
.IP
Aggregate functions of any kind.
.IP
Aggregates containing more than one range variable.
.IP
Aggregates that refer to range variables
that use class inheritance (e.g., \*(lqe from emp*\*(rq).
.IP
Aggregate containing clauses other than
.IR a_expr
and
.IR where -qualification
clauses.  (In other words,
.IR from
clauses within aggregates are not supported.)
.PP
Therefore, of the three example queries given, only the second is 
actually supported.
.SH "Set Expressions"
.BR "Set expressions are not supported in Version \*(PV."
.PP
A
.IR "set expression"
defines a collection of instances from some class and uses the
following syntax:
.(C
 {target_list from from_list where qualification}
.)C
For example, the set of all employee names over 40 is:
.(C
{emp.name where emp.age > 40}
.)C
In addition, it is legal to construct set expressions which have an
instance variable which is defined outside the scope of the
expression.  For example, the following expression is the set of
employees in each department:
.(C
{emp.name where emp.dept = dept.dname}
.)C
Set expressions can be used in class expressions which are defined
below.
.SH "Class Expression"
.BR "Class expressions are not supported in Version \*(PV."
.PP
A 
.IR "class expression"
is an expression of the form:
.PP
.(l
class_constructor binary_class_operator class_constructor
unary_class_operator class_constructor
.)l
.PP
where binary_class_operator is one of the following:
.PP
.if t .ta 0.5i +1.0i
.if n .ta 5n +10n
.(l
union		union of two classes
intersect		intersection of two classes
\-		difference of two classes
>>		left class contains right class
<<		right class contains left class
==		right class equals left class 
.)l
.PP
and unary_class_operator can be:
.PP
.(l
empty		right class is empty
.)l
.PP
A 
.IR class_constructor 
is either an instance variable, a class name, the value of a composite
field or a set expression.
.PP
An example of a query with a class expression is one to find all the
departments with no employees:
.(C
retrieve (dept.dname)
    where empty {emp.name where emp.dept = dept.dname}
.)C
.SH "Target_list"
A
.IR "target list"
is a parenthesized, comma-separated list of one or more elements, each
of which must be of the form:
.(C
[result_attname =] a_expr
.)C
Here, result_attname is the name of the attribute to be created (or an
already existing attribute name in the case of update statements.)  If
.IR result_attname
is not present, then 
.IR a_expr
must contain only one attribute name which is assumed to be the name
of the result field.  In Version \*(PV default naming is only used if
.IR a_expr
is an attribute.
.SH "Qualification"
A 
.IR qualification 
consists of any number of clauses connected by the logical operators:
.(C
not
and
or
.)C
A clause is an 
.IR a_expr
that evaluates to a Boolean over a set of instances.
.SH "From List"
The 
.IR "from list"
is a comma-separated list of 
.IR "from expressions" .
.PP
Each 
.IR "from expression"
is of the form:
.(C
instance_variable-1 {, instance_variable-2}
	in class_reference
.)C
where 
.IR class_reference
is of the form
.(C
class_name [time_expression] [*]
.)C
The 
.IR "from expression"
defines one or more instance variables to range over the class
indicated in 
.IR class_reference .
Adding a 
.IR time_expression
will indicate that a historical class is desired.  One can also request 
the instance variable to range over all classes that are beneath the
indicated class in the inheritance hierarchy by postpending the
designator \*(lq*\*(rq.
.SH "Time Expressions"
A
.IR "time expression"
is in one of two forms:
.(C
 [date]
 [date-1, date-2]
.)C
The first case requires instances that are valid at the indicated
time.  The second case requires instances that are valid at some time
within the date range specified.  If no time expression is indicated,
the default is \*(lqnow\*(rq.
.PP
In each case, the date is a character string of the form
.(C
[MON-FRI] "MMM DD [HH:MM:SS] YYYY" [Timezone]
.)C
where MMM is the month (Jan \- Dec), DD is a legal day number in the
specified month, HH:MM:SS is an optional time in that day (24-hour
clock), and YYYY is the year.  If the time of day HH:MM:SS is not
specified, it defaults to midnight at the start of the specified day.
As of Version 3.0, times are no longer read and written using
Greenwich Mean Time; the input and output routines default to the
local time zone.
.PP
For example,
.(C
["Jan 1 1990"]
["Mar 3 00:00:00 1980", "Mar 3 23:59:59 1981"]
.)C
are valid time specifications.
.SH "SEE ALSO"
append(commands),
delete(commands),
execute(commands),
replace(commands),
retrieve(commands),
monitor(unix).
.SH BUGS
The following constructs are not available in Version \*(PV:
.(l
class expressions
set expressions
.)l
