.lf 1 tmac.an.nr
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/RCS/tmac.an.nr,v 1.1 1993/01/26 02:43:13 aoki Exp $
.ds II INGRES
.ds PG POSTGRES
.ds UU UNIX
.ds PQ POSTQUEL
.ds LI LIBPQ
.ds PV 4.1
.de (l 			\" fake "-me"-style lists
.nf
.ie '\\$1'M' .in +0n
.el .in +5n
..
.de )l
.fi
.in
..
.de (C			\" constant-width font blocks
.(l \\$1
.sp
..
.de )C
.sp
.)l
..
.de BH			\" reference manual "big header" for sections
.SH NAME
\&\\$1
..
.de SB			\" section/index stuff
..	\" no-op
.de SE
..	\" no-op
.de XA
..	\" no-op
.de XP
..	\" no-op
.de SP
..
.ds lq ""
.ds rq ""
.lf 1 postquel/define_view.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/postquel/RCS/define_view.cmdsrc,v 1.9 1993/01/26 02:43:13 aoki Exp $
.TH "DEFINE VIEW" COMMANDS 01/23/93
.XA 2 "Define View"
.SH NAME
define view \(em construct a virtual class
.SH SYNOPSIS
.(l M
\fBdefine view\fR view_name
        \fB(\fR [ dom_name_1 \fB=\fR] expression_1
	    {\fB,\fR [dom_name_i \fB=\fR] expression_i} \fB)\fR
    [ \fBfrom\fR from_list ]
    [ \fBwhere\fR qual ]
.)l
.SH DESCRIPTION
.BR "Define view"
will define a view of a class.  This view is not physically
materialized; instead the rule system is used to support view
processing as in [STON90].  Specifically, a query rewrite retrieve
rule is automatically generated to support retrieve operations on
views.  Then, the user can add as many update rules as he wishes to
specify the processing of update operations to views.  See [STON90]
for a detailed discussion of this point.
.SH EXAMPLE
.(C
/*
 * define a view consisting of toy department employees
 */
define view toyemp (e.name)
   from e in emp
   where e.dept = "toy"
.)C
.(C
/*
 * Specify deletion semantics for toyemp
 */
define rewrite rule example1 is
   on delete to toyemp
   then do instead delete emp where emp.OID = current.OID
.)C
.SH "SEE ALSO"
create(commands), 
define rule(commands),
postquel(commands).
