.lf 1 tmac.an.nr
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/RCS/tmac.an.nr,v 1.1 1993/01/26 02:43:13 aoki Exp $
.ds II INGRES
.ds PG POSTGRES
.ds UU UNIX
.ds PQ POSTQUEL
.ds LI LIBPQ
.ds PV 4.1
.de (l 			\" fake "-me"-style lists
.nf
.ie '\\$1'M' .in +0n
.el .in +5n
..
.de )l
.fi
.in
..
.de (C			\" constant-width font blocks
.(l \\$1
.sp
..
.de )C
.sp
.)l
..
.de BH			\" reference manual "big header" for sections
.SH NAME
\&\\$1
..
.de SB			\" section/index stuff
..	\" no-op
.de SE
..	\" no-op
.de XA
..	\" no-op
.de XP
..	\" no-op
.de SP
..
.ds lq ""
.ds rq ""
.lf 1 postquel/define_aggregate.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/postquel/RCS/define_aggregate.cmdsrc,v 1.12 1993/01/26 02:43:13 aoki Exp $
.TH "DEFINE AGGREGATE" COMMANDS 01/23/93
.XA 2 "Define Aggregate"
.SH NAME
define aggregate \(em define a new aggregate
.SH SYNOPSIS
.(l M
\fBdefine aggregate\fR agg-name [\fBas\fR]
	\fB(\fP[\fBsfunc1\fR \fB=\fR state-transition-function-1]
	 [\fB,\fP \fBsfunc2\fR \fB=\fR state-transition-function-2]
	 [\fB,\fP \fBfinalfunc\fR \fB=\fR final-function]
	 [\fB,\fP \fBinitcond1\fR \fB=\fR initial-condition-1]
	 [\fB,\fP \fBinitcond2\fR \fB=\fR initial-condition-2]\fB)\fR
.)l
.SH DESCRIPTION
An aggregate function can use up to three functions, two
.IR "state transition"
functions, X1 and X2:
.(l
X1( internal-state1, next-data_item ) ---> next-internal-state1
X2( internal-state2 ) ---> next-internal-state2
.)l
and a
.BR "final calculation"
function, F:
.(l
F(internal-state1, internal-state2) ---> aggregate-value
.)l
These functions are required to have the following three properties:
.IP
The return type of each state-transition-function and the arguments
of the final-calculation-function must be the same type (\fIt\fP).
.IP
The return type of the final-calculation-function must be a \*(PG base
type.
.IP
The first argument to state-transition-function1 must be of type \fIt\fP,
while the second argument must match the data type of the object
being aggregated.
.PP
Note that it is possible to specify aggregate functions that have
varying combinations of state and final functions.  For example, the
\*(lqcount\*(rq aggregate requires
.BR sfunc2
(an incrementing function) but not
.BR sfunc1 " or " finalfunc ,
whereas the \*(lqsum\*(rq aggregate requires
.BR sfunc1
(an addition function) but not
.BR sfunc2 " or " finalfunc
and the \*(lqaverage\*(rq aggregate requires both of the above state
functions as well as a
.BR finalfunc
(a division function) to produce its answer.  In any case, at least
one state function must be defined, and any
.BR sfunc2
must have a corresponding 
.BR initcond2 .
.PP
Aggregates also require two initial conditions, one for each
transition function.  These are specified and stored in the database
as fields of type
.IR text .
.SH EXAMPLE
This
.IR avg
aggregate consists of two state transition functions, a addition
function and a incrementing function.  These modify the internal state
of the aggregate through a running sum and and the number of values
seen so far.  It accepts a new employee salary, increments the count,
and adds the new salary to produce the next state.  The state
transition functions must be passed correct initialization values.
The final calculation then divides the sum by the count to produce the
final answer.
.(C
/*
 * Define an aggregate for int4 average
 */
define aggregate avg (sfunc1 = int4add, sfunc2 = int4inc,
     finalfunc = int4div, initcond1 = "0", initcond2 = "0")
.)C
.SH "SEE ALSO"
define function(commands),
remove aggregate(commands).
