/*
 * Copyright (c) 1983 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Modified for use as Pat daemon by Paul Pomes, University of Illinois,
 * CSO.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983 The Regents of the University of California.\n\
 All rights reserved.\n";

static char RcsId[] = "@(#)$Header: /usr/local/src/cso/oed2/RCS/patd.c,v 2.0 90/03/10 12:19:55 paul Exp $";
#endif /* not lint */

#define		OED2USER	"oed2"

/* some handy defines */
#define		CHNULL			('\0')
#define		CPNULL			((char *) NULL)

/*
 * Pat server.
 */
#include <pwd.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <ctype.h>

/* How program was invoked (argv[0]) for error messages */
char		*MyName;

/* Version string and patchlevel for tracking and patching */
char		Version[] = "$Revision: 2.0 $";
#define		PATCHLEVEL	0

/* Who can connect to us.  Use the most significant part of the domain name */
char		*OkDomains[] = {
	".uiuc.edu",
	".uic.edu",
	(char *) NULL
};

main(argc, argv)
int	argc;
char	*argv[];
{
	struct sockaddr_in	from;
	int			fromlen;
	struct hostent		*hp;
	char			*host;
	struct passwd		*pwd;
	union wait		status;		/* exit status of child */
	struct rusage		rusage;
	int			Pid, i;
	long			time0, time1, time();
	char			*rindex(), *inet_ntoa();

	MyName = ((MyName = rindex (*argv, '/')) == CHNULL) ? *argv : (MyName + 1);
	if (argc && ! strcmp (*++argv, "-v")) {
		printf ("%s: %s at patchlevel %d\n", MyName, Version, PATCHLEVEL);
		exit (0);
	}
#ifdef LOG_LOCAL4
	openlog (MyName, LOG_PID | LOG_ODELAY, LOG_LOCAL4);
#else /* ! LOG_LOCAL4 */
	openlog (MyName, LOG_PID);
#endif /* LOG_LOCAL4 */
	fromlen = sizeof (from);
	if (getpeername(0, (struct sockaddr *)&from, &fromlen) < 0)
		fatal("getpeername");

	/* get name of connected client */
	hp = gethostbyaddr((char *)&from.sin_addr, sizeof (struct in_addr),
		from.sin_family);
	if (hp) {
		int	HostNameLen = strlen (hp->h_name);
		int	OkLen;
		int	Bogus;
		char	**OK;

		host = hp->h_name;
		for (Bogus = 1, OK = OkDomains; *OK != CPNULL; OK++) {
			OkLen = strlen (*OK);
			if (HostNameLen < OkLen)
				continue;
			if (strcasecmp ((host + (HostNameLen - OkLen)),
			    *OK) == 0) {
				Bogus = 0;
				break;
			}
		}
		if (Bogus) {
			syslog(LOG_INFO,"connection refused (non-UIUC/UIC) from %s", host);
			fatal ("Non-UIUC or UIC machine, closing connection");
		}
	}
	else {
		host = inet_ntoa(from.sin_addr);
		if (! (strncmp (host, "128.174.", 8)
		    && strncmp (host, "192.17.", 7))) {
			syslog(LOG_INFO,"connection refused (UIUC un-registered) from %s", host);
			fatal ("Non-registered UIUC machine, closing connection");
		}
		if (! (strncmp (host, "128.248.", 8)
		    && strncmp (host, "131.193.", 8))) {
			syslog(LOG_INFO,"connection refused (UIC un-registered) from %s", host);
			fatal ("Non-registered UIC machine, closing connection");
		}
	}
	syslog(LOG_INFO,"Connection from %s", host);

	if ((pwd = getpwnam (OED2USER)) == (struct passwd *) NULL) {
		syslog (LOG_ERR, "getpwnam: %m");
		fatal ("getpwnam");
	}
	(void) time (&time0);
	if ((Pid = vfork()) == 0) {	/* child */
		char	NewName[256];

		(void) setenv ("HOME", pwd->pw_dir, 1);
		(void) setenv ("SHELL", pwd->pw_shell, 1);
		(void) setenv ("USER", pwd->pw_name, 1);
		if (chdir (pwd->pw_dir) < 0) {
			syslog (LOG_ERR, "No directory!");
			fatal ("No directory!");
		}
		if (chdir ("2e") < 0) {
			syslog (LOG_ERR, "No 2e directory!");
			fatal ("No 2e directory!");
		}
		if (chroot (pwd->pw_dir) == -1) {
			syslog (LOG_ERR, "chroot to %s failed: %m", pwd->pw_dir);
			fatal ("chroot failed");
		}
		if (setgid ((gid_t) pwd->pw_gid) == -1) {
			syslog (LOG_ERR, "setgid: %m");
			fatal ("setgid");
		}
		if (setuid ((uid_t) pwd->pw_uid) == -1) {
			syslog (LOG_ERR, "setuid: %m");
			fatal ("setuid");
		}
		(void) sprintf (NewName, "pat[%s]", host);
		execl ("pat", NewName, "2e", CPNULL);
		fatal ("execl");
		syslog (LOG_ERR, "execl");
		_exit(1);
	}
	while ((i = wait3 (&status, 0, &rusage)) != -1) {
		if (i == Pid) {
			char	Results[256];

			(void) time (&time1);
			(void) sprintf (Results, "Real %ld:%02ld, User %ld:%02ld, Sys %ld:%02ld, MaxRSS %ldKb",
			    (time1-time0)/60, (time1-time0)%60,
			    rusage.ru_utime.tv_sec/60,
			    rusage.ru_utime.tv_sec%60,
			    rusage.ru_stime.tv_sec/60,
			    rusage.ru_stime.tv_sec%60,
			    rusage.ru_maxrss);
			syslog (LOG_INFO, Results);
		}
	}
	exit(0);
}

fatal(s)
char	*s;
{
	extern char	*MyName;

	fprintf(stderr, "%s: ", MyName);
	perror(s);
	exit(1);
}
