/*
 * Include file for the oed2 program.
 *
 * Copyright (c) 1990 Paul Pomes
 * Copyright (c) 1990 University of Illinois Board of Trustees
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of Illinois, Urbana.  In addition, redistribution
 * and use must conform to the terms listed in the Copying file in
 * this directory.
 *
 * The name of the University may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @(#)$Header: /usr/local/src/cso/oed2/RCS/oed2.h,v 2.0.0.1 90/03/30 15:26:48 paul Exp $
 */

#include	<stdio.h>
#include	<ctype.h>
#include	<strings.h>
#include	<syslog.h>
#include	<signal.h>
#include	<fcntl.h>
#include	<sys/errno.h>
#include	<sys/wait.h>
#include	<sys/types.h>
#include	<sys/file.h>
#include	<sys/time.h>
#include	<sys/resource.h>

#define		PATCHLEVEL		0

#ifdef REMOTE

/* For remote service, the name of the service and service host */
# ifndef PAT_SERVICE
#  define	PAT_SERVICE		"pat"
# endif /* ! PAT_SERVICE */

# ifndef PAT_HOST
#  define	PAT_HOST		"oed2.cso.uiuc.edu"
# endif /* ! PAT_HOST */
#else /* ! REMOTE */
# define	PAT_PGM			"/usr/local/bin/pat"
# define	OED2			"/oed4/2e/2e"
#endif	/* REMOTE */

/* Default pager */
#ifndef MYPAGER
# ifdef hpux
#  define	MYPAGER			"/usr/bin/more"
# else /* ! hpux */
#  define	MYPAGER			"/usr/ucb/more -fs"
# endif /* hpux */
#endif /* ! MYPAGER */

/* some handy defines */
#define		CHNULL			('\0')
#define		CPNULL			((char *) NULL)
#define		FILENULL		((FILE *) NULL)

/* some handy compare operators */
#define		nequal(s1,s2,n)		(strncasecmp (s1, s2, n) == 0)
#define		equal(s1,s2)		(strcasecmp (s1, s2) == 0)

/* Trace macros for debugging flags (from sendmail) */
#define		tTd(flag, level)	(tTdvect[flag] >= level)
#define		tTdlevel(flag)		(tTdvect[flag])

/* String size */
#define		MAXSTR			256

/* LARGE block size */
#define		MAXBLK			4096

/* Size of PID table.  This should be linked to NFILES, but 20 is plenty. */
#define		MAX_PIDS		20

/* Size of offset table maintained by PatCapture() */
#define		MAX_OFFSETS		500

/* Maximum number of matches to print for any one prt* command */
#define		MAX_MATCH		20

/*
 * Miscellaneous global values:
 */

#ifndef	MAIN

/* How program was invoked (argv[0]) for error messages */
extern char	*MyName;

/* Operating as daemon if set (-D) */
extern int	Daemon;

/* Use syslog for errors if set (-l) */
extern int	lflag;

/* Trace vector for debugging flags (from sendmail) */
extern unsigned char	*tTvect;
extern unsigned char	tTdvect[100];
extern int		tTsize;

/* How we die.  Assume horribly unless reset */
extern int	ExitStat;

/* Select and print modes */
extern unsigned	int	Mode;
extern unsigned int	PrtMode;

/* Block of offsets used by prt #N commands, collected by PatCapture() */
extern unsigned long	PatOffsets[];

/*
 * Table of active process IDs from fork() and popen().  In local mode,
 * the pat child pid is assumed to be PidTab[fileno(ToPat)].
 */
extern int		PidTab[];

# ifdef REMOTE
/* What server to contact */
extern char	Oed2Host[];

# else /* ! REMOTE */
/* name of OED2 data file for non-REMOTE use */
extern char	*Oed2Name;

# endif /* ! REMOTE */

/* Streams for Pat I/O */
extern FILE	*ToPat, *FromPat;

/* Alternate output streams */
extern char	RdrName[], TeeName[];
extern FILE	*RdrStrm, *TeeStrm;

/* What display pager program to use */
extern char	Pager[];

/* How to invoke oed2 */
extern char	*usage[];
#endif /* ! MAIN */

/* Error numbers and text */
extern int	errno;
extern char	*sys_errlist[];

#define		ERR			(sys_errlist[errno])

/* Formatting modes */
#define		F_PAT			((unsigned int) 0x1)
#define		F_ROFF			((unsigned int) 0x2)
#define		F_NROFF			((unsigned int) 0x4)
#define		F_SIMPLE		((unsigned int) 0x8)
#define		F_VT200			((unsigned int) 0x10)
#define		FORMAT_MASK		((unsigned int) 0xFF)

/* Selection modes */
#define		S_ALL			((unsigned int) 0x100)
#define		S_ETYM			((unsigned int) 0x200)
#define		S_DEF			((unsigned int) 0x400)
#define		S_QUOTE			((unsigned int) 0x800)
#define		SELECT_MASK		((unsigned int) 0xF00)

/* Printing modes */
#define		P_STD			((unsigned int) 0x1000)
#define		P_TEE			((unsigned int) 0x2000)
#define		P_FILE			((unsigned int) 0x4000)
#define		P_PFILE			((unsigned int) 0x8000)
#define		PRINT_MASK		((unsigned int) 0xF000)

/* OED2 Tags */
#define		TAG_NS		1	/* (#) Number of Sense (I, 1, a, etc) */
#define		TAG_A		2	/* The Author of quote or book cited */
#define		TAG_BL		3	/* Bold Lemma */
#define		TAG_CF		4	/* Cited Form */
#define		TAG_D		5	/* Date (of Quotation) */
#define		TAG_DAT		6	/* Date (other than a Quotation Date) */
#define		TAG_DEF		7	/* Definition */
#define		TAG_E		8	/* Entry */
#define		TAG_EQ		9	/* Earliest Quote */
#define		TAG_ET		10	/* Etymology */
#define		TAG_ETN		11	/* Etymology Note */
#define		TAG_FS		12	/* Foreign Script (1e relic) */
#define		TAG_HG		13	/* Headword Group */
#define		TAG_HL		14	/* Headword Lemma */
#define		TAG_HO		15	/* Homonym Number */
#define		TAG_IL		16	/* Italic Lemma */
				/* IPA: International Phonetic Alphabet */
#define		TAG_IPH		17	/* IPA Phonetics */
#define		TAG_IPR		18	/* IPA Pronunciation */
#define		TAG_L		19	/* Language name */
#define		TAG_LB		20	/* Label */
#define		TAG_LF		21	/* Lookup Form */
#define		TAG_LQ		22	/* Latest Quote */
#define		TAG_MF		23	/* Murray Form */
#define		TAG_MPR		24	/* Murray Pronunciation */
#define		TAG_NB		25	/* Note */
#define		TAG_OLD		26	/* Old sense number */
#define		TAG_PQP		27	/* Pseudo Quotation Paragraph
					   (paragraph within a quotation
					   paragraph) */
#define		TAG_PS		28	/* Part of Speech */
#define		TAG_PSA		29	/* Pseudonymous Author */
#define		TAG_Q		30	/* Quotation */
#define		TAG_QP		31	/* Quotation Paragraph */
#define		TAG_RX		32	/* Cross Reference to a Preceding Quote,
					   Sense, etc. */
#define		TAG_S0		33	/* Sense 0 */
#define		TAG_S1		34	/* Sense 1 */
#define		TAG_S2		35	/* Sense 2 */
#define		TAG_S3		36	/* Sense 3 */
#define		TAG_S4		37	/* Sense 4 */
#define		TAG_S5		38	/* Sense 5 */
#define		TAG_S6		39	/* Sense 6 */
#define		TAG_S7		40	/* Sense 7 */
#define		TAG_S8		41	/* Sense 8 */
#define		TAG_SE		42	/* Sub-Entry */
#define		TAG_SF		43	/* Stressed Form (IPA) */
#define		TAG_SN		44	/* Sense Number */
#define		TAG_SQ		45	/* Subsidiary Quote */
#define		TAG_SSE		46	/* Sub-Sub-Entry */
#define		TAG_ST		47	/* Status */
#define		TAG_T		48	/* Text (of a Quotation) */
#define		TAG_VD		49	/* Variant Date */
#define		TAG_VF		50	/* Variant Form */
#define		TAG_VL		51	/* Variant Form List */
#define		TAG_W		52	/* Work (Title within a Quotation) */
#define		TAG_XDAT	53	/* Cross Reference Date */
#define		TAG_XIL		54	/* Cross Reference Italic Lemma */
#define		TAG_XL		55	/* Cross Reference Lemma */
#define		TAG_XR		56	/* Cross Reference */
#define		TAG_b		57	/* Bold */
#define		TAG_bka		58	/* S7 typographies */
#define		TAG_bkn		59	/* S7 typographies */
#define		TAG_col		60	/* Typesetting sludge (ignore) */
#define		TAG_cols	61	/* Typesetting sludge (ignore) */
#define		TAG_dn		62	/* Fraction denominator */
#define		TAG_form	63	/* Chemical formula */
#define		TAG_fr		64	/* Fraction */
#define		TAG_frac	65	/* Fraction */
#define		TAG_gk		66	/* Greek */
#define		TAG_i		67	/* Italics */
#define		TAG_in		68	/* (???) */
#define		TAG_just	69	/* Typesetting sludge (ignore) */
#define		TAG_ln		70	/* (???) */
#define		TAG_note	71	/* Note */
#define		TAG_nu		72	/* Fraction numerator */
#define		TAG_p		73	/* Paragraph */
#define		TAG_r		74	/* Roman */
#define		TAG_sc		75	/* Small Capitals */
#define		TAG_su		76	/* SuperScript */
#define		TAG_table	77	/* Typesetting sludge (ignore) */
#define		TAG_SSSE	78	/* Sub-Sub-Sub-Entry */
#define		TAG_chem	79	/* Chemical formula */
#define		TAG_bch		80	/* (???) */
#define		TAG_ov		81	/* (???) */
#define		TAG_CO		82	/* (???) */
#define		TAG_CU		83	/* (???) */

/* Tag actions */
#define		SKIP		0	/* Skip to end of tag (must be 0) */
#define		FONTB		1	/* Change to Bold font */
#define		FONTI		2	/* Change to Italic font */
#define		FONTP		3	/* Change to Previous font */
#define		FONTR		4	/* Change to Roman font */
#define		NEWL		5	/* Insert a newline */
#define		PARA		6	/* Start a new paragraph */
#define		SPACE		7	/* Insert a space character */
#define		NO_OP		8	/* Nothing special to do */
#define		UP		9	/* Up for ROFF, '[' for SIMPLE */
#define		DOWN		10	/* Down for ROFF, ']' for SIMPLE */
#define		L_SQ		UP
#define		R_SQ		DOWN
#define		S_C		11	/* Print in small capitals */
#define		SLASH		12	/* Print '/' for fractions */
#define		FONTPS		13	/* Paren, previous font, space */
#define		FONTIP		14	/* Paren, italic font */
#define		PAREN		15	/* Text within ()s */

/*
 * All action values must fit into the bit-field widths below.  4 bits
 * allows for 0 to 15 actions.  
 */
struct	TAG {
	int	Value;		/* from types above */
	char	*String;	/* character string for tag used in OED2 data */
	unsigned all_s:4;	/* action for starting tag, mode ALL */
	unsigned all_e:4;	/* action for ending tag, mode ALL */
	unsigned etym_s:4;	/* action for starting tag, mode ETYM */
	unsigned etym_e:4;	/* action for ending tag, mode ETYM */
	unsigned def_s:4;	/* action for starting tag, mode DEF */
	unsigned def_e:4;	/* action for ending tag, mode DEF */
	unsigned quote_s:4;	/* action for starting tag, mode QUOTE */
	unsigned quote_e:4;	/* action for ending tag, mode QUOTE */
};

#define		TAGNULL		((struct TAG *) NULL)

/*
 * How to print OED2 special symbols.  The vt200Str is usually encoded as
 * "<select><char>" where <select> is one of A, M, T, or S.  Those letters
 * select the ASCII, Multi-National, Technical, or Special Graphics character
 * sets respectively.  The second char selects the particular special char.
 * Arbitrary strings may follow the 'A' select character.
 */
struct	SYM {
	char	*String;	/* symbol character string used in OED2 data */
	char	*RoffStr;	/* representation for n/troff formatting */
	char	*SimpleStr;	/* representation for simple formatting */
	char	*vt200Str;	/* VT200 representation */
};

#define		SYMNULL		((struct SYM *) NULL)
