/*
 * Copyright (c) 1990 Paul Pomes
 * Copyright (c) 1990 University of Illinois Board of Trustees
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of Illinois, Urbana.  In addition, redistribution
 * and use must conform to the terms listed in the Copying file in
 * this directory.
 *
 * The name of the University may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char rcsid[] = "@(#)$Header: /usr/local/src/cso/oed2/RCS/SetMode.c,v 2.0 90/03/10 12:19:41 paul Exp $";
#endif /* lint */

#include	"oed2.h"

/*
 * SetMode -- return the mode bit that map to argument char
 *
 *	Parameters:
 *		InChar -- char argument 
 *	Returns:
 *		unsigned integer bit pattern
 *	Side effects:
 *		Prints error messages for bogus characters
 *	Deficiencies:
 *
 */

unsigned int
SetMode (InChar)
char	InChar;
{
	unsigned int	result = (unsigned int) 0;

	if (tTd(11,1))
		printf ("SetMode: Using %c\n", InChar);
	switch (InChar) {

	    /* Output modes */
	    case '2':
		result |= F_VT200;
		break;

	    case 's':
		result |= F_SIMPLE;
		break;

	    case 'r':
		result |= F_ROFF;
		break;

	    case 'n':
		result |= F_NROFF;
		break;

	    case 'p':
		result |= F_PAT;
		break;

	    /* Selection modes */
	    case 'a':
		result |= S_ALL;
		break;

	    case 'e':
		result |= S_ETYM;
		break;

	    case 'q':
		result |= S_QUOTE;
		break;

	    case 'd':
		result |= S_DEF;
		break;

	    default:
		Error ("SetMode: Unknown mode character (%c)", InChar);
		break;
	}
	return (result);
} /* SetMode */
