/*
 * Copyright (c) 1990 Paul Pomes
 * Copyright (c) 1990 University of Illinois Board of Trustees
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of Illinois, Urbana.  In addition, redistribution
 * and use must conform to the terms listed in the Copying file in
 * this directory.
 *
 * The name of the University may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char rcsid[] = "@(#)$Header: /usr/local/src/cso/oed2/RCS/LoadMatch.c,v 2.0 90/03/10 12:19:28 paul Exp $";
#endif /* lint */

#include	"oed2.h"

/*
 * LoadMatch -- Load OED2 entry into memory
 *
 *	This routine is slightly tricky in that state information needs to
 *	maintained between calls.  A single "pr.docs.E" command to pat returns
 *	all the matches selected.  To keep memory usage rational, only one
 *	entry is read at a time.  The fread()s however, will overlap between
 *	entries leaving a partial block that must be preserved for the next
 *	call to LoadMatch().  If the single parameter LastMatch == 1, then
 *	keep reading until the ">> " prompt is seen.
 *
 *	Parameters:
 *		LastMatch - set if this is the last match
 *	Returns:
 *		Pointer to malloc'ed block containing null-terminated entry.
 *	Side effects:
 *		Keeps a static buffer pointer around for reading multiple
 *		matches.
 *	Deficiencies:
 */

char *
LoadMatch (LastMatch)
int	LastMatch;
{
	static char	*Entry = CPNULL;	/* loaded entry block */
	char		*EntryPnt = CPNULL;	/* pointer into entry block */
	char		*LastPnt;		/* previous value of EntryPnt */
	char		*RetPnt;		/* pointer to return */
	unsigned int	Size = MAXBLK;		/* requested size of Entry */
	int		ReadCnt = 0;		/* number of characters read */
	int		i, j;			/* good ol' i and friend */
	extern char	*Malloc(), *Realloc();

	/*
	 * See if we have been here before.  If we have, then there is a
	 * partial buffer remaining.  Copy it to a fresh buffer and start
	 * again.
	 */
	if (Entry != CPNULL) {
		if (tTd(5,1))
			printf ("LoadMatch: Taking up where we left off.\n");

		/* Allocate a fresh buffer */
		LastPnt = Malloc (Size);

		/* Find the newline and copy from there to fresh buffer */
		if ((EntryPnt = index (Entry, '\n')) == CPNULL) {
			if (tTd(5,3))
				printf ("LoadMatch: Entry w.o. nl =%s=\n", Entry);
			(void) fflush (stdout);
			Fatal ("LoadMatch: No newline in old buffer");
		}
		
		/* Skip over the newline and save remainder. */
		EntryPnt++;
		j = strlen (EntryPnt);
		(void) strcpy (LastPnt, EntryPnt);

		/* Let the old buffer go */
		(void) free (Entry);
		Entry = LastPnt;
		if (tTd(5,3)) {
			printf ("LoadMatch: Left over fragment =%s=\n", Entry);
			(void) fflush (stdout);
		}

		/* Reset other state variables */
		ReadCnt = j;
		LastPnt = Entry;
		EntryPnt = Entry + j;
	}
	else {
		if (tTd(5,1))
			printf ("LoadMatch: First time through for this word.\n");

		/* Malloc an initial chunk. */
		LastPnt = EntryPnt = Entry = Malloc (Size);
		*LastPnt = CHNULL;
	}

	/*
	 * Fill'er up.  Stop when a newline is found or "\n>> " if LastMatch
	 * is set.
	 */
	for (;;) {
		if (LastMatch) {
			if (EntryPnt >= (Entry + 3) &&
			    nequal ((EntryPnt-3), ">> ", 3))
				break;
		}
		else if (index (LastPnt, '\n') != CPNULL)
			break;
		if (ReadCnt == (MAXBLK - 1)) {
			i = EntryPnt - Entry;
			Entry = Realloc (Entry, (Size += ((unsigned) MAXBLK)));
			LastPnt = EntryPnt = Entry + i;
			ReadCnt = 0;
		}
		errno = 0;
		j = fread (EntryPnt, 1, ((MAXBLK - 1) - ReadCnt), FromPat);
		if (tTd(5,2))
			printf ("LoadMatch: Tried for %d, read %d bytes, errno %d\n",
			    ((MAXBLK-1) - ReadCnt), j, errno);
		if (j == 0) {
			if (errno == EWOULDBLOCK || errno == 0) {
				if (ferror (FromPat))
					clearerr (FromPat);
				sleep (1);
				continue;
			}
			else
				Fatal ("LoadMatch: fread: %s", ERR);
		}
		LastPnt = EntryPnt;
		ReadCnt += j;
		EntryPnt += j;
		*EntryPnt = CHNULL;
		if (tTd(5,3))
			printf ("LoadMatch: fread block =%s=\n", LastPnt);
	}
	if (tTd(5,3) || tTd(16,3)) {
		printf ("LoadMatch: First entry fragment: =%s=\n", Entry);
		(void) fflush (stdout);
	}

	/*
	 * Skip over leading text, then search for the end of entry.  Copy
	 * to a buffer that FmtEntry() can throw away later.
	 */
	if ((EntryPnt = index (Entry, '<')) == CPNULL)
		Fatal ("LoadMatch: Unexpected end of entry (no starting < )");
	if ((LastPnt = index (Entry, '\n')) == CPNULL)
		Fatal ("LoadMatch: No newline in entry");

	/* Back up over the ".\n" at the end of an entry. */
	LastPnt -= 2;

	/* Determine the length of the entry */
	ReadCnt = LastPnt - EntryPnt;

	/* Malloc some space for it and copy */
	RetPnt = Malloc ((unsigned) (ReadCnt + 1));
	(void) strncpy (RetPnt, EntryPnt, ReadCnt);
	*(RetPnt + ReadCnt) = CHNULL;
	if (tTd(5,3)) {
		printf ("LoadMatch: Pre-fmt entry: =%s=\n", RetPnt);
		(void) fflush (stdout);
	}

	/* Garbage collect if this is it */
	if (LastMatch) {
		if (tTd(5,1))
			printf ("LoadMatch: No more matches, garbage collecting\n");
		(void) free (Entry);
		Entry = CPNULL;
	}

	return (RetPnt);
} /* LoadMatch */
