/*
 * Copyright (c) 1990 Paul Pomes
 * Copyright (c) 1990 University of Illinois Board of Trustees
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of Illinois, Urbana.  In addition, redistribution
 * and use must conform to the terms listed in the Copying file in
 * this directory.
 *
 * The name of the University may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifdef	REMOTE
# ifndef lint
static char rcsid[] = "@(#)$Header: /usr/local/src/cso/oed2/RCS/ContactPat.c,v 2.0 90/03/10 12:19:18 paul Exp $";
# endif /* lint */

# include	"oed2.h"
# include	<netdb.h>
# include	<sys/uio.h>
# include	<sys/socket.h>
# include	<netinet/in.h>

/*
 *  ContactPat -- Connect to the Pat server
 *
 *	Examine the ToPat and FromPat file descriptors.  If NULL, open
 *	socket connections to the Pat server.  Exits on any error.
 *
 *	Parameters:
 *		none
 *	Returns:
 *		None
 *	Side Effects:
 *		Changes ToPat and FromPat if an open is done.
 */

ContactPat ()
{
	int		sock;		/* our socket */
	struct sockaddr_in Pat;		/* the address of the Pat server */
	struct servent	*Ps;		/* Pat service entry */
	struct hostent	*Host;		/* host entry for Pat server */
	extern FILE	*ToPat, *FromPat;	/* read/write streams to Pat */

	/* Already opened... */
	if (ToPat != FILENULL && FromPat != FILENULL) {
		if (tTd(2,1))
			printf ("ContactPat: ToPat/FromPat already opened\n");
		return;
	}

	/* Get a socket for the Pat connection */
	if ((sock = socket (AF_INET, SOCK_STREAM, 0)) < 0)
		Fatal ("ContactPat: socket: %s", ERR);
	if (tTd(2,5))
		if (setsockopt (sock, SOL_SOCKET, SO_DEBUG, CPNULL, 0) < 0)
			Error ("ContactPat: Cannot set SO_DEBUG on socket: %s", ERR);
	Pat.sin_family = AF_INET;

	/* Locate the proper port */
	if (Ps = getservbyname (PAT_SERVICE, "tcp")) {
		Pat.sin_port = Ps->s_port;
	} else {
		Warning ("\nContactPat: Service \"%s\" unknown - using 619", PAT_SERVICE);
		Pat.sin_port = htons ((unsigned short) 619);
	}

	/* Locate the proper host */
	if (Host = gethostbyname (Oed2Host)) {
		bcopy (Host->h_addr, (char *) &Pat.sin_addr.s_addr, 4);
	} else
		Fatal ("ContactPat: gethostbyname (%s): %s", Oed2Host, ERR);

	/* Connect to the Pat server */
	if (tTd(2,1))
		printf ("ContactPat: Connecting to port %hu on host %s\n",
			ntohs (Pat.sin_port), Oed2Host);
	if (connect (sock, (struct sockaddr *) &Pat, sizeof (Pat)) < 0)
		Fatal ("\nContactPat: Connect failure, Host %s, port %hu: %s",
			inet_ntoa (Pat.sin_addr), ntohs (Pat.sin_port), ERR);

	/* Set non-blocking output from child */
	if (fcntl (sock, F_SETFL, FNDELAY) == -1)
		Fatal ("ContactPat: sock fcntl(FNDELAY): %s", ERR);

	/* Connection ok, change to canonical form */
	if ((ToPat = fdopen (sock, "w")) == FILENULL)
		Fatal ("ContactPat: fdopen(sock w): %s", ERR);
	(void) setbuf (ToPat, CPNULL);
	if ((FromPat = fdopen (sock, "r")) == FILENULL)
		Fatal ("ContactPat: fdopen(sock r): %s", ERR);
	return;
} /* ContactPat */
#endif	/* REMOTE */
