#==============================================================================
# Site specific configuration (OS/2)
#==============================================================================
## [BEGIN]
#
# option switches
# (do not remove the lines starting with "##" !!!)
#
# language: select the language you prefer
##-LANG_GERMAN=Y
#
# debug mode: select this to enable debugging of the software
##-DEBUG_MODE=Y
#
# dynamic linking: if enabled, linking is dynamic to C compiler
##-DYNAMIC_LINKING=Y
#
# Top of Minerva install tree (INST_DIR uses '\\', INSTPATH only '\')
##+INST_DIR=\\public\\mSQL
INST_DIR=\\public\\mSQL
##+INSTPATH=\public\mSQL
INSTPATH=\public\mSQL
#
# TCP/IP port number for client-server communication
##+TCPIP_PORT=4333
TCPIP_PORT=4333
#
## [END]
#==============================================================================
# do not change anything below!
#==============================================================================
#
# compiler, linker, library tools ...
#
ENV      = OS2
CC       = icc
CPP      = $(CC)
LINK     = $(CC)
LLINK    = link386 /noi /nol /pm:VIO /se:1024 /st:32768
RANLIB   = lib /nologo /noignorecase /noextdictionary
DLLLIB   = implib /nologo /noignorecase

# compiler-compiler
YACC     = bison
YFLAGS   = -d -o

#
# Specify the language you want for error messages
#
!ifdef LANG_GERMAN
LANG     = GERMAN
!else
LANG     = ENGLISH
!endif

#
# special definitions
#
SIGLIST  =
DIRENT   = /idirect.h
MMAP     =
U_INT    =
ROOT_EXEC=
ROOT     = mSQL

#
# specials for makedep
#
INCLUDEDIR    = $(INST_DIR)\\include
OBJSUFFIX     = .obj

# Directory for pid file
PID_DIR  = $(INST_DIR)\\tmp

# Extra libraries if required
EXTRA_LIB=

# Any other CFlags required
EXTRA_CFLAGS= /D$(ENV) /D$(LANG) /DMSQL_PORT=$(TCPIP_PORT)\
 /DMSQL_UNIX_ADDR="\"$(INST_DIR)\\tmp\\mSQL.sok\""

# dynamic / static linking, default libraries
!ifdef DYNAMIC_LINKING
LINKING  = /DDYNAMIC_LINKED /Gd
!else
LINKING  = /DSTATIC_LINKED
!endif

# default libraries (static, dynamic)
TCPIP_LIBS = so32dll.lib tcp32dll.lib
LDLIBS   = ..\..\lib\mSQL.lib $(TCPIP_LIBS)
DLL_LIBS = ..\..\lib\mSQL_dll.lib

# debug mode on / off
!ifdef DEBUG_MODE
DEBUG    = /Ti+
!else
DEBUG    =
!endif

# flags for compiling, DLL and EXE linking
CFLAGS = /C $(LINKING) /G4 /Gf /Gi /Gm /Q /Se /Ss+ $(DEBUG)\
 /I..\ $(EXTRA_CFLAGS)
DFLAGS = /C $(LINKING) /G4 /Ge- /Gf /Gi /Gm /Q /Se /Ss+ $(DEBUG)\
 /I..\ $(EXTRA_CFLAGS)
LFLAGS = $(LINKING) /G4 /Ge+ /Gf /Gi /Gm $(DEBUG) /Fe

#
# EXPRIMENTAL - Don't play with this stuff
#
NEW_DB=
NEW_DB_INC=
NEW_DB_LIB=

#==============================================================================
# end of file
#==============================================================================
