.*------------------------------------------------------------------------------
.* W3-mSQL 1.0 (OS/2 version)
.*------------------------------------------------------------------------------
:userdoc.
:title.W3-mSQL 1.0 (OS/2 version)
.*------------------------------------------------------------------------------
.* 'Info'
.*------------------------------------------------------------------------------
:h1 id=info clear.Info
:lines align=left.
Gateway interface between WWW and mSQL
:hp4.W3-mSQL 1.0 for OS/2 2.x or Warp with TCP/IP:ehp4.
:elines.
:artwork name='hughes.bmp' align=center.
:lines align=center.
:hp8.All programs included in this package are provided "as is", without
any warranty! Try them on your own risk.
:ehp8.
:elines.
:p.This documentation is based on the HTML file w3-msql.htm and informations
coming with the :link reftype=hd refid=mails.mailing list:elink.. It is
based upon version 1.0 and has been adapted to the OS/2 port.
:p.W3-mSQL has been developed as part of the Minerva Network Management
Environment.
:p.Copyright (c) 1993 - 1996 David J. Hughes
:p.Adaption to OS/2 made by Dirk Ohme

.*------------------------------------------------------------------------------
.* 'Introduction'
.*------------------------------------------------------------------------------
:h1 id=introduction clear.Introduction
:p.W3-mSQL is an interface between the World-Wide Web (WWW) and mSQL. It
is a mechanism that can be used to greatly simplify the use of a Mini
SQL database behind a web server. Using W3-mSQL, you can embed SQL
queries within your pages and have the results generated on the fly. The
W3-mSQL program is used as a CGI script that your W3-MSQL enhanced pages
are passed through. It should be referenced as
:xmp.
    /<cgi-bin>/W3-mSQL/<path_to_your>/page.html
:exmp.
:p.where :hp1./<path_to_your>/page.html:ehp1. is a W3_mSQL enhanced HTML
file within your WWW document tree. W3_mSQL will process the specifuied
page and "fill in the blanks" by interpreting and processing the
embedded mSQL commands.

.*------------------------------------------------------------------------------
.* 'The W3_mSQL language'
.*------------------------------------------------------------------------------
:h1 id=language clear.The W3_mSQL language
:p.A W3_mSQL directive is embedded within an HTML page using the
following syntax&colon.
:xmp.
    <! msql command args>
:exmp.
:p.The commands that are available are&colon.
:lm margin=5.
:ul.
:li.:link reftype=hd refid=c_connect.<! msql connect [host]>:elink.
:li.:link reftype=hd refid=c_close.<! msql close>:elink.
:li.:link reftype=hd refid=c_database.<! msql database DBName>:elink.
:li.:link reftype=hd refid=c_query.<! msql query "query text" QueryHandle>
:elink.
:li.:link reftype=hd refid=c_free.<! msql free QueryHandle>:elink.
:li.:link reftype=hd refid=c_print.<! msql print "format">:elink.
:li.:link reftype=hd refid=c_print_rows.<! msql print_rows QueryHandle
"format">:elink.
:li.:link reftype=hd refid=c_if.<! msql if (condition)>:elink.
:li.:link reftype=hd refid=c_if.<! msql else>:elink.
:li.:link reftype=hd refid=c_if.<! msql fi>:elink.
:li.:link reftype=hd refid=c_fetch.<! msql fetch QueryHandle>:elink.
:li.:link reftype=hd refid=c_seek.<! msql seek QueryHandle Position>:elink.
:li.:link reftype=hd refid=c_set.<! msql set Variable = Value>:elink.
:hp8.*:ehp8.
:li.:link reftype=hd refid=c_translate.<! msql translate Variable
"Char1" "Char2">:elink. :hp8.*:ehp8.
:eul.
:lm margin=1.
:note.
Commands marked with an asteriks (:hp8.*:ehp8.) are undocumented features not
mentioned in the original documentation.
:p.There are further these internal variables available&colon.
:lm margin=5.
:ul.
:li.:link reftype=hd refid=v_num_fields.variable $NUM_FIELDS:elink.
:li.:link reftype=hd refid=v_num_rows.variable $NUM_ROWS:elink.
:eul.
:lm margin=1.

.*------------------------------------------------------------------------------
.* 'msql connect'
.*------------------------------------------------------------------------------
:h2 id=c_connect clear.msql connect
:xmp.
  <! msql connect [host]>
:exmp.
:p.Connect to the mSQL database engine. An option :hp1.hostname:ehp1. can be
provided to indicate that the database is running on a remote machine, for
example&colon.
:xmp.
  <! msql connect www.some.domain>
:exmp.
:p.Unlike the C programming language API for mSQL, you can only have one
connection to a database server from within your W3-mSQL page. You can access
multiple databases from the one connection by using the :link reftype=hd
refid=c_database.database:elink. directive.

.*------------------------------------------------------------------------------
.* 'msql close'
.*------------------------------------------------------------------------------
:h2 id=c_close clear.msql close
:xmp.
  <! msql close>
:exmp.
:p.Close the currently open mSQL database connection. You should call the
:hp2.close:ehp2. directive when you are finished with the database from within
your page. Once you have closed the connection, you could open a new connection
to another database server if your page requires data held in mSQL servers on
different machines.

.*------------------------------------------------------------------------------
.* 'msql database'
.*------------------------------------------------------------------------------
:h2 id=c_database clear.msql database
:xmp.
  <! msql database DBName>
:exmp.
:p.Choose the database that you wish to access from your queries, for example
&colon.
:xmp.
  <! msql database test
:exmp.
:p.If you need to access data from multiple database managed by the same mSQL
server, you can simply issue the :hp2.database:ehp2. directive again to select
a new database to use. There is no limit to the number of times you can call
the :hp2.database:ehp2. directive in a single page so you can literaly swap
back and forth between databases at any time.

.*------------------------------------------------------------------------------
.* 'msql query'
.*------------------------------------------------------------------------------
:h2 id=c_query clear.msql query
:xmp.
  <! msql query "query text" QueryHandle>
:exmp.
:p.Submit a query to the database. The :hp1.query text:ehp1. is submitted to
the database and any returned data is stored in the :hp1.QueryHandle:ehp1.. You
use the :hp1.QueryHandle:ehp1. to access the data later in your page. For
example&colon.
:xmp.
  <! msql query "select name from users" q1>
:exmp.
:p.Once the query has been processed, the first row of the returned data is
:link reftype=hd refid=c_fetch.fetched:elink. and stored in the query handle.
The row of data currently stored in the query handle is called the
:hp2.current row:ehp2.. The :link reftype=hd refid=c_fetch.fetch:elink. and
:link reftype=hd refid=c_seek.seek:elink. directives are provided by W3-mSQL
to allow you to use other data rows as the :hp2.current row:ehp2.. Another term
used in association with the current row is the position of the data cursor.
The :hp2.data cursor:ehp2. is a logical pointer that indicates which row of
the result table is the current row. The :link reftype=hd
refid=c_seek.seek:elink. directive can be used to move the location of the
data cursor and hence, change the current row.
:note.
The example above uses the SELECT SQL keyword. If should be noted however that
any SQL query, including INSERT, UPDATE and DELETE can be used within the query
text submitted via the :hp2.query:ehp2. directive. Naturally, if anything other
than SELECT is used, there will be no returned data available to the page. Use
of query operators other than SELECT allows you to write HTML pages that
actually modify the contents of the database. A simple example of this is to
insert the contents of an HTML form into the database.
:note.
Access to :hp8.empty:ehp8. handles result in an uncontrolled behavior of
W3-mSQL. Therefor it is recomended to check the number of lines returned first
before output (see variable :link reftype=hd
refid=v_num_rows.$NUM_ROWS:elink.)&colon.
:xmp.
  <! msql if ($NUM_ROWS != 0)>
  ... data output ...
  <! fi>
:exmp.

.*------------------------------------------------------------------------------
.* 'msql free'
.*------------------------------------------------------------------------------
:h2 id=c_free clear.msql free
:xmp.
  <! msql free QueryHandle>
:exmp.
:p.Frees the :hp1.QueryHandle:ehp1. and any data associated with the query.
For example&colon.
:xmp.
  <! msql free q1>
:exmp.

.*------------------------------------------------------------------------------
.* 'msql print'
.*------------------------------------------------------------------------------
:h2 id=c_print clear.msql print
:xmp.
  <! msql print "format">
:exmp.
:p.Print the contents of variables from the current row of the query handle,
the environment or from data passed to the page from a GET or POST (such as
from a form). The :hp1.format:ehp1. string is similar to a printf() format
string in that escape characters such as :hp9.\n:ehp9. and :hp9.\t:ehp9. are
understood. The contents of variables are accessed by embedding the variables
within the format string (like Perl, ESL or shell scripts) rather than by
using references to variables such as %s, etc. in C.
:note.
The order of priority for variables is internal W3-mSQL variables followed
by environment variables.
:p.That is, when a variable is accessed, W3-mSQL first looks for the variable
in the W3-mSQL symbol table and if it can't find it, it then looks for an
environment variable by that name. The first variable it finds that matches
the name specified is used.
:p.To simplify the processing of forms (and to enable data to be passed between
pages) W3-mSQL loads all data passed to it in the URL into it's symbol table.
If you have a form entry such as :hp2.<INPUT NAME="user">:ehp2. then when you
click the submit button, your browser will generate a URL like the following
:xmp.
  http&colon.//Your.Machine/Path/To/File.html?user=bambi
:exmp.
:p.The :hp2.?user=bambi:ehp2. on the end of the URL reflects the name and
contents of your form fields. W3-mSQL will see these values and load them into
the symbol table so you can access them as variables in your page. If you
referenced the variable :hp2.$user:ehp2. in this example it would evaluate to
:hp2.bambi:ehp2..
:p.As the example above indicates, variables are referenced using a
:hp9.$:ehp9. sign. This is the case for internal variables and environment
variables. Accessing the contents of the current row from a query handle uses
a different format. Firstly, you have to indicate which query handle contains
the information and secondly you have to indicate which field from the current
row you want. The format used is
:xmp.
  :hp9.@Handle.FieldOffset:ehp9.
:exmp.
:p.That is, you first use a :hp9.@:ehp9. for database variables (not the $ sign
used for internal and environment variables), followed by the name of the
:hp1.query handle:ehp1., followed by a ':hp9..:ehp9.', followed by the
numerical index of the desired field in the row. Fields are numbered left to
right starting at :hp2.0:ehp2.. To illustrate this further, if the following
query
:xmp.
  <! msql query "select name, age from people" result>
:exmp.
:p.was submitted, :hp2.@result.0:ehp2. would correspond to the :hp2.name:ehp2.
field and :hp2.@result.1:ehp2. would correspond to the :hp2.age:ehp2. field.
You can reference any number of fields and other variables in a single format
string. For example&colon.
:xmp.
  <! msql print "Hello @result.0, your path is $PATH">
:exmp.

.*------------------------------------------------------------------------------
.* 'msql print_rows'
.*------------------------------------------------------------------------------
:h2 id=c_print_rows clear.msql print_rows
:xmp.
  <! msql print_rows QueryHandle "format">
:exmp.
:p.The :hp2.print_rows:ehp2. directive allows the entire contents of a
:hp1.QueryHandle:ehp1. to be processed in one operation. The :hp1.format:ehp1.
specified is applied to each row of the remaining result data from the query
handle, that is, all data from the position of the :hp2.data cursor:ehp2. to
the end of the result data is extracted and formatted. If the data cursor has
been moved from the first row of data using either :link reftype=hd
refid=c_fetch.fetch:elink. or :link reftype=hd refid=c_seek.seek:elink.
directives, only the remaining data will be displayed. Naturally, the :link
reftype=hd refid=c_seek.seek:elink. directive can be used to return the data
cursor to the initial row of the result data before calling the
:hp2.print_rows:ehp2. directive.
:p.This facility can be used to easily create lists, tables and select menus
from the contents of a query. An example of each is given below&colon.
:ul.
:li.:hp2.Table Creation:ehp2.
:xmp.
    <! msql query "select name, address from staff" result>
    <TABLE>
    <TH>Name<TH>Address<TR>
    <! msql print_rows "<TD>@result.0<TD>@result.1<TR>\n">
    </TABLE>
:exmp.
:li.:hp2.List Creation:ehp2.
:xmp.
    <! msql query "select name, address from staff" result>
    <UL>
    <! msql print_rows "<LI>@result.0\n">
    </UL>
:exmp.
:li.:hp2.Select Menu Creation:ehp2.
:xmp.
    <! msql query "select name, address from staff" result>
    <SELECT NAME=menu>
    <! msql print_rows "<OPTION>@result.0\n">
    </SELECT>
:exmp.
:eul.

.*------------------------------------------------------------------------------
.* 'msql if, else, fi'
.*------------------------------------------------------------------------------
:h2 id=c_if clear.msql if, else, fi
:xmp.
  <! msql if (condition)>
  <! msql else>
  <! msql fi>
:exmp.
:p.W3-mSQL provides an if-then-else construct for conditional inclusion of
sections of an HTML page. If the condition evaluates to TRUE, the segment of
the page between the :hp2.IF:ehp2. and the :hp2.ELSE:ehp2. or :hp2.FI:ehp2. is
processed. This may be normal HTML text of further W3-mSQL definitions. To
enable complex pages to be created, W3-mSQL supports :hp2.IF:ehp2. clauses
nested to any level.
:p.The structure of the condition statement is based on the syntax used by
conditions in C. It supports the usual comparison operators, :hp9. == != < <=
> >=:ehp9., as well as the C logical operators :hp9.&amp.&amp.:ehp9. (logical
AND) and :hp9.||:ehp9. (logical OR). Parenthesis may be used within the
condition to group sections of the expression to control the evaluation.
Parenthesis can be nested to any level. For example&colon.
:xmp.
  <! msql if (($age < 50)&amp.&amp.(($name == "fred)||($name =="joe")))>
:exmp.
:p.The :hp2.IF:ehp2. directive will try to interpret the data and variables
within the condition in the manner you intend. For example, if you provide a
condition such as
:xmp.
  <! msql if ($age == 50)>
:exmp.
:p.W3-mSQL would cast the value of :hp1.$age:ehp1. to an integer value if
possible because all W3-mSQL variables are text variables. If the variable in
question does not contain a numeric string, the condition will abort and an
appropriate error will be displayed. It should be noted that only the
:hp9.==:ehp9. and :hp9.!=:ehp9. operators may be used to compare string values.
:hp9.<:ehp9., :hp9.<=:ehp9., :hp9.>:ehp9. and :hp9.>=:ehp9. can onyl be used
on numeric values. Naturally, :hp9.==:ehp9. and :hp9.!=:ehp9. can be used on
numeric data too.

.*------------------------------------------------------------------------------
.* 'msql fetch'
.*------------------------------------------------------------------------------
:h2 id=c_fetch clear.msql fetch
:xmp.
  <! msql fetch QueryHandle>
:exmp.
:p.Fetches the next row of data from the query handle and updates the
:hp1.current row:ehp1. and the :hp1.data cursor:ehp1. Exampe&colon.
:xmp.
  <! msql fetch q1>
:exmp.

.*------------------------------------------------------------------------------
.* 'msql seek'
.*------------------------------------------------------------------------------
:h2 id=c_seek clear.msql seek
:xmp.
  <! msql seek QueryHandle Position>
:exmp.
:p.Moves the :hp1.data cursor:ehp1. for the specified :hp1.QueryHandle:ehp1. to
the given position. Position :hp9.0:ehp9. is the first row in the result data.
If the value of position is negative, it will be replaced by :hp9.0:ehp9.. If
the position is beyond the end of the table, the :hp1.data cursor:ehp1. will be
left pointing at the end of the table. The :hp1.current row:ehp1. is replaced
by the row of data located at the specified position. For example, to move to
the :hp2.12th row:ehp2. of data returned in the query handle :hp2.q1:ehp2.,
you would call
:xmp.
  <! msql seek q1 12>
:exmp.

.*------------------------------------------------------------------------------
.* 'msql set'
.*------------------------------------------------------------------------------
:h2 id=c_set clear.msql set
:lines align=right.
:hp8.Undocumented command due to original documentation!:ehp8.
:elines.
:xmp.
  <! msql set Variable = Value>
:exmp.
:p.Set an internal variable :hp1.Variable:ehp1. to a given :hp1.Value:ehp1..
:hp1.Value:ehp1. can be either a string, another variable or a handle, but no
combination of these.

.*------------------------------------------------------------------------------
.* 'msql translate'
.*------------------------------------------------------------------------------
:h2 id=c_translate clear.msql translate
:lines align=right.
:hp8.Undocumented command due to original documentation!:ehp8.
:elines.
:xmp.
  <! msql translate Variable "Char1" "Char2">
:exmp.
:p.Translates all characters :hp1.Char1:ehp1. of the given variable
:hp1.Variable:ehp1. by the replacement character :hp1.Char2:ehp1..

.*------------------------------------------------------------------------------
.* 'variable $NUM_FIELDS'
.*------------------------------------------------------------------------------
:h2 id=v_num_fields clear.variable $NUM_FIELDS
:p.The internal variable :hp2.NUM_FIELDSS:ehp2. is set at execution of a SELECT
query and reflects the number of fields (columns) found by the selection (see
:link reftype=hd refid=c_query.msql query:elink.).

.*------------------------------------------------------------------------------
.* 'variable $NUM_ROWS'
.*------------------------------------------------------------------------------
:h2 id=v_num_rows clear.variable $NUM_ROWS
:p.The internal variable :hp2.NUM_ROWS:ehp2. is set at execution of a SELECT
query and reflects the number of rows found by the selection (see :link
reftype=hd refid=c_query.msql query:elink.).

.*------------------------------------------------------------------------------
.* 'Example'
.*------------------------------------------------------------------------------
:h1 id=example clear.Example
:p.This section contains a simple example showing how to use the W3-mSQL tool.
In order to use the sample W3-mSQL page,
:lm margin=5.
:ol.
:li.you have to create a database called :hp1.test:ehp1.&colon.
:xmp.
  msqladm create test
:exmp.
:li.You then have to create a table called :hp1.test:ehp1. and fill it with
some test data&colon.
:xmp.
  msql test < sample.src

sample.src&colon.
  create table test (
    user   char(20),
    age    int,
    phone  char(20)
  )\g

  insert into test values ('David J. Hughes', 0, '0412 644 078')\g
  insert into test values ('Dirk Ohme', 25, '07071 703-190')\g

  \q
:exmp.
:li.Put the sample page :hp2.sample.htm:ehp2. in your HTML document path.
:li.Copy :hp2.W3-MSQL.EXE:ehp2. into your CGI directory.
:li.Access the sample page with your browser - be aware of the directory
mapping the WWW server uses. If for instance the browser maps an URL path
:hp2.\doc\:ehp2. to :hp2.\pub\www\:ehp2. and :hp2.sample.htm:ehp2. is located
in :hp2.\pub\www:ehp2., then you have to use an URL like this&colon.
:xmp.
  http&colon.//Your.Machine/CGI-Path/w3-msql/doc/sample.htm
:exmp.
:eol.
:lm margin=1.

.*------------------------------------------------------------------------------
.* 'Example W3-mSQL Page'
.*------------------------------------------------------------------------------
:h2 id=Example_page clear.Example W3-mSQL Page
:p.The following shows the contents of :hp2.sample.htm:ehp2., a sample page
showing access to a mSQL database&colon.
:xmp.
<HTML>
  <HEADER>
    <TITLE>w3-mSQL sample</TITLE>
  </HEADER>
  <BODY>
    <CENTER>
      <H1>Page Title</H1>
    </CENTER>

<!-- make a connection to the local database server, using database 'test' -->
<! msql connect>
<! msql database test>

    <H2>Bambi's phone number</H2>
    <P>
      <BLOCKQUOTE>

<!-- start a SELECT, display the data and free the handle -->
<! msql query "select phone,age from test where user='Bambi'" q1>
<! msql print_rows q1 "$0 ... $1">
<! msql free q1>

      </BLOCKQUOTE>
    </P>
    <P>

<!-- start a second SELECT using an other handle -->
<! msql query "select user,age,phone from test order by user" q2>

      <TABLE BORDER WIDTH="100%">
        <TR>
        <TH>Name
        <TH>Age
        <TH>Phone

<!-- display the query data in a table structure -->
<!msql print_rows q2 "<TR><TD>$0\n<TH>$1\n<TD>$2\n" >

      </TABLE>

<!-- free handle -->
<! msql free q2>

<!-- third SELECT -->
<! msql query "select user from test order by user desc" q3>

    </P>
    <P>
      <H2>List of usernames</H2>
      <BR>
      <UL>

<!-- display results in an unordered list -->
<! msql print_rows q3 "<li>$0\n">

      </UL>

<!-- free handle -->
<! msql free q3>

<!-- close connection to database server -->
<! msql close >

    </P>
  </BODY>
</HTML>
:exmp.

.*------------------------------------------------------------------------------
.* 'Author's Details'
.*------------------------------------------------------------------------------
:h1 id=author clear.Author's Details
:p.Mini SQL was written by:
:xmp.
  David J. Hughes
  Senior Network Programmer (and Ph. D. lunatic)
  Bond University
  Australia

  E-mail: bambi@Bond.edu.au
          http&colon.//Bond.edu.au/People/bambi.html
  Fax:    +61 75 951456
:exmp.
:p.Mini SQL has been ported to OS/2 by:
:xmp.
  Dirk Ohme

  T&ue.bingen, Germany

  E-mail:  Dirk.Ohme@transtec.de
  Fidonet: 2&colon.246/2001.9@fidonet
:exmp.

.*------------------------------------------------------------------------------
.* 'Archive Location'
.*------------------------------------------------------------------------------
:h1 id=archive clear.Archive Location
:p.The current version of mSQL can be found via ftp from
:xmp.
  Host:   Bond.edu.au (131.244.1.1)
  Path:   /pub/Minerva/msql
  Note:   original site

  Host:   rzsco.fh-albsig.de (141.87.110.2)
  URL:    http&colon.//rzsco.fh-albsig.de/~ohme
  Files:  FILES/msql*.lsm (description)
          FILES/msql*.zip (Zip 2.0.1 archive, Source &amp. Binaries)
  Note:   OS/2 port
:exmp.
:p.User contributed code can also be found in
:hp9.ftp&colon.//ftp.Bond.edu.au/pub/Minerva/msql/contrib:ehp9.. A monthly
archive of the mailing list ist also available in
:hp9.ftp&colon.//ftp.Bond.edu.au/pub/Minerva/msql/mail-archive:ehp9..

.*------------------------------------------------------------------------------
.* 'Mailing List'
.*------------------------------------------------------------------------------
:h1 id=mails clear.Mailing List
A mailing list for discussing mSQL has been setup by David J. Hughes. To
subscribe, send a message to:
:xmp.
  msql-list-request@Bond.edu.au
:exmp.
:p.To send a message to the entire list, address the mail to:
:xmp.
  msql-list@Bond.edu.au
:exmp.
:p.If you have special questions, suggestions, etc. for the OS/2 port, please
send your mail directly to :hp2.Dirk.Ohme@transtec.de:ehp2. - Thank you!

.*------------------------------------------------------------------------------
.* end of document
.*------------------------------------------------------------------------------
:euserdoc.
.*==============================================================================
