/*
** SAMPLE.H - This is the ODBC sample driver include file.
**
**	This code is furnished on an as-is basis as part of the ODBC SDK and is
**	intended for example purposes only.
**
*/

//	-	-	-	-	-	-	-	-	-

#define WINVER 0x0300 // prevent Windows 3.1 feature usage
#include  <windows.h>                     // Windows include file
#include  <windowsx.h>					  // message crackers

//	-	-	-	-	-	-	-	-	-

#ifndef WIN32
#include "w16macro.h"
#endif
#include "sql.h"
#include "sqlext.h"

//	Definitions to be used in function prototypes.
//	The SQL_API is to be used only for those functions exported for driver
//		manager use.
//	The EXPFUNC is to be used only for those functions exported but used
//		internally, ie, dialog procs.
//	The INTFUNC is to be used for all other functions.
#ifdef WIN32
#define INTFUNC  __stdcall
#define EXPFUNC  __stdcall
#else
#define INTFUNC PASCAL
#define EXPFUNC __export CALLBACK
#endif

//	-	-	-	-	-	-	-	-	-
/*
 * Error information is stored in a linked list structure associated with each
 * handle, environment, connection or statement.
 *
 * When an error occurs it is written to the error list for a handle. The
 * next successful function on that handle clears the error information.
 *
 * When an error occurs, and element is allocated for this list, and 
 * placed on the appropriate handle. SQLError() retrieves, and frees the 
 * first error on the list.
 */
typedef struct StoredErrorInfo {
	struct StoredErrorInfo *pNext;  /* Linked list */
	long   lErrorCode;              /* MSQL error code or driver (non-portable) */
	char   szSqlState[6];           /* Standard States 5 chars + null*/
	char   szErrorMessage[200];     /* Actual Error Message */
} EI, FAR * LPEI;
	
//	-	-	-	-	-	-	-	-	-

//	Environment information.

typedef	struct	tagENV {
    LPEI	lpei;
}	ENV,
	FAR * LPENV;

//	-	-	-	-	-	-	-	-	-

//	Database connection information.  This is allocated by "SQLAllocConnect".

typedef struct	tagDBC {
    BOOL	bConnected;  // Is it connected or just allocated.
    int 	iSocketFd;   // MSQL's socket file descriptor
    char    *pcDSN;      // Data Service name (Passed on connect)
    char    caServerName[17]; // Server Name
    char    caDBName[17]; // Server Name
    LPEI	lpei;
}	DBC,
	FAR * LPDBC;

//	-	-	-	-	-	-	-	-	-
struct BindInfo {			/* Result Bindings */
    void  *pvdBuffer;
    long  *plResultLen;
    long  lMaxLen;
    int  iType;
};

struct PBindInfo {			/* Parameter Bindings */
	int   iSqlType;         /* SQL type for the parameter */
	int   iCType;           /* 'C' type for the parameter */
    void  *pvdBuffer;		/* Buffer for data */	
    long  *plActualLen;		/* Current Len */
    long  lMaxLen;			/* Max Len */
    long  iRTLen;  			/* Length passed at runtime */
    char  *pvdRTBuffer;     /* Run Time buffer */
};


//  Statment information.  This is allocated by "SQLAllocStmt".                      
//	Results are linked to statements (Also Errors).
typedef struct	tagSTMT {
    LPEI	lpei;
    LPDBC	lpdbc;
    char *pcPrepared;               /* Statement prepared for execution */
    void far *pvdMResult;  			/* Actual MSQL mresult value */
    int iRBindings;					/* Number of entries in  Result Bindings array */
	struct BindInfo *pBindings;     /* For Binding Results */
	int iPBindings;					/* Number of parameter bound with SQLBindParam */
	int iPBCurrent;					/* Parameter being dealt with now */
	struct PBindInfo *pPBindings;   /* Bindings from SQLBindParam */
}	STMT,
	FAR *LPSTMT;

//	Definition of stored Data Dictionaries.
typedef struct {
	int iType;
	int iLength;
	int iFlags;
	char *pcName;
	char *pcTable;
} RESULT_FORMAT;



//	-	-	-	-	-	-	-	-	-

extern HINSTANCE NEAR s_hModule;	// DLL handle.

//	-	-	-	-	-	-	-	-	-

//	Resource defines for "SQLDriverConnect" dialog box.

#define	ID_LISTBOX	100

//	-	-	-	-	-	-	-	-	-

//	Resource defines for "Setup" dialog boxes.

#define CONFIGDSN                   1001
#define CONFIGDEFAULT               1002
#define EDRIVERCONNECT				1003
#define IDC_DSNAME                  400
#define IDC_DSNAMETEXT              401
#define IDC_DESC                    404
#define IDC_SELECT					405
#define IDC_TRANS_NAME				406
#define IDC_SERVER                  407
#define IDC_DATABASE                408

#define IDS_MSGTITLE                500
#define IDS_BADDSN                  501
