/*
** CATALOG.C - This is the ODBC sample driver code for
** executing Data Dictionary functions.
**
**	This code is furnished on an as-is basis as part of the ODBC SDK and is
**	intended for example purposes only.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <assert.h>

#include "gorta.h"

#include <msql.h>
#include "states.h"

//	-	-	-	-	-	-	-	-	-

/*
 * The following entry defines the results fromat for the SQLColumns Call.
 */
static RESULT_FORMAT RFColumns[12] = {
	{ CHAR_TYPE,  128, 0, 				"TABLE_QUALIFIER", NULL},
	{ CHAR_TYPE,  128, 0, 				"TABLE_OWNER", NULL},
	{ CHAR_TYPE,  128, NOT_NULL_FLAG, 	"TABLE_NAME", NULL},
	{ CHAR_TYPE,  128, NOT_NULL_FLAG, 	"COLUMN_NAME", NULL},
	{ SHORT_TYPE, 2,   NOT_NULL_FLAG, 	"DATA_TYPE", NULL},
	{ CHAR_TYPE,  128, NOT_NULL_FLAG, 	"TYPE_NAME", NULL},
	{ INT_TYPE,   4,   0, 				"PRECISION", NULL},
	{ INT_TYPE,   4,   0, 				"LENGTH", NULL},
	{ SHORT_TYPE, 2,   0, 				"SCALE", NULL},
	{ SHORT_TYPE, 2,   0, 				"RADIX", NULL},
	{ SHORT_TYPE, 2,   NOT_NULL_FLAG,	"NULLABLE", NULL},
	{ CHAR_TYPE,  254, 0, 				"REMARKS", NULL}	
};

/*
 * The following entry defines the result columns for the SQLSpecialColumns Call.
 */
static RESULT_FORMAT RFSpecials[8] = {
	{ INT_TYPE, 4, 0, 				"SCOPE", NULL},
	{ CHAR_TYPE, 128, NOT_NULL_FLAG,"COLUMN_NAME", NULL},
	{ INT_TYPE, 4, NOT_NULL_FLAG,   "DATA_TYPE", NULL},
	{ INT_TYPE, 4, NOT_NULL_FLAG, 	"TYPE_NAME", NULL},
	{ INT_TYPE, 4, 0, 				"PRECISION", NULL},
	{ INT_TYPE, 4, 0, 				"LENGTH", NULL},
	{ INT_TYPE, 4, 0, 				"SCALE", NULL},
	{ INT_TYPE, 4, 0, 				"PSEUDO_COLUMN", NULL},
};

/*
 * The following entry defines the result columns for the SQLStatistics call.
 */
static RESULT_FORMAT RFStatistics[13] = {
	{CHAR_TYPE,  128,  0,             "TABLE_QUALIFIER", NULL},
	{CHAR_TYPE,  128,  0,             "TABLE_OWNER", NULL},
	{CHAR_TYPE,  128,  NOT_NULL_FLAG, "TABLE_NAME", NULL},
	{SHORT_TYPE,   2,  0,             "NON_UNIQUE", NULL},
	{CHAR_TYPE,  128,  0,             "INDEX_QUALIFIER", NULL},
	{CHAR_TYPE,  128,  0,             "INDEX_NAME", NULL},
	{SHORT_TYPE,   2,  NOT_NULL_FLAG, "TYPE", NULL},
	{SHORT_TYPE,   2,  0,             "SEQ_IN_INDEX", NULL},
	{CHAR_TYPE,  128,  0,             "COLUMN_NAME", NULL},
	{CHAR_TYPE,    1,  0,             "COLLATION", NULL},
	{ INT_TYPE,    4,  0,             "CARDINALITY", NULL},
	{ INT_TYPE,    4,  0,             "PAGES", NULL},
	{CHAR_TYPE,  128,  0,             "FILTER_CONDITION0", NULL}
};


//	-	-	-	-	-	-	-	-	-

//	Have DBMS set up result set of Tables.
//
//	Get the list of tables from MSQL.
//	Put these into a result set.
RETCODE SQL_API SQLTables(
	HSTMT	  hstmt,
	UCHAR FAR *szTableQualifier,
	SWORD	  cbTableQualifier,
	UCHAR FAR *szTableOwner,
	SWORD	  cbTableOwner,
	UCHAR FAR *szTableName,
	SWORD	  cbTableName,
	UCHAR FAR *szTableType,
	SWORD	  cbTableType)
{
	LPSTMT lpstmt;
	m_result *msqlMResult; 
	m_result *odbcMResult; // ODBC expects a different format 
	RETCODE retcode = SQL_SUCCESS;
	m_fdata *curField;
	m_data *curRowMSQL, *curRowODBC;
	
	lpstmt = hstmt;
	if (!lpstmt)
		goto Exit;
	
	/*
	 * If there is previously a result then clear it.
	 */
	if (lpstmt->pvdMResult)
	{
		msqlMResult = lpstmt->pvdMResult;
		msqlFreeResult(msqlMResult);
		lpstmt->pvdMResult = NULL;
		/* For now the application must remove the bindings */
	}
	              
	msqlMResult = msqlListTables(lpstmt->lpdbc->iSocketFd);
	if (!msqlMResult)
	{
		char szErrorMsg[160];
		LPEI lpeiTmp;
		
		retcode = SQL_ERROR;
		lpeiTmp = malloc(sizeof(EI));
		if (!lpeiTmp)
		{
			goto Exit;
		}
		lpeiTmp->pNext = lpstmt->lpei;
		lpeiTmp->lErrorCode=-1;
		strncpy(lpeiTmp->szSqlState, "00000", 5);
		msqlErrorText(szErrorMsg);						/* MSQL Extension */
		sprintf(lpeiTmp->szErrorMessage, "[MSQLODBC][MSQL]%.*s", 160, szErrorMsg);
		lpstmt->lpei=lpeiTmp;
		goto Exit;
	}
	
	// Now generate the result in the format in which ODBC expects it
	//
	odbcMResult = malloc(sizeof(m_result));
	assert(odbcMResult);
	odbcMResult->numFields = 5;
	odbcMResult->fieldData = odbcMResult->fieldCursor = curField = malloc(sizeof(m_fdata));
	assert(curField);
	curField->field.type = CHAR_TYPE;
	curField->field.length = 128;
	curField->field.flags =  0;
	curField->field.name = strdup("TABLE_QUALIFIER");
	curField->field.table = NULL;
	
	curField->next = malloc(sizeof(m_fdata));
	curField = curField->next;
	assert(curField);
	curField->field.type = CHAR_TYPE;
	curField->field.length = 128;
	curField->field.flags =  0;
	curField->field.name = strdup("TABLE_OWNER");
	curField->field.table = NULL;
	
	curField->next = malloc(sizeof(m_fdata));
	curField = curField->next;
	assert(curField);
	curField->field.type = CHAR_TYPE;
	curField->field.length = 128;
	curField->field.flags =  0;
	curField->field.name = strdup("TABLE_NAME");
	curField->field.table = NULL;
	
	curField->next = malloc(sizeof(m_fdata));
	curField = curField->next;
	assert(curField);
	curField->field.type = CHAR_TYPE;
	curField->field.length = 128;
	curField->field.flags =  0;
	curField->field.name = strdup("TABLE_TYPE");
	curField->field.table = NULL;

	curField->next = malloc(sizeof(m_fdata));
	curField = curField->next;
	assert(curField);
	curField->field.type = CHAR_TYPE;
	curField->field.length = 254;
	curField->field.flags =  0;
	curField->field.name = strdup("REMARKS");
	curField->field.table = NULL;

	curField->next = NULL;

    odbcMResult->numRows = msqlMResult->numRows;
    
    if (msqlMResult->numRows > 0)
    {
		curRowODBC = malloc(sizeof(m_data));
		assert(curRowODBC);
		odbcMResult->queryData = curRowODBC;
		odbcMResult->cursor = NULL;
		curRowMSQL = msqlMResult->queryData;
		curRowODBC->data = calloc(5, sizeof(char *));
		curRowODBC->data[2] = strdup(curRowMSQL->data[0]);
		curRowODBC->data[3] = strdup("TABLE");
		curRowODBC->width = 5;
		curRowMSQL = curRowMSQL->next;
		while (curRowMSQL)
		{
			curRowODBC->next = malloc(sizeof(m_data));
			curRowODBC = curRowODBC->next;
			curRowODBC->width = 5;
			curRowODBC->data = calloc(5, sizeof(char *));
			curRowODBC->data[2] = strdup(curRowMSQL->data[0]);
			curRowODBC->data[3] = strdup("TABLE");
			curRowMSQL=curRowMSQL->next;
		}
		curRowODBC->next = NULL;
	}

	msqlFreeResult(msqlMResult);
	lpstmt->pvdMResult = odbcMResult;
		
Exit:		
	return(retcode);
}

//	-	-	-	-	-	-	-	-	-

//	Have DBMS set up result set of Columns.

//	Only handles retrieving columns from one table

RETCODE SQL_API SQLColumns(
	HSTMT	  hstmt,
	UCHAR FAR *szTableQualifier,
	SWORD	  cbTableQualifier,
	UCHAR FAR *szTableOwner,
	SWORD	  cbTableOwner,
	UCHAR FAR *szTableName,
	SWORD	  cbTableName,
	UCHAR FAR *szColumnName,
	SWORD	  cbColumnName)
{
	LPSTMT lpstmt;
	m_result *msqlMResult; 
	m_result *odbcMResult; // ODBC expects a different format 
	RETCODE retcode = SQL_SUCCESS;
	m_fdata *curField;
	m_data *curRowODBC;
	char szErrorMsg[160];
	LPEI lpeiTmp;
	int iLoop;
	
	lpstmt = hstmt;
	if (!lpstmt)
		goto Exit;
	
	/*
	 * If there is previously a result then clear it.
	 */
	if (lpstmt->pvdMResult)
	{
		msqlMResult = lpstmt->pvdMResult;
		msqlFreeResult(msqlMResult);
		lpstmt->pvdMResult = NULL;
		/* For now the application must remove the bindings */
	}
	
    msqlMResult = msqlListFields(lpstmt->lpdbc->iSocketFd, szTableName);
    if (!msqlMResult)
    {
		retcode = SQL_ERROR;
		lpeiTmp = malloc(sizeof(EI));
		if (!lpeiTmp)
		{
			retcode = SQL_ERROR;
			goto Exit;
		}
		lpeiTmp->pNext = lpstmt->lpei;
		lpeiTmp->lErrorCode=-1;
		strncpy(lpeiTmp->szSqlState, MSQL_UNABLE_TO_CONNECT, 5);
		msqlErrorText(szErrorMsg);						/* MSQL Extension */
		sprintf(lpeiTmp->szErrorMessage, "[MSQLODBC][MSQL]%.*s", 160, szErrorMsg);
		lpstmt->lpei=lpeiTmp;
		goto Exit;
    }
    
    /*
     * Set up result Data dictionary.
     */
    odbcMResult = (m_result *)malloc(sizeof(m_result));
	assert(odbcMResult);
	odbcMResult->numFields = 12;
	odbcMResult->fieldData = odbcMResult->fieldCursor = curField = malloc(sizeof(m_fdata));
	assert(curField);
	curField->field.type = RFColumns[0].iType;
	curField->field.length = RFColumns[0].iLength;
	curField->field.flags =  RFColumns[0].iFlags;
	curField->field.name = strdup(RFColumns[0].pcName);
	curField->field.table = NULL;
	for (iLoop = 1; iLoop < 12; iLoop++)
	{
		curField->next = malloc(sizeof(m_fdata));
		assert(curField->next);
		curField = curField->next;
		curField->next = NULL;
		curField->field.type = RFColumns[iLoop].iType;
		curField->field.length = RFColumns[iLoop].iLength;
		curField->field.flags =  RFColumns[iLoop].iFlags;
		curField->field.name = strdup(RFColumns[iLoop].pcName);
		curField->field.table = NULL;
	}
	
	/*
	 * Now copy the fields from the MSQL m_result structure to the
	 * ODBC m_result structure.
	 *
	 * The MSQL result is stored in the field list. The ODBC result
	 * is stored in data.
	 */
    odbcMResult->numRows = msqlMResult->numFields;
	odbcMResult->queryData = odbcMResult->cursor = NULL;
    
    for (iLoop = 0; iLoop < msqlMResult->numFields; iLoop++)
    {
    	if (iLoop == 0)
    	{
			curRowODBC = malloc(sizeof(m_data));
			assert(curRowODBC);
			odbcMResult->queryData = curRowODBC;
			odbcMResult->cursor = NULL;
			curField = msqlMResult->fieldData;
		}
		else
		{
			curRowODBC->next = malloc(sizeof(m_data));
			assert(curRowODBC->next);
			curRowODBC = curRowODBC->next;
			curField = curField->next;
		}

		curRowODBC->next = NULL;
		curRowODBC->data = calloc(12, sizeof(char *));
		curRowODBC->data[2] = strdup(szTableName);
		curRowODBC->data[3] = strdup(curField->field.name);
		curRowODBC->data[4] = malloc(sizeof(short));
		curRowODBC->data[6] = malloc(sizeof(long));
		switch (curField->field.type)
		{
		case INT_TYPE:
			*((short *)curRowODBC->data[4]) = SQL_INTEGER;
			curRowODBC->data[5] = strdup("INTEGER");
			*((long *)curRowODBC->data[6]) = 10;
			break;
		case CHAR_TYPE:
			*((short *)curRowODBC->data[4]) = SQL_CHAR;
			curRowODBC->data[5] = strdup("CHAR");
			*((long *)curRowODBC->data[6]) = curField->field.length;
			break;
		default:
			break;
		}
		curRowODBC->data[7] = malloc(sizeof(long));
		*((long *)curRowODBC->data[7]) = curField->field.length;
		curRowODBC->data[10] = malloc(sizeof(short));
		*((short *)curRowODBC->data[10]) = curField->field.flags & NOT_NULL_FLAG ?
			SQL_NO_NULLS : SQL_NULLABLE;
		curRowODBC->width = 12;
	}

	msqlFreeResult(msqlMResult);
	lpstmt->pvdMResult = odbcMResult;
    
Exit:	              
	return(retcode);
}

//	-	-	-	-	-	-	-	-	-

//	Have DBMS set up result set of Statistics.

//	Only support the ability to retrieve a KEY for VB to store.
//	VB makes its own Key Cursor

RETCODE SQL_API SQLStatistics(
	HSTMT	  hstmt,
	UCHAR FAR *szTableQualifier,
	SWORD	  cbTableQualifier,
	UCHAR FAR *szTableOwner,
	SWORD	  cbTableOwner,
	UCHAR FAR *szTableName,
	SWORD	  cbTableName,
	UWORD	  fUnique,
	UWORD	  fAccuracy)
{
	LPSTMT lpstmt;
	m_result *msqlMResult; 
	m_result *odbcMResult; // ODBC expects a different format 
	RETCODE retcode = SQL_SUCCESS;
	m_fdata *curField;
	m_data *curRowODBC;
	char szErrorMsg[160];
	LPEI lpeiTmp;
	int iLoop;
	int fHasPrimKey;
	
	lpstmt = hstmt;
	if (!lpstmt)
		goto Exit;
	
	/*
	 * If there is previously a result then clear it.
	 */
	if (lpstmt->pvdMResult)
	{
		msqlMResult = lpstmt->pvdMResult;
		msqlFreeResult(msqlMResult);
		lpstmt->pvdMResult = NULL;
		/* For now the application must remove the bindings */
	}
	
    /*
     * Set up result Data dictionary.
     */
    odbcMResult = (m_result *)malloc(sizeof(m_result));
	assert(odbcMResult);
	odbcMResult->numFields = 13;
	odbcMResult->fieldData = odbcMResult->fieldCursor = curField = malloc(sizeof(m_fdata));
	assert(curField);
	curField->field.type = RFStatistics[0].iType;
	curField->field.length = RFStatistics[0].iLength;
	curField->field.flags =  RFStatistics[0].iFlags;
	curField->field.name = strdup(RFStatistics[0].pcName);
	curField->field.table = NULL;
	for (iLoop = 1; iLoop < 13; iLoop++)
	{
		curField->next = malloc(sizeof(m_fdata));
		assert(curField->next);
		curField = curField->next;
		curField->next = NULL;
		curField->field.type = RFStatistics[iLoop].iType;
		curField->field.length = RFStatistics[iLoop].iLength;
		curField->field.flags =  RFStatistics[iLoop].iFlags;
		curField->field.name = strdup(RFStatistics[iLoop].pcName);
		curField->field.table = NULL;
	}
	
	/*
	 * All I know about is the primary Index, if there is one.
	 * Both options SQL_INDEX_UNIQUE and SQL_INDEX_ALL return
	 * the same results.
	 */
	if (!szTableName)
	{
		retcode = SQL_ERROR;
		lpeiTmp = malloc(sizeof(EI));
		if (!lpeiTmp)
		{
			retcode = SQL_ERROR;
			goto Exit;
		}
		lpeiTmp->pNext = lpstmt->lpei;
		lpeiTmp->lErrorCode=-1;
		strncpy(lpeiTmp->szSqlState, MSQL_GENERAL_ERROR, 5);
		sprintf(lpeiTmp->szErrorMessage, "[MSQLODBC][MSQL]%.*s", 160, 
			"Tablename parameter is invalid");
		lpstmt->lpei=lpeiTmp;
		goto Exit;
	}
    msqlMResult = msqlListFields(lpstmt->lpdbc->iSocketFd, szTableName);
    if (!msqlMResult)
    {
		retcode = SQL_ERROR;
		lpeiTmp = malloc(sizeof(EI));
		if (!lpeiTmp)
		{
			retcode = SQL_ERROR;
			goto Exit;
		}
		lpeiTmp->pNext = lpstmt->lpei;
		lpeiTmp->lErrorCode=-1;
		strncpy(lpeiTmp->szSqlState, MSQL_UNABLE_TO_CONNECT, 5);
		msqlErrorText(szErrorMsg);						/* MSQL Extension */
		sprintf(lpeiTmp->szErrorMessage, "[MSQLODBC][MSQL]%.*s", 160, szErrorMsg);
		lpstmt->lpei=lpeiTmp;
		goto Exit;
    }
	    
	/*
	 * Have got the MSQL Column List. Now check for primary key values.
	 * If not return no result.
	 */
	odbcMResult->cursor = odbcMResult->queryData = NULL;
	odbcMResult->numRows = 0;
	fHasPrimKey = FALSE;
	for (iLoop=0; iLoop < msqlMResult->numFields; iLoop++)
	{
		if (iLoop == 0)
			curField = msqlMResult->fieldData;
		else
			curField = curField->next;
		if (curField->field.flags & PRI_KEY_FLAG)
		{
			fHasPrimKey = TRUE;
			break;
		}
	}
	
	if (fHasPrimKey)
	{
		/*
		 * Now copy the fields from the MSQL m_result structure to the
		 * ODBC m_result structure.
		 *
		 * The MSQL result is stored in the field list. The ODBC result
		 * is stored in data.
	 	 */
    	for (iLoop = 0; iLoop < msqlMResult->numFields; iLoop++)
    	{
	    	if (iLoop == 0)
				curField = msqlMResult->fieldData;
			else
				curField = curField->next;
    		if (!(curField->field.flags & PRI_KEY_FLAG))
    			continue; /* This one is not included */
    
			if (odbcMResult->numRows == 0) /* First Field */
			{
				curRowODBC = malloc(sizeof(m_data));
				assert(curRowODBC);
				odbcMResult->queryData = curRowODBC;
				odbcMResult->cursor = NULL;
				curField = msqlMResult->fieldData;
			}
			else
			{
				curRowODBC->next = malloc(sizeof(m_data));
				assert(curRowODBC->next);
				curRowODBC = curRowODBC->next;
			}
			curRowODBC->next = NULL;
			curRowODBC->width = 13;
			curRowODBC->data = calloc(13, sizeof(char *));
			curRowODBC->data[2] = strdup(szTableName);
			curRowODBC->data[3] = malloc(sizeof(short)); *(short*)curRowODBC->data[3] = FALSE;
			curRowODBC->data[5] = strdup(szTableName);  /* Imaginary name of index */
			curRowODBC->data[6] = malloc(sizeof(short));
			*(short*)curRowODBC->data[6] = SQL_INDEX_OTHER;
			curRowODBC->data[7] = malloc(sizeof(short)); *(short*)curRowODBC->data[7] = 1;
			curRowODBC->data[8] = strdup(curField->field.name);
/*
 * May be a problem here - this column is of type SQL_CHAR, a fixed length
 * string. Up until now we have been using MSQL CHAR_TYPE to represent 
 * SQL_VARCHAR (Null Terminated) 
 */
			curRowODBC->data[9] = strdup("A");
			odbcMResult->numRows++;
		}
		msqlFreeResult(msqlMResult);
	}			
	lpstmt->pvdMResult = odbcMResult;
    
Exit:	              
	return(retcode);
}

//	-	-	-	-	-	-	-	-	-

//	Have DBMS set up result set of TablePrivileges.

RETCODE SQL_API SQLTablePrivileges(
	HSTMT	  hstmt,
	UCHAR FAR *szTableQualifier,
	SWORD	  cbTableQualifier,
	UCHAR FAR *szTableOwner,
	SWORD	  cbTableOwner,
	UCHAR FAR *szTableName,
	SWORD	  cbTableName)
{
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Have DBMS set up result set of ColumnPrivileges.

RETCODE SQL_API SQLColumnPrivileges(
	HSTMT	  hstmt,
	UCHAR FAR *szTableQualifier,
	SWORD	  cbTableQualifier,
	UCHAR FAR *szTableOwner,
	SWORD	  cbTableOwner,
	UCHAR FAR *szTableName,
	SWORD	  cbTableName,
	UCHAR FAR *szColumnName,
	SWORD	  cbColumnName)
{
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Have DBMS set up result set of SpecialColumns.


RETCODE SQL_API SQLSpecialColumns(
	HSTMT	  hstmt,
	UWORD	  fColType,
	UCHAR FAR *szTableQualifier,
	SWORD	  cbTableQualifier,
	UCHAR FAR *szTableOwner,
	SWORD	  cbTableOwner,
	UCHAR FAR *szTableName,
	SWORD	  cbTableName,
	UWORD	  fScope,
	UWORD	  fNullable)
{
	LPSTMT lpstmt;
	m_result *msqlMResult; 
	m_result *odbcMResult; // ODBC expects a different format 
	RETCODE retcode = SQL_SUCCESS;
	m_fdata *curField;
	m_data *curRowODBC;
	char szErrorMsg[160];
	LPEI lpeiTmp;
	int iLoop;
	int fHasPrimKey;
	
	lpstmt = hstmt;
	if (!lpstmt)
		goto Exit;
	
	/*
	 * If there is previously a result then clear it.
	 */
	if (lpstmt->pvdMResult)
	{
		msqlMResult = lpstmt->pvdMResult;
		msqlFreeResult(msqlMResult);
		lpstmt->pvdMResult = NULL;
		/* For now the application must remove the bindings */
	}
	
    /*
     * Set up result Data dictionary.
     */
    odbcMResult = (m_result *)malloc(sizeof(m_result));
	assert(odbcMResult);
	odbcMResult->numFields = 8;
	odbcMResult->fieldData = odbcMResult->fieldCursor = curField = malloc(sizeof(m_fdata));
	assert(curField);
	curField->field.type = RFSpecials[0].iType;
	curField->field.length = RFSpecials[0].iLength;
	curField->field.flags =  RFSpecials[0].iFlags;
	curField->field.name = strdup(RFSpecials[0].pcName);
	curField->field.table = NULL;
	for (iLoop = 1; iLoop < 8; iLoop++)
	{
		curField->next = malloc(sizeof(m_fdata));
		assert(curField->next);
		curField = curField->next;
		curField->next = NULL;
		curField->field.type = RFSpecials[iLoop].iType;
		curField->field.length = RFSpecials[iLoop].iLength;
		curField->field.flags =  RFSpecials[iLoop].iFlags;
		curField->field.name = strdup(RFSpecials[iLoop].pcName);
		curField->field.table = NULL;
	}
	
	/*
	 * Check the query type
	 * The optimal set of columns for identifing a row is either
	 * the primary key, or if there is no primary key, then
	 * all the fields.
	 *
	 * There are no columns automatically updated on a row modification.
	 *
	 * TBD - process the extra flags in the command
	 */
	switch (fColType)
	{
	case SQL_ROWVER:
		odbcMResult->queryData = odbcMResult->cursor = NULL;
		odbcMResult->numRows = 0;
		break;
	case SQL_BEST_ROWID:
		if (!szTableName)
		{
			retcode = SQL_ERROR;
			lpeiTmp = malloc(sizeof(EI));
			if (!lpeiTmp)
			{
				retcode = SQL_ERROR;
				goto Exit;
			}
			lpeiTmp->pNext = lpstmt->lpei;
			lpeiTmp->lErrorCode=-1;
			strncpy(lpeiTmp->szSqlState, MSQL_GENERAL_ERROR, 5);
			sprintf(lpeiTmp->szErrorMessage, "[MSQLODBC][MSQL]%.*s", 160, 
				"Tablename parameter is invalid");
			lpstmt->lpei=lpeiTmp;
			goto Exit;
		}
    	msqlMResult = msqlListFields(lpstmt->lpdbc->iSocketFd, szTableName);
    	if (!msqlMResult)
    	{
			retcode = SQL_ERROR;
			lpeiTmp = malloc(sizeof(EI));
			if (!lpeiTmp)
			{
				retcode = SQL_ERROR;
				goto Exit;
			}
			lpeiTmp->pNext = lpstmt->lpei;
			lpeiTmp->lErrorCode=-1;
			strncpy(lpeiTmp->szSqlState, MSQL_UNABLE_TO_CONNECT, 5);
			msqlErrorText(szErrorMsg);						/* MSQL Extension */
			sprintf(lpeiTmp->szErrorMessage, "[MSQLODBC][MSQL]%.*s", 160, szErrorMsg);
			lpstmt->lpei=lpeiTmp;
			goto Exit;
    	}
	    
	    /*
	     * Have got the MSQL Column List. Now check for primary key values.
	     * If none do straight copy.
	     */
		fHasPrimKey = FALSE;
	    for (iLoop=0; iLoop < msqlMResult->numFields; iLoop++)
	    {
	    	if (iLoop == 0)
				curField = msqlMResult->fieldData;
			else
				curField = curField->next;
			if (curField->field.flags & PRI_KEY_FLAG)
			{
				fHasPrimKey = TRUE;
				break;
			}
	    }
		/*
		 * Now copy the fields from the MSQL m_result structure to the
		 * ODBC m_result structure.
		 *
		 * The MSQL result is stored in the field list. The ODBC result
		 * is stored in data.
	 	 */
    	odbcMResult->numRows = 0;
    	for (iLoop = 0; iLoop < msqlMResult->numFields; iLoop++)
    	{
	    	if (iLoop == 0)
				curField = msqlMResult->fieldData;
			else
				curField = curField->next;
    		if (fHasPrimKey && !(curField->field.flags & PRI_KEY_FLAG))
    			continue; /* This one is not included */
    
			if (odbcMResult->numRows == 0) /* First Field */
			{
				curRowODBC = malloc(sizeof(m_data));
				assert(curRowODBC);
				odbcMResult->queryData = curRowODBC;
				odbcMResult->cursor = NULL;
				curField = msqlMResult->fieldData;
			}
			else
			{
				curRowODBC->next = malloc(sizeof(m_data));
				assert(curRowODBC->next);
				curRowODBC = curRowODBC->next;
			}
			curRowODBC->next = NULL;
			curRowODBC->width = 8;
			curRowODBC->data = calloc(8, sizeof(char *));
			curRowODBC->data[0] = malloc(sizeof(long));
			*(long*)curRowODBC->data[0] = SQL_SCOPE_SESSION;
			curRowODBC->data[1] = strdup(curField->field.name);
			curRowODBC->data[2] = malloc(sizeof(long));
			curRowODBC->data[4] = malloc(sizeof(long));
			curRowODBC->data[5] = malloc(sizeof(long));
			switch (curField->field.type)
			{
			case INT_TYPE:
				*((long *)curRowODBC->data[2]) = SQL_INTEGER;
				curRowODBC->data[3] = strdup("INTEGER");
				*((long *)curRowODBC->data[4]) = 10;
				*((long *)curRowODBC->data[5]) = 4;
				break;
			case CHAR_TYPE:
				*((long *)curRowODBC->data[2]) = SQL_CHAR;
				curRowODBC->data[3] = strdup("CHAR");
				*((long *)curRowODBC->data[4]) = curField->field.length;
				*((long *)curRowODBC->data[5]) = curField->field.length;
				break;
			default:
				break;
			}
			curRowODBC->data[6] = NULL;
			curRowODBC->data[7] = malloc(sizeof(long));
			*((long *)curRowODBC->data[7]) = SQL_PC_NOT_PSEUDO;
			odbcMResult->numRows++;
		}
		msqlFreeResult(msqlMResult);
		break;
	}			
	lpstmt->pvdMResult = odbcMResult;
    
Exit:	              
	return(retcode);
}

//	-	-	-	-	-	-	-	-	-

//	Have DBMS set up result set of PrimaryKeys.

RETCODE SQL_API SQLPrimaryKeys(
	HSTMT	  hstmt,
	UCHAR FAR *szTableQualifier,
	SWORD	  cbTableQualifier,
	UCHAR FAR *szTableOwner,
	SWORD	  cbTableOwner,
	UCHAR FAR *szTableName,
	SWORD	  cbTableName)
{
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Have DBMS set up result set of ForeignKeys.

RETCODE SQL_API SQLForeignKeys(
	HSTMT	  hstmt,
	UCHAR FAR *szPkTableQualifier,
	SWORD	  cbPkTableQualifier,
	UCHAR FAR *szPkTableOwner,
	SWORD	  cbPkTableOwner,
	UCHAR FAR *szPkTableName,
	SWORD	  cbPkTableName,
	UCHAR FAR *szFkTableQualifier,
	SWORD	  cbFkTableQualifier,
	UCHAR FAR *szFkTableOwner,
	SWORD	  cbFkTableOwner,
	UCHAR FAR *szFkTableName,
	SWORD	  cbFkTableName)
{
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Have DBMS set up result set of Procedures.

RETCODE SQL_API SQLProcedures(
	HSTMT	  hstmt,
	UCHAR FAR *szProcQualifier,
	SWORD	  cbProcQualifier,
	UCHAR FAR *szProcOwner,
	SWORD	  cbProcOwner,
	UCHAR FAR *szProcName,
	SWORD	  cbProcName)
{
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Have DBMS set up result set of ProcedureColumns.

RETCODE SQL_API SQLProcedureColumns(
	HSTMT	  hstmt,
	UCHAR FAR *szProcQualifier,
	SWORD	  cbProcQualifier,
	UCHAR FAR *szProcOwner,
	SWORD	  cbProcOwner,
	UCHAR FAR *szProcName,
	SWORD	  cbProcName,
	UCHAR FAR *szColumnName,
	SWORD	  cbColumnName)
{
	return SQL_SUCCESS;
}
