#ifndef __ZMSQLDB_H
#define __ZMSQLDB_H

#include <msql.h>
#include <zdb.h>
class ZmSQL;
class ZmSQLConnection;


class  ZmSQL : public ZSQL	{
	private:
		m_row Row;
		m_result* Result;
		ZmSQLConnection* Connection;
		m_field Field[MAX_COLS];


	public:
		ZmSQL(ZmSQLConnection* p = NULL);

		int Open(char*);
		void Close();
		int GetSQLData(int,char*,int);
                int GetSQLData(int,int*);
                int GetSQLData(int,float*);
  		int GetNextRecord();
		int GetFieldInfo(int,ZField*);
		int GetNumCols();
		int GetNumRows();
		void PrintError(int=TO_LOG);
		void Initialize();
		long Max(char* table,char* fld,char* Where=NULL);
		long Min(char* table,char* fld,char* Where=NULL);
		long Count(char* table,char* Where=NULL);
		char* GetError(){return msqlErrMsg;}
		};
	
class  ZmSQLConnection	:public ZDBConnection{
	public:
		int ErrCode;
		int hDB;

	public:
		ZmSQLConnection(char* = NULL,char* = NULL,char* = NULL);
		~ZmSQLConnection();
		virtual int GetDB(){return hDB;}
		virtual void ShutDown();
		virtual void Initialize();
		virtual BOOL SetDB(char*);
		virtual BOOL SetServer(char*);
		virtual char* GetDBName(int);
		char* GetError(){return msqlErrMsg;}
	};

#endif
