#ifndef lint
static char     rcsid[] = "$Header: text.c,v 0.0 88/06/22 05:22:51 on Rel $";

#endif

#include <stdio.h>
#include <ctype.h>
#include "pps.h"
/*
 * "Lexical analyzer" for plain text (e.g. the output of nroff(1)):
 * Prints _\b. and .\b_ in italics; c\bc in bold.
 */
FILE    *yyin /* = stdin */;
FILE    *yyout /* = stdout */;
char           *keywords[1];
char	       *directives [] = {
		"",
		NULL
		};

static
struct ca {
    char            c;		       /* character to print */
    char            a;		       /* font to use */
}               ca[BUFSIZ];

#define ITALIC	'S'
#define NORM	'I'
#define BOLD	'K'

/*
 * Add character c at position cap.
 */
static          caput (c, cap)
register        c;
register struct ca *cap;
{
    switch (cap->c) {
    case '_':
	cap->a = ITALIC;
	break;
    case '\0':
    case ' ':
	cap->a = NORM;
	break;
    default:
	switch (c) {
	case '_':
	    cap->a = ITALIC;
	    return;
	default:
	    if (cap->c == c)
		cap->a = BOLD;
	case ' ':
	    break;
	}
    }
    cap->c = c;
}

/*
 * Print text collected so far.
 */
static          caflush (caend)
struct ca      *caend;
{
    char            buf[BUFSIZ];
    register struct ca *cap;
    static struct ca zeroca;

    for (cap = ca; cap < caend;) {
	register char  *cp = buf;

	while (cap < caend && cap->a == *font) {
	    *cp++ = cap->c;
	    *cap++ = zeroca;
	}
	*cp = '\0';
	echo (buf);
	sput ();
	if (cap->a)
	    *font = cap->a;
    }
}

/*
 * Process input text:
 *	Call space() for [\t\n\f],
 *	Save others in ca.
 */
yylex ()
{
    register struct ca *cap = ca;
    static char     sp[2];

    for (;;) {
	register int	c = EOF;

	while (!iscntrl (c = getc (yyin)) && (c != EOF)) {
	    caput (c, cap++);
	}

	if (feof (yyin)) {
	    caflush (cap);
	    return;
	}

	switch (c) {

	case '\b':
	    if (cap > ca)
		cap--;
	    continue;

	case '\r':		       /* BUG -- won't work after \t */
	    cap = ca;
	    continue;

	case '\t':
	case '\n':
	case '\f':
	case EOF:
	    break;

	default:
	    continue;
	}

	caflush (cap);
	cap = ca;

	if (c == EOF) {
	    return;
	}
	else {
	    *sp = c;
	    space (sp);
	}
    }
}
