rcsid='$Header: slide.sh,v 0.0 88/06/22 05:22:48 on Rel $'
#
# Argument processor and handshaker for slide maker.
#
usage="usage: ${0} [ -l language ] [ -t tabstop ] files"
lib=.
PATH=/bin:/usr/bin

while [ "$*" ]
do
	case $1 in
		-l)
			if [ ! -r $lib/${2?$usage} ]
			then
				echo ${0}: ${2}: Unknown language 1>&2
				exit 17
			fi
			lang=$2
			shift
			;;
		-t)
			tab=${2?$usage} ; shift
			;;
		-*)
			echo $uasge 1>&2
			exit 1
			;;
		*)
			files="$files $1"
	esac
	shift
done

# Sanity check
: ${files?"Sorry, cannot read standard input."}
: ${lang=c}
: ${tab=8}
colrow=`$lib/prc -cr -t $tab $files | sed -n '$s/[^0-9][^0-9]*/ /gp'`

cat - ${prog-$lib/slide.pro} $style << EOC
%!PS-Adobe-1.0
%%Title: ${files-standard input}
%%Creator: $0 ($rcsid)
%%CreationDate: `date`
%%For: ${USER-unknown}@${HOST-`hostname || uuname -l`}
%%EndComments
EOC
echo "
/tabstop $tab def
$colrow ppsinit
" && ${lib}/${lang=c} $files && echo "%%Trailer
ppsdone"
