%{
#ifndef lint
static char rcsid[] = "$Header: sh.l,v 0.0 88/06/22 05:22:38 on Rel $";
#endif
#include <ctype.h>
#include "pps.h"

int nbrace;
%}
letter	[A-Za-z_]
digit	[0-9]
white	[ \t]
builtin	[#\*@\-\?\$\!0-9]
%Start COMMENT STRING1 STRING2 KEYWORD
%%
<INITIAL>{letter}({letter}|{digit})*	{
			int kw = iskw(yytext);
			if (kw)
				begin(KEYWORD);
			ECHO;
			if (kw)
				begin(INITIAL);
		}
<INITIAL>\"	{ begin(STRING1); ECHO; }
<INITIAL>\'	{ begin(STRING2); ECHO; }
<INITIAL>#.*	{ begin(COMMENT); ECHO; begin(INITIAL); }
<STRING1>\\.	{ ECHO; }
<STRING2>\\.	{ ECHO; }
<STRING1>\"	{ ECHO; begin(INITIAL); }
<STRING2>\'	{ ECHO; begin(INITIAL); }
<INITIAL>\${builtin}	{ begin(KEYWORD); ECHO; begin(INITIAL); }
<STRING1>\${builtin}	{ begin(KEYWORD); ECHO; begin(STRING1); }
<INITIAL>\$	{ begin(KEYWORD); ECHO; begin(INITIAL); }
<STRING1>\$	{ begin(KEYWORD); ECHO; begin(STRING1); }
[\t\n\f]+	{ space(yytext); }
.		{ ECHO; }
%%
char *keywords[] = {
	"",
	"for",
	"in",
	"do",
	"done",
	"case",
	"if",
	"then",
	"else",
	"elif",
	"fi",
	"while",
	"break",
	"cd",
	"chdir",
	"continue",
	"eval",
	"exec",
	"exit",
	"export",
	"read",
	"readonly",
	"set",
	"shift",
	"times",
	"trap",
	"umsak",
	"wait",
	"HOME",
	"IFS",
	"MAIL",
	"PATH",
	"PS1",
	"PS2",
	NULL
};

char *directives[] = {
	"",
	NULL
};

