%{
#ifndef lint
static char rcsid[] = "$Header: lisp.l,v 0.0 88/06/22 05:22:11 on Rel $";
#endif
#include <ctype.h>
#include "pps.h"

static int def, proc_start;

%}

letter	[A-Za-z\*\/\<\=\>\!\?\:\$\%\_\&\~\^\+\-]
digit	[0-9]
white	[ \t]

%Start COMMENT STRING KEYWORD
%%
<INITIAL>c[ad]+r	{ begin(KEYWORD); ECHO; begin(INITIAL); }

<INITIAL>#[\\ft]	{ begin(KEYWORD); ECHO; begin(INITIAL); }

<INITIAL>{letter}({letter}|{digit})*	{
			int kw = iskw(yytext);

			def = 0;
			if (kw) {
				begin(KEYWORD);
				if ( !strcmp ("define", yytext) )
				    def = 1;
			}
			else if (proc_start) {
				funct(yytext);
				proc_start = 0;
			}
			ECHO;
			if (kw)
				begin(INITIAL);
		}
<INITIAL>\"	{ begin(STRING); ECHO; def = 0; }
<INITIAL>;.*	{ begin(COMMENT); ECHO; begin(INITIAL); }
<STRING>\\.	{ ECHO; }
<STRING>\"	{ ECHO; begin(INITIAL); }
[\t\n\f]+	{ space(yytext); }
"("		{
		    if (def)
			proc_start = 1;
		    def = 0;
		    ECHO;
		}
.		{ ECHO; def = 0; }
%%
/*
 * Your pet lisp dialect has other built-ins than ours;
 * anyway, the list is too long to ship over the net...
 */
char *keywords[] = {
	"",
	"*",
	"+",
	"-",
	"/",
	"<",
	"<=",
	"=",
	"=>",
	">",
	">=",
	"abs",
	"and",
	"append",
	"apply",
	"assoc",
	"assq",
	"assv",
	"begin",
	"boolean?",
	"call-with-current-continuation",
	"call-with-input-file",
	"call-with-output-file",
	"car",
	"case",
	"cdr",
	"char->integer",
	"char<=?",
	"char<?",
	"char=?",
	"char>=?",
	"char>?",
	"char?",
	"complex?",
	"cond",
	"cons",
	"current-input-port",
	"current-output-port",
	"define",
	"delay",
	"display",
	"do",
	"else",
	"eof-object?",
	"eq?",
	"equal?",
	"eqv?",
	"even?",
	"exact?",
	"for-each",
	"if",
	"inexact?",
	"input-port?",
	"integer->char",
	"integer?",
	"lambda",
	"length",
	"let",
	"let*",
	"letrec",
	"list",
	"list->string",
	"list->vector",
	"load",
	"make-vector",
	"map",
	"max",
	"member",
	"memq",
	"memv",
	"min",
	"negative?",
	"newline",
	"not",
	"null?",
	"number?",
	"odd?",
	"or",
	"output-port?",
	"pair?",
	"positive?",
	"procedure?",
	"quasiquote",
	"quote",
	"quotient",
	"rational?",
	"read",
	"read-char",
	"real?",
	"remainder",
	"set!",
	"set-car!",
	"set-cdr!",
	"string->list",
	"string->symbol",
	"string-append",
	"string-length",
	"string-ref",
	"string<=?",
	"string<?",
	"string=?",
	"string>=?",
	"string>?",
	"string?",
	"substring",
	"symbol->string",
	"symbol?",
	"unquote",
	"unquote-splicing",
	"vector",
	"vector->list",
	"vector-length",
	"vector-ref",
	"vector-set!",
	"vector?",
	"write",
	"write-char",
	"zero?",
	NULL
};

char *directives[] = {
	"",
	NULL
};

