#ifndef lint
static char     rcsid[] = "$Header: lind.c,v 0.0 88/06/22 05:22:17 on Rel $";

#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

/*
 * Language-independent PostScript Interface.
 *
 * Use language dependent yylex() to output Postscript Macros:
 * (string) fname - take string to be the current filename.
 * (string) funct - take string to be the current function name.
 * (string) Font s - put string at current location, using Font.
 * n t - put n tabs
 * n n - put n newlines
 * n f - put n newpages
 */
extern char    *keywords[];	       /* Must be defined in scanner */
extern char    *directives[];          /* Must be defined in scanner */
extern FILE    *yyin;
extern FILE    *yyout;

#define yyoutput(C)	putc((C), yyout)

char           *font = "INITIAL";
int             bdone;		       /* a string is being output */


/*
 *	Make them ISO-8859-1 codes so that we can use
 *	the same re-encoding vectors as with normal
 *	ISO-Latin-1 characters.
 */

static char *scand_char = "[]\\{}|";

static char *scand_nrc[] = {
    "\\304",
    "\\305",
    "\\326",
    "\\344",
    "\\345",
    "\\366",
};

/*
 * Print yytext[], escaping postscript 'dirty' characters.
 * Start a postscript string output sequence, if necessary.
 */
echo (cp)
register char  *cp;
{
    register char	*tmp;
    static char		str[8];
    char		*index ();

    if (!*cp)
	return;

    if (bdone++ == 0)
	yyoutput ('(');
    for (; *cp; cp++) {
	if (tmp = index (scand_char, *cp)) {
	    for (tmp = scand_nrc[tmp - scand_char]; *tmp; tmp++) {
		yyoutput (*tmp);
	    }
	}
	else if (*cp & 0x80) {
	    sprintf (str, "\\%o", ((int) *cp) & 0xff);
	    for (tmp = str; *tmp; tmp++) {
		yyoutput (*tmp);
	    }
	}
	else {
	    switch (*cp) {
	    case '(':
	    case ')':
	    case '\\':
		yyoutput ('\\');
	    default:
		yyoutput (*cp);
	    }
	}
    }
}

/*
 * Terminate a string output sequence.
 */
sput ()
{
    if (bdone == 0)
	return;
    fprintf (yyout, ") %c s ", *font);
    bdone = 0;
}

/*
 * Output a string of tabs, newlines or formfeeds.
 */
space (s)
register char  *s;
{
    register        n,
                    prev;
    char           *fmt;

    while (*s) {
	for (prev = *s, n = 0; prev == *s; s++, n++);
	switch (prev) {
	case '\t':
	    fmt = "%d t\t";
	    break;
	case '\n':
	    fmt = "%d n\n";
	    break;
	case '\f':
	    fmt = "%d f\n";
	    break;
	}
	sput ();
	fprintf (yyout, fmt, n);
    }
}

/*
 * Print a subtitle.
 */
funct (s)
register char  *s;
{
    if (!*s)
	return;
    sput ();
    echo (s);
    fprintf (yyout, ") funct\n", s);
    bdone = 0;
}

/*
 * Is s a keyword?
 */
iskw (s)
register char  *s;
{
    register char **kw;

    for (kw = &keywords[1]; *kw; kw++) {
	register char  *kp = *kw;
	register char  *sp = s;

	while (*kp == *sp++)
	    if (*kp++ == '\0')
		return (kw - keywords);
    }
    return (0);
}

/*
 *	Is a preprocessor directive ?
 */

int isdirect (s)
register char  *s;

{
    register char **direc;

    for (direc = &directives[1]; *direc; direc++) {
	register char  *dp = *direc;
	register char  *sp = s;

	while (*dp == *sp++)
	    if (*dp++ == '\0')
		return (direc - directives);
    }
    return (0);
}

/*
 * Given a file descriptor, print its modification date.
 */
void            fdate (fd)
int             fd;
{
    struct stat     st;
    register char  *cp;
    extern char    *ctime ();

    if (fstat (fd, &st) < 0 || (st.st_mode & S_IFMT) != S_IFREG)
	time (&st.st_mtime);
    cp = ctime (&st.st_mtime);
    strcpy (&cp[16], &cp[19]);
    fprintf (yyout, "(%.17s) fdate\n", &cp[4]);
}

/*
 * yylex() each input file.
 */
main (argc, argv)
char          **argv;
{
    int             i;

    if (!yyout) {
	yyout = stdout;
    }

    if (argc == 1) {
	fdate (fileno (yyin = stdin));
	fprintf (yyout, "() fname\n");
	yylex ();
	sput ();
    }
    for (i = 1; i < argc; i++) {
	if (*argv[i] == '-') {
	    yyin = stdin;
	    *argv[i] = '\0';
	}
	else if ((yyin = fopen (argv[i], "r")) == NULL) {
	    perror (argv[i]);
	    continue;
	}

	fdate (fileno (yyin));
	fprintf (yyout, "(%s) fname\n", argv[i]);
	yylex ();
	sput ();
	if (yyin != stdin)
	    fclose (yyin);
    }
    exit (0);
}
