#include <stdio.h>
/*
 *	prc - Pages, Rows & Columns
 *	Count them in a file and report
 */

char           *wd = "prc";
struct prc {
    int             page;
    int             row;
    int             col;
};

struct prc      zero,
                max;
int             tab = 8;

main (argc, argv)
char          **argv;
{
    int             i;
    register FILE  *fp;

    while (argc > 1 && *argv[1] == '-') {
	switch (argv[1][1]) {
	case 'p':
	case 'r':
	case 'c':
	    wd = argv[1] + 1;
	    break;
	case 't':
	    if (tab = atoi (&argv[1][2]))
		break;
	    argc--;
	    argv++;
	    tab = atoi (argv[1]);
	    break;
	default:
	    fprintf (stderr,
		     "Usage: prc [-prc] [-t tab] [files]\n");
	    exit (1);
	}
	argc--;
	argv++;
    }

    i = 1;
    fp = stdin;

    do {
	if (argc > 1 && (fp = fopen (argv[i], "r")) == NULL) {
	    perror (argv[i]);
	    continue;
	}
	prc1 (fp);
	if (argc > 2)
	    printf (" %s", argv[i]);
	putchar ('\n');
	fclose (fp);
    } while (++i < argc);

    if (argc > 2) {
	prprc (&max);
	printf (" maximum\n");
    }
    exit (0);
}

#define MAX(A, B)	((A) > (B) ? (A) : (B))
#define ROUND(A, B)	((A + B) / (B) * (B))

prprc (prcp)
struct prc     *prcp;
{
    register char  *wdp = wd;

    while (*wdp)
	switch (*wdp++) {
	case 'p':
	    ipr (prcp->page);
	    break;

	case 'r':
	    ipr (prcp->row);
	    break;

	case 'c':
	    ipr (prcp->col);
	    break;

	}
}

ipr (num)
int             num;
{
    printf (" %7d", num);
}

prc1 (fp)
FILE           *fp;
{
    register int    c;
    struct prc      cur;
    struct prc      fil;

    cur = zero;
    fil = zero;
    if ((c = getc (fp)) == EOF) {
	prprc (&fil);
	return;
    }
    ungetc (c, fp);

    while ((c = getc (fp)) != EOF) {
	switch (c) {
	case '\b':
	    if (cur.col > 0)
		cur.col--;
	    break;
	case '\f':
	    cur.page++;
	    fil.row = MAX (cur.row, fil.row);
	    cur.row = -1;
	case '\n':
	    cur.row++;
	    fil.col = MAX (cur.col, fil.col);
	    cur.col = 0;
	    break;
	case '\t':
	    cur.col = ROUND (cur.col, tab);
	    break;
	default:
	    cur.col++;
	    break;
	};
    }

    fil.col = MAX (cur.col, fil.col);
    fil.row = MAX (cur.row, fil.row);
    fil.page = cur.page + 1;

    prprc (&fil);

    max.page = MAX (fil.page, max.page);
    max.row = MAX (fil.row, max.row);
    max.col = MAX (fil.col, max.col);
}
