rcsid='$Header: pps.sh,v 0.0 88/06/22 05:22:29 on Rel $'
#
# Argument processor and handshaker for C to postscript pretty printer
#
lib=.
usage="Usage: $0 [-C font] [-h header] [-l lang] [-t tabs] [-v pitch] [files]"
init=ppsinit
while [ x"$*" != x ]
do
	case $1 in
		-[ICSK])
:			${2?$usage}
			if font=`grep -w -i $2 $lib/fonts`
			then
				font=`echo $font | sed 's/ .*//'`
			else
				echo ${0}: ${2}: Unknown font 1>&2
				exit 17
			fi
			pos=`echo $1 | sed 's/-//'`
			init="fonts /$pos /$font put $init"
			shift
			;;
		-h)
:			${2?$usage}
			header=`echo "$2" | sed 's/[\\()]/\\\&/g'`
			init="/header ($header) def $init"
			shift
			;;
		-l)
:			${2?$usage}
			if [ ! -r $lib/$2 ]
			then
				echo ${0}: ${2}: Unknown language 1>&2
				exit 17
			fi
			lang=$2
			shift
			;;
		-n)
			init="/lineres ${2?$usage} def $init"
			shift;
			;;
		-p)
			init="/progsize ${2?$usage} def $init"
			shift;
			;;
		-s)
			if [ ! -r ${2?$usage} ]
			then
				echo ${0}: ${2} unreadable 1>&2
				exit 17
			fi
			shift
			;;
		-t)
			init="/tabstop ${2?$usage} def $init"
			shift;
			;;
		-v)
			init="/lpi ${2?$usage} def $init"
			shift;
			;;
		-?*)
			echo $usage 1>&2
			exit 19
			;;
		*)
			files="$files $1"
			;;
	esac
	shift
done

cat - ${prog-$lib/pps.pro} $style << EOC
%!PS-Adobe-1.0
%%Title: ${files-standard input}
%%Creator: $0 ($rcsid)
%%CreationDate: `date`
%%For: ${USER-unknown}@${HOST-`hostname || uuname -l`}
%%EndComments
EOC
echo $init && ${lib}/${lang=c} $files && echo "%%Trailer
ppsdone"
