.	\"$Header: pps.man,v 0.0 88/06/22 05:22:23 on Rel $
.\"
.\" .TH PPS 1L jau@tut.fi
.TH PPS 1L "14-Dec-1992" ukkonen@csc.fi
.if '\*(lb''.ds lb Library
.if '\*(lg''.ds lg C, awk, csh...
.if t .ds tm \(tm
.SH NAME
pps \- pretty printer for PostScript
.SH SYNOPSIS
.B pps 
[-h header] [-l language] [-s style] [-t tabs] [-v pitch] files
.SH DESCRIPTION
.B Pps
translates its input
.I files
to PostScript\*(tm
for printing on the
Apple LaserWriter\*(tm and similar devices.
When no input files are specified
(or when a ``-'' is given)
the standard input is read.
.PP
.B Pps
prints a header at the top of each page,
similar to the one printed by
.BR pr(1) .
The
.BI -h " text"
flag replaces the file name in the header with
.IR text .
Subtitles
are printed along the right edge of the page
whenever a new function is declared.
.PP
Formatting is language-sensitive:
The input language is specified by the
.BI -l " language"
flag
(default is C, see ``FILES'' below).
.PP
Since ``pretty'' is a matter of taste,
there are zillions of flags to modify the output style:
.IP "\fB-C \fP\fIfont\fP"
Use
.I font
for comments (default: New Century Schoolbook Roman).
.I Font
should be a PostScript name of an available font,
or a reasonable abbreviation.
.IP "\fB-K \fP\fIfont\fP"
Same, for keywords
(default: \f(CBCourier-Bold\fP).
.IP "\fB-S \fP\fIfont\fP"
Same, for strings and character constant
(default: \f(COCourier-Oblique\fP).
.IP "\fB-I \fP\fIfont\fP"
Same, for the rest of the text (default: \fCCourier\fP).
.IP "\fB-n \fP\fIn\fP"
prints line numbers every \fIn\fPth line (default 10).
.IP "\fB-t \fP\fIn\fP"
sets the tab stops to be
.I n
characters wide.
On proportional spacing fonts,
a character width is taken to be the width of
the letter ``n''
of the normal font.
.IP "\fB-v \fP\fIn\fP"
Set the vertical pitch to be
.I n
lines per inch
(default 7).
.PP
.IP "\fB-s \fPstyle"
Source a PostScript program in file
.I style
to override some of the
constants and macros,
hence get a different formatting style.
.SH CHARSETS
Pps and slide now support the full set of ISO-8859-1 standard characters.
They can also be used to print ordinary text files using ISO standard
Finnish and Swedish NRCs \fI(National Replacement Characters)\fP by
specifying ``\fB-l scand\fP'' language definition instead of ``\fB-l text\fP''.
.SH FILES
.nf
\*(lb/{\*(lg} \-
	language sensitive front end processors
\*(lb/fonts \- list of font names and abbreviations
.fi
.SH "SEE ALSO"
vgrind(1), pr(1), slide(1L)
.SH BUGS
.nf
Function declarations are naively detected.
There are too many options.
.fi
.SH MODIFICATIONS
Support for ISO-Latin1 and fin/swe NRCs added by Jukka Ukkonen
(ukkonen@csc.fi), 14-Dec-1992.
