%{
#ifndef lint
static char rcsid[] = "$Header: pascal.l,v 0.0 88/06/22 05:22:01 on Rel $";
#endif
#include "pps.h"
#include <ctype.h>

int nbrace;
%}
letter	[A-Za-z_]
digit	[0-9]
white	[ \t]
%Start COMMENT STRING KEYWORD
%%
<INITIAL>^{white}*{letter}({letter}|{digit})*/{white}*\(	{
			register char *cp = yytext;
			if (nbrace == 0) {
				while (isspace(*cp++))
					;
				funct(--cp);
			}
			REJECT;
		}
<INITIAL>{letter}({letter}|{digit})*	{
			register char	*cp;
			register int	kw;
			
			for (cp = yytext; *cp; cp++) {
				*cp = ((*cp >= 'A') && (*cp <= 'Z'))
				     ? *cp + 32 : *cp;
			}
				
			kw = iskw(yytext);
			if (kw) {
				begin(KEYWORD);
				if( strcmp( yytext, "begin" ) == 0 )
					nbrace++;
				else if( strcmp( yytext, "end" ) == 0 )
					nbrace--;
			}
			ECHO;
			if (kw)
				begin(INITIAL);
		}
<INITIAL>\'	{ begin(STRING); ECHO; }
<INITIAL>\(\*	{ begin(COMMENT); ECHO; }
<STRING>\'\'	{ ECHO; }
<STRING>\'	{ ECHO; begin(INITIAL); }
<COMMENT>\*\)	{ ECHO; begin(INITIAL); }
[\t\n\f]+	{ space(yytext); }
<INITIAL>\{	{ begin(COMMENT); ECHO; }
<COMMENT>\}	{ ECHO; begin(INITIAL); }
.		{ ECHO; }
%%
/*
 *	These should be sorted by frequency.	;-)
 */

char *keywords[] = {
	"",
	"and",
	"array",
	"begin",
	"case",
	"const",
	"div",
	"do",
	"downto",
	"else",
	"end",
	"file",
	"for",
	"forward",
	"function",
	"goto",
	"if",
	"in",
	"label",
	"mod",
	"nil",
	"not",
	"of",
	"or",
	"packed",
	"procedure",
	"program",
	"record",
	"repeat",
	"set",
	"then",
	"to",
	"type",
	"until",
	"var",
	"while",
	"with",
	NULL
};

char *directives[] = {
	"",
	NULL
};

