%{
#ifndef lint
static char rcsid[] = "$Header: occam.l,v 0.0 89/04/16 05:22:01 on Rel $";
#endif
#include <stdio.h>
#include "pps.h"
#include <ctype.h>

int nbrace;
%}
letter	[A-Za-z.]
digit	[0-9]
white	[ \t]
%Start COMMENT STRING KEYWORD STRING2
%%

<INITIAL>{letter}({letter}|{digit})*	{
			register int	kw;
			
			kw = iskw(yytext);

			if (kw)
				begin(KEYWORD);
			ECHO;
			if (kw)
				begin(INITIAL);
		}

<INITIAL>\'\*/.\'	{ begin(STRING2); ECHO; }
<INITIAL>\'/.\'		{ begin(STRING2); ECHO; }
<INITIAL>\"		{ begin(STRING); ECHO; }
<INITIAL>\-\-		{ begin(COMMENT); ECHO; }
<STRING2>[\t\f]\'	{
			    yytext[1] = '\0';
			    space(yytext);
			    strcpy (yytext, "'");
			    ECHO;
			    begin(INITIAL);
			}
<STRING2>.\'		{ ECHO; begin(INITIAL); }
<STRING>\*\"		{ ECHO; }
<STRING>\"		{ ECHO; begin(INITIAL); }
<COMMENT>[\n\f]		{ space(yytext); begin(INITIAL); }
<STRING>[\t\n\f]+	{ space(yytext); }
<COMMENT>[\t]+		{ space(yytext); }
<INITIAL>[\t\n\f]+	{ space(yytext); }
.			{ ECHO; }
%%
/*
 * This should better be sorted by frequency.
 */
char *keywords[] = {
	"",
	"AFTER",
	"ALT",
	"AND",
	"ANY",
	"AT",
	"BITAND",
	"BITNOT",
	"BITOR",
	"BOOL",
	"BYTE",
	"CASE",
	"CHAN",
	"ELSE",
	"FOR",
	"FROM",
	"FUNCTION",
	"IF",
	"IS",
	"INT",
	"INT16",
	"INT32",
	"INT64",
	"MINUS",
	"MOSTNEG",
	"MOSTPOS",
	"NOT",
	"OF",
	"OR",
	"PAR",
	"PLACE",
	"PLACED",
	"PLUS",
	"PORT",
	"PRI",
	"PROC",
	"PROCESSOR",
	"PROTOCOL",
	"REAL32",
	"REAL64",
	"REM",
	"RESULT",
	"RETYPES",
	"ROUND",
	"SEQ",
	"SIZE",
	"SKIP",
	"STOP",
	"TIMER",
	"TIMES",
	"TRUE",
	"TRUNC",
	"VAL",
	"VALOF",
	"WHILE",
	NULL
};

char *directives[] = {
	"",
	NULL
};

