%{
#ifndef lint
static char rcsid[] = "$Header: modula2.l,v 0.0 88/06/22 05:22:01 on Rel $";
#endif
#include "pps.h"
#include <ctype.h>

static int	Comments = 0;
int nbrace;
static int	Was_Proc = 0;

%}
letter	[A-Za-z_]
digit	[0-9]
white	[ \t]
%Start COMMENT STRING KEYWORD STRING2
%%
<INITIAL>{letter}({letter}|{digit})*	{
			register int	kw;
							
			kw = iskw(yytext);
			if (kw) {
				begin(KEYWORD);

				if( strcmp( yytext, "BEGIN" ) == 0 ) {
				    Was_Proc = 0;
				    nbrace++;
				}
				else if( strcmp( yytext, "END" ) == 0 ) {
				    Was_Proc = 0;
				    if (nbrace)
					nbrace--;
				}
				else if( strcmp( yytext, "PROCEDURE" ) == 0 )
					Was_Proc = 1;
				else
					Was_Proc = 0;
			}
			else {
			    if (Was_Proc && !nbrace)
				funct(yytext);

			    Was_Proc = 0;
			}

			ECHO;
			if (kw)
				begin(INITIAL);
		}
<INITIAL>\'	{ begin(STRING); ECHO; }
<INITIAL>\"	{ begin(STRING2); ECHO; }
<INITIAL>\(\*	{
		    begin(COMMENT);
		    Comments++;
		    ECHO;
		}
<COMMENT>\(\*	{
		    Comments++;
		    ECHO;
		}
<STRING>\'	{ ECHO; begin(INITIAL); }
<STRING2>\"	{ ECHO; begin(INITIAL); }
<COMMENT>\*\)	{
		    ECHO;
		    Comments--;
		    if (Comments == 0) {
			begin(INITIAL);
		    }
		}
[\t\n\f]+	{
		    if (Comments)
			begin (INITIAL);

		    space(yytext);

		    if (Comments)
			begin (COMMENT);
		}
\ +		{
		    if (Comments)
			begin (INITIAL);

		    ECHO;

		    if (Comments)
			begin (COMMENT);
		}
.		{ ECHO; }
%%
/*
 *	These should be sorted by frequency.	;-)
 */

char *keywords[] = {
	"",
	"AND",
	"ARRAY",
	"BEGIN",
	"BY",
	"CASE",
	"CONST",
	"DEFINITION",
	"DIV",
	"DO",
	"ELSE",
	"ELSIF",
	"END",
	"EXIT",
	"EXPORT",
	"FOR",
	"FROM",
	"IF",
	"IMPLEMENTATION",
	"IMPORT",
	"IN",
	"LOOP",
	"MOD",
	"MODULE",
	"NOT",
	"OF",
	"OR",
	"POINTER",
	"PROCEDURE",
	"QUALIFIED",
	"RECORD",
	"REPEAT",
	"RETURN",
	"SET",
	"THEN",
	"TO",
	"TYPE",
	"UNTIL",
	"VAR",
	"WHILE",
	"WITH",
	NULL
};

char *directives[] = {
	"",
	NULL
};

