%{
#ifndef lint
static char rcsid[] = "$Header: pascal.l,v 0.0 88/06/22 05:22:01 on Rel $";
#endif
#include "pps.h"
#include <ctype.h>

int nbrace;
%}
letter	[A-Za-z_]
digit	[0-9]
white	[ \t]

%Start COMMENT STRING KEYWORD
%%

<INITIAL>\$\$[enstENST\$]	{ begin(STRING); ECHO; begin(INITIAL); }
<INITIAL>\$.	{ begin(STRING); ECHO; begin(INITIAL); }

<INITIAL>^{white}*{letter}({letter}|{digit})*/{white}*\(	{
			register char *cp = yytext;
			if (nbrace == 0) {
				while (isspace(*cp++))
					;
				funct(--cp);
			}
			REJECT;
		}

<INITIAL>{letter}({letter}|{digit})*	{
			register char	*cp;
			register int	kw;
			
			for (cp = yytext; *cp; cp++) {
				*cp = ((*cp >= 'A') && (*cp <= 'Z'))
				     ? *cp + 32 : *cp;
			}
				
			kw = iskw(yytext);
			if (kw) {
				begin(KEYWORD);
				if( strcmp( yytext, "begin" ) == 0 )
					nbrace++;
				else if( strcmp( yytext, "end" ) == 0 )
					nbrace--;
			}
			ECHO;
			if (kw)
				begin(INITIAL);
		}
<INITIAL>\'	{ begin(STRING); ECHO; }
<STRING>\$\'	{ ECHO; }
<STRING>\'	{ ECHO; begin(INITIAL); }
[\t\n\f]+	{ space(yytext); }
<INITIAL>\{	{ begin(COMMENT); ECHO; }
<COMMENT>\}	{ ECHO; begin(INITIAL); }
.		{ ECHO; }
%%
/*
 *	These should be sorted by frequency.	;-)
 */

char *keywords[] = {
	"",			/* 80 reserved words */
	"abstraction",
	"aligned",
	"all",
	"and",
	"any",
	"array",
	"assert",
	"at",
	"begin",
	"bind",
	"bits",
	"bound",
	"busy",
	"case",
	"checkable",
	"checked",
	"code",
	"collection",
	"condition",
	"const",
	"converter",
	"counted",
	"decreasing",
	"default",
	"dependent",
	"div",
	"else",
	"elseif",
	"empty",
	"end",
	"exit",
	"exports",
	"external",		/* Added afterwards */
	"finally",
	"for",
	"forward",
	"from",
	"function",
	"if",
	"imports",
	"in",
	"include",
	"initially",
	"inline",
	"invariant",
	"loop",
	"machine",
	"mod",
	"module",		/* Added afterwards */
	"monitor",
	"not",
	"of",
	"or",
	"otherwise",
	"packed",
	"parameter",
	"pervasive",
	"post",
	"pre",
	"priority",
	"procedure",
	"process",
	"readonly",
	"record",
	"register",
	"return",
	"returns",
	"set",
	"signal",
	"then",
	"thus",
	"to",
	"type",
	"universal",
	"unknown",
	"var",
	"wait",
	"when",
	"with",
	"xor",
	NULL
};

char *directives[] = {
	"",
	NULL
};

