%{
#ifndef lint
static char rcsid[] = "$Header: ada.l,v 0.0 89/04/16 05:22:01 on Rel $";
#endif
#include <stdio.h>
#include "pps.h"
#include <ctype.h>

int nbrace;
%}
letter	[A-Za-z_]
digit	[0-9]
white	[ \t]
%Start COMMENT STRING KEYWORD STRING2
%%

<INITIAL>^{white}*{letter}({letter}|{digit})*/{white}*\(	{
			REJECT;
		}
<INITIAL>{letter}({letter}|{digit})*	{
			register char	*cp;
			register int	kw;
			
			for (cp = yytext; *cp; cp++) {
				*cp = ((*cp >= 'A') && (*cp <= 'Z'))
				     ? *cp + 32 : *cp;
			}
				
			kw = iskw(yytext);

			if (kw) {
				begin(KEYWORD);
				if( strcmp( yytext, "begin" ) == 0 )
					nbrace++;
				else if( strcmp( yytext, "end" ) == 0 )
					nbrace--;
			}
			ECHO;
			if (kw)
				begin(INITIAL);
		}

<INITIAL>\'/.\'	{ begin(STRING2); ECHO; }
<INITIAL>\"	{ begin(STRING); ECHO; }
<INITIAL>\-\-	{ begin(COMMENT); ECHO; }
<STRING2>[\t\f]\'   {
			yytext[1] = '\0';
			space(yytext);
			strcpy (yytext, "'");
			ECHO;
			begin(INITIAL);
		    }
<STRING2>.\'	{ ECHO; begin(INITIAL); }
<STRING>\"\"	{ ECHO; }
<STRING>\"	{ ECHO; begin(INITIAL); }
<COMMENT>[\n\f]	{ space(yytext); begin(INITIAL); }
<STRING>[\t\n\f]+	{ space(yytext); }
<COMMENT>[\t]+	{ space(yytext); }
<INITIAL>[\t\n\f]+	{ space(yytext); }
.		{ ECHO; }
%%
/*
 *	These should be sorted by frequency.	;-)
 */

char *keywords[] = {
	"",
	"abs",
	"action",
	"all",
	"allow",
	"and",
	"as",
	"ask",
	"assert",
	"by",
	"class",
	"closure",
	"creation",
	"dead",
	"do",
	"else",
	"elsif",
	"end",
	"exists",
	"extend",
	"extended",
	"for",
	"function",
	"hide",
	"if",
	"in",
	"include",
	"infinity",
	"inherit",
	"is",
	"loop",
	"mod",
	"new",
	"not",
	"null",
	"of",
	"one",
	"or",
	"remove",
	"rename",
	"set",
	"state",
	"subset",
	"system",
	"then",
	"transforming",
	"when",
	"with",
	NULL
};

char *directives[] = {
	"",
	NULL
};

