%{
#ifndef lint
static char rcsid[] = "$Header: csh.l,v 0.0 88/06/22 05:22:04 on Rel $";
#endif
#include "pps.h"
#include <ctype.h>

int nbrace;
%}
letter	[A-Za-z_]
digit	[0-9]
white	[ \t]
builtin	[\$\<\*0-9]
%Start COMMENT STRING1 STRING2 KEYWORD
%%
<INITIAL>{letter}({letter}|{digit})*/{white}*:	{
			funct(yytext);
			REJECT;
		}
<INITIAL>{letter}({letter}|{digit})*	{
			int kw = iskw(yytext);
			if (kw)
				begin(KEYWORD);
			ECHO;
			if (kw)
				begin(INITIAL);
		}
<INITIAL>\"	{ begin(STRING1); ECHO; }
<INITIAL>\'	{ begin(STRING2); ECHO; }
<INITIAL>#.*	{ begin(COMMENT); ECHO; begin(INITIAL); }
<STRING1>\\.	{ ECHO; }
<STRING2>\\.	{ ECHO; }
<STRING1>\"	{ ECHO; begin(INITIAL); }
<STRING2>\'	{ ECHO; begin(INITIAL); }
<INITIAL>\${builtin}	{ begin(KEYWORD); ECHO; begin(INITIAL); }
<STRING1>\${builtin}	{ begin(KEYWORD); ECHO; begin(STRING1); }
<INITIAL>\$	{ begin(KEYWORD); ECHO; begin(INITIAL); }
<STRING1>\$	{ begin(KEYWORD); ECHO; begin(STRING1); }
[\t\n\f]+	{ space(yytext); }
.		{ ECHO; }
%%
char *keywords[] = {
	"",
	"alias",
	"alloc",
	"break",
	"breaksw",
	"case",
	"cd",
	"chdir",
	"continue",
	"default",
	"echo",
	"else",
	"end",
	"endif",
	"endsw",
	"exec",
	"exit",
	"foreach",
	"glob",
	"goto",
	"history",
	"if",
	"logout",
	"nice",
	"nohup",
	"onintr",
	"repeat",
	"set",
	"setenv",
	"shift",
	"source",
	"switch",
	"then",
	"time",
	"while",
	"umask",
	"unalias",
	"unset",
	"wait",
	"while",
	"@",
	"env",
	"argv",
	"child",
	"home",
	"ignoreeof",
	"noclobber",
	"noglob",
	"nomatch",
	"path",
	"prompt",
	"shell",
	"status",
	"verbose",
	NULL
};

char *directives[] = {
	"",
	NULL
};

