%{
#ifndef lint
static char rcsid[] = "$Header: c.l,v 0.0 88/06/22 05:22:01 on Rel $";
#endif
#include "pps.h"
#include <ctype.h>

int nbrace;
%}
letter	[A-Za-z_]
digit	[0-9]
white	[ \t]
%Start COMMENT STRING1 STRING2 KEYWORD
%%
<INITIAL>^[#]{white}*{letter}+	{
				    register char *cp;
				
				    for (cp = &yytext[1];
				         !islower(*cp); cp++);

				    if ( isdirect(cp) ) {
					begin(KEYWORD);
					ECHO;
					begin(INITIAL);
				    }
				    else {
					ECHO;
				    }
				}
<INITIAL>^{white}*{letter}({letter}|{digit})*/{white}*\(	{
			register char *cp = yytext;
			if (nbrace == 0) {
				while (isspace(*cp++))
					;
				funct(--cp);
			}
			REJECT;
		}
<INITIAL>{letter}({letter}|{digit})*	{
			int kw = iskw(yytext);
			if (kw) {
			    begin(KEYWORD);
			    ECHO;
			    begin(INITIAL);
			}
			else {
			    ECHO;
			}
		}
<INITIAL>\"	{ begin(STRING1); ECHO; }
<INITIAL>\'	{ begin(STRING2); ECHO; }
<INITIAL>\/\*	{ begin(COMMENT); ECHO; }
<STRING1>\\.	{ ECHO; }
<STRING2>\\.	{ ECHO; }
<STRING1>\"	{ ECHO; begin(INITIAL); }
<STRING2>\'	{ ECHO; begin(INITIAL); }
<COMMENT>\*\/	{ ECHO; begin(INITIAL); }
[\t\n\f]+	{ space(yytext); }
<INITIAL>\{	{ nbrace++; REJECT; }
<INITIAL>\}	{ nbrace--; REJECT; }
.		{ ECHO; }
%%
/*
 *	These should be sorted by frequency.	;-)
 */
 
char *keywords[] = {
	"",
	"asm",
	"auto",
	"break",
	"case",
	"char",
	"continue",
	"default",
	"do",
	"double",
	"else",
	"entry",
	"extern",
	"float",
	"for",
	"fortran",
	"goto",
	"if",
	"int",
	"long",
	"register",
	"return",
	"short",
	"sizeof",
	"static",
	"struct",
	"switch",
	"typedef",
	"union",
	"unsigned",
	"void", 
	"while",
	NULL
};

char *directives[] = {
	"",
	"define",
	"else",
	"endif",
	"if",
	"ifdef",
	"ifndef",
	"include",
	"line",
	"undef",
	NULL
};

