%{
#ifndef lint
static char rcsid[] = "$Header: awk.l,v 0.0 88/06/22 05:21:58 on Rel $";
#endif
#include "pps.h"
#include <ctype.h>

int nbrace;
%}
letter	[A-Za-z_]
digit	[0-9]
white	[ \t]
%Start COMMENT STRING1 STRING2 KEYWORD
%%
<INITIAL>{letter}({letter}|{digit})*/{white}*:	{
			funct(yytext);
			REJECT;
		}
<INITIAL>{letter}({letter}|{digit})*	{
			int kw = iskw(yytext);
			if (kw)
				begin(KEYWORD);
			ECHO;
			if (kw)
				begin(INITIAL);
		}
<INITIAL>\"	{ ECHO; begin(STRING1); }
<STRING1>\\.	{ ECHO; }
<STRING1>\"	{ begin(INITIAL); ECHO; }
<INITIAL>~[ \t]*\/	{ ECHO; begin(STRING2); }
<INITIAL>^[ \t]*\/	{
			if (!nbrace) {
				ECHO;
				begin(STRING2);
			} else
				REJECT;
		}
<STRING2>\\.	{ ECHO; }
<STRING2>\/	{ begin(INITIAL); ECHO; }
<INITIAL>\{	{ ECHO; nbrace++; }
<INITIAL>\}	{ ECHO; nbrace--; }
<INITIAL>#.*	{ begin(COMMENT); ECHO; begin(INITIAL); }
[\t\n\f]+	{ space(yytext); }
.		{ ECHO; }
%%
char *keywords[] = {
	"",
	"BEGIN",
	"END",
	"FILENAME",
	"FS",
	"NF",
	"NR",
	"OFMT",
	"OFS",
	"ORS",
	"RS",
	"break",
	"continue",
	"else",
	"exit",
	"exp",
	"for",
	"getline",
	"if",
	"in",
	"int",
	"index",
	"length",
	"log",
	"next",
	"print",
	"printf",
	"split",
	"sprintf",
	"sqrt",
	"substr",
	"while",
	NULL
};

char *directives[] = {
	"",
	NULL
};

