/********************************************************************
 * $Author: lindner $
 * $Revision: 1.2 $
 * $Date: 1993/01/13 16:22:52 $
 * $Source: /home/mudhoney/GopherSrc/gopher1.11b/object/RCS/Wait.h,v $
 * $State: Rel $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: Wait.h
 * Routines that portably define wait3()
 *********************************************************************
 * Revision History:
 * $Log: Wait.h,v $
 * Revision 1.2  1993/01/13  16:22:52  lindner
 * Fixed wait3 macro to work.
 *
 * Revision 1.1  1992/12/10  23:27:52  lindner
 * gopher 1.1 release
 *
 *
 *********************************************************************/


/*
 * A header file to portably include the stuff for doing wait3() etal
 */

#if defined(_AIX)  /** AIX needs bsd signals.  **/
#define _BSD
#endif

#ifdef M_XENIX
#define __SCO_WAIT3__
#endif

#include <sys/ioctl.h>
#include <sys/wait.h>
#include <signal.h>

#if defined(_SEQUENT_) || defined(POSIXWAIT) || defined(_POSIX_SOURCE)
typedef int Portawait;
#define wait3(a,b,c) waitpid(-1,a,b)
#else
typedef union wait Portawait;
#endif

