/********************************************************************
 * $Author: lindner $
 * $Revision: 1.2 $
 * $Date: 1993/01/13 16:21:08 $
 * $Source: /home/mudhoney/GopherSrc/gopher1.11b/object/RCS/Dirent.h,v $
 * $State: Rel $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: Dirent.h
 * Portably include dir.h dirent.h, etc.
 *********************************************************************
 * Revision History:
 * $Log: Dirent.h,v $
 * Revision 1.2  1993/01/13  16:21:08  lindner
 * Added defined(USG) for dirent.h
 *
 * Revision 1.1  1992/12/10  23:27:52  lindner
 * gopher 1.1 release
 *
 *
 *********************************************************************/


/*** These need dir.h for sure ***/

#if defined(NeXT) || defined(n16) || defined(sequent)
#  include <sys/dir.h>
#  define  dirent direct
#  define S_ISDIR(m)      (((m)&S_IFMT) == S_IFDIR)
#  define S_ISREG(m)      (((m)&S_IFMT) == S_IFREG)

/*** These can use dirent for sure ***/

#else
#  if  defined(sun) || defined(ultrix) || defined(hpux) || defined(__sgi) ||          defined(_AIX) || defined(_SYSV_SOURCE) || defined(sgi) || defined(cray)        || defined (_POSIX_SOURCE) || defined(_SEQUENT_) || defined(M_XENIX) ||        defined(USG)
#      include <dirent.h>

/*** Everyone else gets dir.h, plus some funky definitions ***/

#  else
#      include <sys/dir.h>
#      define  dirent direct
#      define S_ISDIR(m)      (((m)&S_IFMT) == S_IFDIR)
#      define S_ISREG(m)      (((m)&S_IFMT) == S_IFREG)
#  endif
#endif
