From comp.infosystems.gopher Mon Oct 19 11:52:09 1992
Path: news.cis.umn.edu!umn.edu!umeecs!caen!zaphod.mps.ohio-state.edu!darwin.sura.net!jvnc.net!netnews.upenn.edu!msuinfo!news
From: boone@convex.cl.msu.edu (Dennis Boone)
Newsgroups: comp.infosystems.gopher
Subject: newitems script
Keywords: new items directory gopher links
Message-ID: <1992Oct13.193502.9334@msuinfo.cl.msu.edu>
Date: 13 Oct 92 19:35:02 GMT
Sender: news@msuinfo.cl.msu.edu
Organization: Michigan State University, East Lansing
Lines: 177

We wanted to be able to provide a listing of new/recently changed items
in our Gopher server.  The attached script is the tool I developed to 
provide this.  It generates a link file, so the listing is a directory,
not a flat file.  The user-visible name is carried over.

Usage:  newitems /disk/path/name -#daysold server.domain.name #port

The link file it generates is called .newlinks in the current directory.
If you place a file called .nonew in a directory, that directory is skipped.
If you place a file called .topnew in a directory, that directory will be
listed if any new files are found in that directory or its subdirectories.
This script depends on the gopherls tool which is a link to the gopherd 
program, starting with version (approx) 1.0.  You'll obviously be needing
Perl.

This script seems to be working for me, but hasn't been tested exhaustively.

Dennis
----------------------------------------------------------------------
#!/usr/local/bin/perl
# newitems, boone, 09/30/92
# Generate a link file listing new items in the last n days
# Copyright (C) 1992, Trustees of Michigan State University
#
# Modifications:
# 09/30/92 Boone      Initial coding
# 10/01/92 Boone      Added ability to exclude individual directories
# End Modifications

# Extract path part of pathname

sub path
{
	local($path) = @_;
	local($pathsep) = rindex($path, "/");
	if ($pathsep < 0)
	{
		return "";
	}
	else
	{
		$wanted = substr($path, 0, $pathsep+1);
		return $wanted;
	}
}

# Extract filename part of pathname

sub base
{
	local($path) = @_;
	local($pathsep) = rindex($path, "/");
	if ($pathsep < 0)
	{
		return $path;
	}
	else
	{
		$wanted = substr($path, $pathsep+1);
		return $wanted;
	}
}

# Determine whether this item is part of a subtree which wants to be
# announced as a single new entry if any file in it has changed.  <pant>
# Example: /news/newspapers/state_news contains a file called .topnew,
# indicating that any file in the state news subtree will cause the
# /news/newspapers/state_news entry to be listed once in the new items
# list.

sub skip
{
	local(@args) = @_;
	foreach $i (@topnew)
	{
		if (index($args[0], $i) == 0)
		{
			$toplist{$i} = $args[0];
			return 1;
		}
		else
		{
		}
	} 
	return 0;
}

# Write a link file entry

sub writelink
{
	local($line, $path) = @_;
	local(@fields) = split(/\t/, $line);
	local($name) = substr($fields[0], 1);
	local($type) = substr($fields[0], 0, 1);
	print LF "Name=$name\nType=$type\nPath=$path\nHost=$host\nPort=$port\n\n";
}

# The real code

$[ = 0;
if ($#ARGV < 3)
{
	print STDERR "Usage: newitems  path days host port\n";
	exit(1);
}

open(LF, ">.newlinks") || die "Unable to create .newlinks\n";
chdir($ARGV[0]);
chop($here = `pwd`);
$days = $ARGV[1];
$host = $ARGV[2];
$port = $ARGV[3];

@topnew = `find . -name .topnew -print`;
foreach $i (@topnew)
{
	$i = &path($i);
}
open(NF, "find . -mtime $days -type f -print | grep -v .cap |") || 
	die "Unable to spawn find\n";
while (<NF>)
{
	next if /\.cap/;
	next if /\.ts/;
	next if /\.bin/;
	chop;
	$path = &path($_);
	$base = &base($_);
	next if ($base =~ /^\./);
	chdir($path) || die "chdir($path) died: $!\n";
	if (! -f ".nonew")
	{
		@lines = `/usr/local/etc/gopherls .`;
		foreach $i (@lines)
		{
			chop($i); chop($i);
			@fields = split(/\t/, $i);
			$thisname = substr($fields[1], 2);
			if ($thisname eq $base)
			{
				if (! &skip($_))
				{
					&writelink($i, $_);
				}
			}
			undef(@fields);
		}
		undef(@lines);
	}
	chdir($here) || die "chdir($here) died: $!\n";
}
foreach $i (keys %toplist)
{
	chop($i);
	$base = &base($i);
	chdir($i) || die "chdir($path) died: $!\n";
	chdir("..") || die "chdir(..) died: $!\n";
	@lines = `/usr/local/etc/gopherls .`;
	foreach $j (@lines)
	{
		chop($j); chop($j);
		@fields = split(/\t/, $j);
		$thisname = substr($fields[1], 2);
		if ($thisname eq $base)
		{
			&writelink($j, $i);
		}
		undef(@fields);
	}
	undef(@lines);
	chdir($here) || die "chdir($here) died: $!\n";
}
close(NF);
close(LF);
--
 == If you choose not to decide, you still have made a choice. ==

