/********************************************************************
 * $Author: lindner $
 * $Revision: 1.1 $
 * $Date: 1992/12/21 20:46:12 $
 * $Source: /home/mudhoney/GopherSrc/release1.11/gopherd/RCS/kernutils.c,v $
 * $State: Exp $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: kernutils.c
 * Routines to implement kernel specific stuff
 *********************************************************************
 * Revision History:
 * $Log: kernutils.c,v $
 * Revision 1.1  1992/12/21  20:46:12  lindner
 * Initial revision
 *
 *
 *********************************************************************/


#include "gopherd.h"

#define LOADSYMBOL "_avenrun"    /* should work with most Unix flavors */

#define WHICHLOAD  2             /* 0 ==  1 min average           */
                                 /* 1 ==  5 min average           */
                                 /* 2 == 15 min average           */

#ifndef LOADRESTRICT

double maxload = 0;

int LoadTooHigh() 
{
  return(0);
}

#else /* LOADRESTRICT */

int LoadTooHigh()
{
  int status;

  status = getload();
  if(DEBUG)
    printf("getload returns %d\n",status);
  return(status);

}

#ifndef MAXLOAD
#define MAXLOAD 10.0
#endif
double atof();
double maxload = MAXLOAD;
double sysload = 0.0;
#include <nlist.h>
#include <kvm.h>
#define X_AVENRUN 0
long avenrun[3];
kvm_t * kd;
struct nlist nl[] = { {LOADSYMBOL}, {""}, };

int getload()
{
  if ((kd = kvm_open(NULL, NULL, NULL, O_RDONLY, NULL)) == NULL) 
    return(-1);
  if (kvm_nlist(kd, nl) != 0) 
    return(-1);
  if(nl[X_AVENRUN].n_type == 0) 
    return(-1);
  if(kvm_read(kd,nl[X_AVENRUN].n_value,avenrun,sizeof(avenrun)) 
     != sizeof(avenrun)) 
    return(-1);
  if((sysload = (((double) avenrun[WHICHLOAD]) / FSCALE)) > maxload) {
    if(DEBUG)
      printf("System maxload %f exceeded (currently %f)\n",maxload,sysload);
    return(1);
  }
  return(0);
}
#endif /* LOADRESTRICT */     









