/********************************************************************
 * $Author: lindner $
 * $Revision: 1.1 $
 * $Date: 1992/12/10 23:13:27 $
 * $Source: /home/mudhoney/GopherSrc/release1.11/gopherd/RCS/gopherdconf.c,v $
 * $Status: $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: gopherdconf.c
 * Routines to parse the gopherd.conf file.
 *********************************************************************
 * Revision History:
 * $Log: gopherdconf.c,v $
 * Revision 1.1  1992/12/10  23:13:27  lindner
 * gopher 1.1 release
 *
 *
 *********************************************************************/


#include "gopherdconf.h"
#include "Malloc.h"
#include "String.h"
#include <stdio.h>

extern boolean DEBUG;

/*********************************************/

GDCobj *
GDCnew()
{
     GDCobj *gdc;

     gdc = (GDCobj *) malloc(sizeof(GDCobj));

     gdc->Extensions = ExtArrayNew();

     gdc->Sites      = SiteArrayNew();
     gdc->Securityon   = FALSE;

     gdc->RunFromInetd = FALSE;
     gdc->Caching      = TRUE;

     gdc->Logfile      = STRnew();
     gdc->Data_Dir     = STRnew();
     gdc->Hostname     = STRnew();
     gdc->Port         = 0;
     gdc->chroot       = TRUE;
     gdc->Defaccess    = ACC_FULL;
     gdc->BummerMsg    = STRnew();
     
     gdc->Admin        = STRnew();
     gdc->AdminEmail   = STRnew();

     gdc->Site         = STRnew();
     gdc->Org          = STRnew();
     gdc->Geog         = STRnew();
     gdc->Loc          = STRnew();

     gdc->TZ           = 0;

     STRset(gdc->Logfile, "");
     STRset(gdc->BummerMsg, "");
     STRset(gdc->Hostname, "");

     return(gdc);
}

void
GDCdestroy(gdc)
  GDCobj *gdc;
{
     ExtArrDestroy(gdc->Extensions);
     SiteArrDestroy(gdc->Sites);

}


boolean
GDCtokens(gdc, token, rest)
  GDCobj *gdc;
  char *token;
  char *rest;
{
     boolean success = TRUE;

     if (DEBUG)
	  printf("Parsed token '%s', rest of line '%s'\n", token, rest);
     
     if (strcasecmp(token, "ACCESS") == 0) {
	  int moo;
	  success = SiteProcessLine(gdc->Sites, rest, gdc->Defaccess);
	  moo = SiteAccess(gdc->Sites, "default");
	  if (moo != ACC_UNKNOWN)
	       gdc->Defaccess = moo;

	  gdc->Securityon = TRUE;
     }

     else if (strcasecmp(token, "ADMIN")==0)
	  GDCsetAdmin(gdc, rest);
     else if (strcasecmp(token, "ADMINEMAIL")==0)
	  GDCsetAdminEmail(gdc, rest);
     else if (strcasecmp(token, "HOSTALIAS")==0)
	  GDCsetHostname(gdc, rest);
     else if (strcasecmp(token, "SITE")==0)
	  GDCsetSite(gdc, rest);
     else if (strcasecmp(token, "ORG")==0)
	  GDCsetOrg(gdc, rest);
     else if (strcasecmp(token, "LOC")==0)
	  GDCsetLoc(gdc, rest);
     else if (strcasecmp(token, "LOGFILE")==0)
	  GDCsetLogfile(gdc, rest);
     else if (strcasecmp(token, "BUMMERMSG")==0)
	  GDCsetBummerMsg(gdc, rest);
     else if (strcasecmp(token, "EXT")==0) {
	  success = ExtProcessLine(gdc->Extensions, rest);
     }
     else if (strcasecmp(token, "IGNORE")==0) {
	  ExtAdd(gdc->Extensions, '3', "","",rest);
     }
     else
	  success = FALSE;
     
     return(success);
}

void
GDCfromFile(gdc, filename)
  GDCobj *gdc;
  char *filename;
{
     FILE *gdcfile;
     char inputline[256];
     char *cp, *token, *restofline;
     boolean success;


     if ((gdcfile = fopen(filename, "r")) == (FILE *) NULL) {
	  printf("Cannot open file '%s'\n", filename);
	  exit(-1);
     }

     while (fgets(inputline, sizeof inputline, gdcfile)!= NULL) {
	  ZapCRLF(inputline);
	  
	  if (*inputline == '#' || *inputline == '\0') /** Ignore comments **/
	       continue;

	  cp = strchr(inputline, ':');
	  if (cp == NULL) {
	       fprintf(stderr, "Bad line '%s'\n", inputline);
	       exit(-1);
	  }
	  *cp = '\0';
	  token      = inputline;
	  restofline = cp+1;
	  while (*restofline == ' ' || *restofline == '\t')
	       restofline++;
	  
	  success = GDCtokens(gdc, token, restofline);
	  if (!success) {
	       fprintf(stderr, "Bad line '%s'\n", inputline);
	       exit(-1);
	  }
     }
     
     fclose(gdcfile);
}


boolean GDCCanSearch(gdc, hostname, ipnum)
  GDCobj *gdc;
  char *hostname, *ipnum;
{
     boolean test;

     if (DEBUG) printf("Testing %s/%s for access\n", hostname, ipnum);

     if (gdc->Securityon == FALSE)
	  return(TRUE);

     if ((test = SiteArrCanSearch(gdc->Sites, hostname, ipnum)) != ACC_UNKNOWN)
	  return(test);
     
     if ((gdc->Defaccess & ACC_SEARCH) == ACC_SEARCH)
	  return(TRUE);
     else
	  return(FALSE);

}

boolean GDCCanRead(gdc, hostname, ipnum)
  GDCobj *gdc;
  char *hostname, *ipnum;
{
     boolean test;

     if (DEBUG) printf("Testing %s/%s for access\n", hostname, ipnum);

     if (gdc->Securityon == FALSE)
	  return(TRUE);

     if ((test = SiteArrCanRead(gdc->Sites, hostname, ipnum)) != ACC_UNKNOWN)
	  return(test);
     
     if ((gdc->Defaccess & ACC_READ) == ACC_READ)
	  return(TRUE);
     else
	  return(FALSE);

}


boolean GDCCanBrowse(gdc, hostname, ipnum)
  GDCobj *gdc;
  char *hostname, *ipnum;
{
     boolean test;

     if (DEBUG) printf("Testing %s/%s for access\n", hostname, ipnum);

     if (gdc->Securityon == FALSE)
	  return(TRUE);

     if ((test = SiteArrCanBrowse(gdc->Sites, hostname, ipnum)) != ACC_UNKNOWN)
	  return(test);
     
     if ((gdc->Defaccess & ACC_BROWSE) == ACC_BROWSE)
	  return(TRUE);
     else
	  return(FALSE);

}


/** Is this file ignored? **/
boolean
GDCignore(gdc, filenm)
  GDCobj *gdc;
  char *filenm;
{
     char *gplustype, *prefix, objtype;

     ExtGet(gdc->Extensions, filenm, &objtype, &gplustype, &prefix);

     if (objtype == '3')
	  return(TRUE);
     else
	  return(FALSE);
}


boolean 
GDCExtension(gdc, ext, Gtype, Prefix)
  GDCobj *gdc;
  char *ext;
  char *Gtype;
  char **Prefix;
{
     char *gplustype;

     ExtGet(gdc->Extensions, ext, Gtype, &gplustype, Prefix);

     if (*Gtype != '\0')
	  return(TRUE);
     else
	  return(FALSE);
}
