/********************************************************************
 * $Author: lindner $
 * $Revision: 1.3 $
 * $Date: 1993/01/15 20:22:00 $
 * $Source: /home/mudhoney/GopherSrc/gopher1.11b/gopherd/RCS/gopherd.h,v $
 * $State: Rel $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: gopherd.h
 * Header file for gopher server.
 *********************************************************************
 * Revision History:
 * $Log: gopherd.h,v $
 * Revision 1.3  1993/01/15  20:22:00  lindner
 * Added Stdlib.h.  needed for atof()
 *
 * Revision 1.2  1993/01/11  19:20:47  lindner
 * Added signal.h
 *
 * Revision 1.1  1992/12/10  23:13:27  lindner
 * gopher 1.1 release
 *
 *
 *********************************************************************/


#include "conf.h"

#include <ctype.h>
#include <stdio.h>


#include <sys/types.h>
#include <Stdlib.h>

/*** Stuff for sockets****/
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#ifndef hpux
#include <arpa/inet.h>
#endif


#include <pwd.h>
#include <errno.h>

/** For logfile locking... **/
#if !defined(NeXT) && !defined(mips) && !defined(UMAX43) && !defined(sequent) && !defined(sony_news)
#  include <unistd.h>
#  include <fcntl.h>
#else
#  include <fcntl.h>
#  include <sys/file.h>
#  ifndef SEEK_END
#    define SEEK_END L_XTND
#    define SEEK_SET L_SET
#  endif
#endif

extern int errno;

#include "String.h"

#include <signal.h>
#include <sys/stat.h>
#include <time.h>

#include <sys/param.h>
/* This might be in <sys/param.h>, usually 64 */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN                (64)
#endif

#ifndef NOFILE
#define NOFILE (100)
#endif

#ifndef MAXPATHLEN
#define MAXPATHLEN (512)
#endif



#include "GDgopherdir.h"
#include "Dirent.h"

/*
 * Make sure we don't accidentally use a library routine instead of our
 * private restricted version.  Need to avoid the stat in struct stat
 * getting clobbered by the #define for the routine.
 */
typedef struct stat STATSTR;
#include "openers.h"
#define open	barf_ropen
#define fopen	barf_rfopen
#define stat	barf_rstat
#define opendir	barf_ropendir
#define chdir	barf_rchdir

#include "compatible.h"
#include "util.h"
#include "gopherdconf.h"

/*** This one must be last ***/
#include "globals.h"
