/********************************************************************
 * $Author: lindner $
 * $Revision: 1.1 $
 * $Date: 1992/12/10 23:13:27 $
 * $Source: /home/mudhoney/GopherSrc/release1.11/gopherd/RCS/globals.h,v $
 * $Status: $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: globals.h
 * Global variables for gopher server
 *********************************************************************
 * Revision History:
 * $Log: globals.h,v $
 * Revision 1.1  1992/12/10  23:13:27  lindner
 * gopher 1.1 release
 *
 *
 *********************************************************************/

/*
 * This is some funky defines that assures that global variables are
 * declared only once.  (when globals.c includes this file with EXTERN
 * defined.
 */

#ifndef EXTERN
#define EXTERN extern
#define INIT(x)
#else
#define EXTERN
#define INIT(x) = (x)
#endif

#include "boolean.h"

/**** Defines ****/
#define MAXLINE 512

/**** Globals.  ****/

EXTERN GDCobj    *Config;
EXTERN boolean   DEBUG INIT(FALSE);
EXTERN boolean   RunFromInetd INIT(FALSE);
EXTERN boolean   Caching INIT(TRUE);
EXTERN boolean   UsingHTML INIT(FALSE);
EXTERN int       LOGFileDesc INIT(-1);
EXTERN char      Data_Dir[256];
EXTERN char      *pname INIT(NULL);
EXTERN GopherDirObj *SortDir;

EXTERN int       dochroot INIT(TRUE);   /*** Should we use chroot?? ***/
EXTERN char      *Zehostname INIT(NULL);      /** Holds name and domain **/
EXTERN int       GopherPort INIT(GOPHER_PORT);
EXTERN char      *EXECargs INIT(NULL);   /** used with exec type **/
EXTERN boolean   MacIndex      INIT(FALSE);

/*** What's being run ***/
EXTERN boolean   RunLS         INIT(FALSE);
EXTERN boolean   RunServer     INIT(TRUE);  /** Run server as default **/
EXTERN boolean   RunIndex      INIT(FALSE); /** Index server (gindexd) **/

/*** Prototypes n' externals ****/

extern char *parse_input();
extern int do_command();
void intro_mesg(/* int */);
void listdir();
void printfile();
void echosound();
FILE *specialfile();
extern void LOGGopher();
char *fixfile();
char *mtm_basename(/* (char *) */);
/*** From index.c ***/
void NeXTIndexQuery();
void WaisIndexQuery();
void GrepIndexQuery();
void ShellIndexQuery();
/*** from serverutil.c ***/
void Abortoutput();
int is_mail_from_line();
/*** from ftp.c ***/
void TranslateResults();
void SendFtpQuery();
