/********************************************************************
 * $Author: lindner $
 * $Revision: 1.2 $
 * $Date: 1992/12/31 05:36:51 $
 * $Source: /home/mudhoney/GopherSrc/release1.11/gopher/RCS/subprocs.c,v $
 * $State: Rel $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: subprocs.c
 * procedures for dealing with child processes.
 *********************************************************************
 * Revision History:
 * $Log: subprocs.c,v $
 * Revision 1.2  1992/12/31  05:36:51  lindner
 * Mods for VMS
 *
 * Revision 1.1  1992/12/10  23:32:16  lindner
 * gopher 1.1 release
 *
 * Revision 1.1  1992/12/10  06:16:51  lindner
 * Initial revision
 *
 *
 *********************************************************************/

#ifdef VMS
void
sig_child()
{ }
setsighandler()
{ }

#else /* not VMS */
 

#include "gopher.h"

#include "Wait.h"

#if defined(SIGTSTP) && !defined(_CRAY)   /* True on a BSD system */
#include <sys/file.h>
#endif

#include <sys/ioctl.h>

/* A little signal handler that handles those damn zombies */


void
sig_child()
{
     /*
      * Use the wait3() system call with the WNOHANG option
      */

     int pid;

     Portawait status;

     while ( (pid = wait3(&status, WNOHANG|WUNTRACED, NULL)) > 0)
	  ;
}


#ifdef SIGCHLD
#ifndef SIGCLD
#  define SIGCLD SIGCHLD
#endif
#endif


setsighandler() 
{
          
#if defined(SIGTSTP) && !defined(_CRAY)
     signal(SIGCLD, sig_child);  /* BSD */
#else
     signal(SIGCLD, SIG_IGN);
#endif


}

#endif  /* not VMS */
