/********************************************************************
 * $Author: lindner $
 * $Revision: 1.8 $
 * $Date: 1993/01/12 21:16:44 $
 * $Source: /home/mudhoney/GopherSrc/gopher1.11a/gopher/RCS/gopherrc.c,v $
 * $State: Rel $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: gopherrc.c
 * Utilities to read and write the .gopherrc file 
 *********************************************************************
 * Revision History:
 * $Log: gopherrc.c,v $
 * Revision 1.8  1993/01/12  21:16:44  lindner
 * Fixed gopherrc for good!
 *
 * Revision 1.7  1993/01/09  02:53:55  lindner
 * Fixed spelling error on it's
 *
 * Revision 1.6  1993/01/09  02:31:09  lindner
 * Added #define to check for MAXPATHLEN
 *
 * Revision 1.5  1992/12/31  05:46:52  lindner
 * Merged 1.2.1.1 in main code sequence
 *
 * Revision 1.4  1992/12/15  16:54:38  lindner
 * Fixed typo in initial display message.  Also changed message
 * "Press any key to continue" to "Press RETURN to continue", since
 * we're not in raw() mode.
 *
 * Revision 1.3  1992/12/14  20:41:00  lindner
 * .gopherrc was being created with a random permissions mask.  Fixed it
 * Also made it so that gopherrc is created with mode 0644
 *
 * Revision 1.2.1.1  1992/12/31  05:42:26  lindner
 * VMS mods.
 *
 * Revision 1.2  1992/12/11  19:52:59  lindner
 * Added copyright notices when the users starts the client the first time.
 *
 * Revision 1.1  1992/12/10  23:32:16  lindner
 * gopher 1.1 release
 *
 * Revision 1.1  1992/12/10  06:16:51  lindner
 * Initial revision
 *
 *
 *********************************************************************/


#include "gopher.h"
#ifndef VMS
#include <fcntl.h>
#include <pwd.h>
#endif

#ifndef MAXPATHLEN
#define MAXPATHLEN 256
#endif


int
rcopen(flags) 
  int flags;
{
     char rcfilename[MAXPATHLEN];
     int rcfile;
#ifndef VMS
     struct passwd *pwdentry;
     
     pwdentry = getpwuid(geteuid());

     if (pwdentry == NULL)
	  return(-1);

     /** First, let's find out if there is a bookmark file **/

     strcpy(rcfilename,pwdentry->pw_dir);   /* Home directory */
     strcat(rcfilename,"/.gopherrc");

#else
     strcpy(rcfilename,"sys$login:gopherrc");
#endif  /* VMS */

     rcfile = open(rcfilename, flags,0644);

     return(rcfile);
}     

void
read_rc()
{
     int rcfile;
     char inputline[512];
#ifndef VMS
     struct passwd *pwdentry;

     pwdentry = getpwuid(geteuid());

     if (pwdentry == NULL)
	  return;
#endif
     rcfile = rcopen(O_RDONLY);

     if (rcfile < 0) {
	  /*** Make the .gopherrc file ***/
	  rcfile = rcopen(O_CREAT);
	  close(rcfile);
	  printf("Welcome to the wonderful world of Gopher!\n\n");
	  printf("Gopher has limitations on its use and comes without\n");
	  printf("a warranty.  Please refer to the file 'Copyright' included\n");
	  printf("in the distribution.\n\n");
	  printf("%s, Copyright 1991,1992 by the Regents\nof the University of Minnesota\n\n",VERSIONline);
	  printf("Press RETURN to continue\n");
	  while ('\n' != getchar())
	       ;
	  return;    /*** No such file ***/
     }

     while (readline(rcfile, inputline, sizeof(inputline))) {

	  if (*inputline == '#')
	       continue;

	  ZapCRLF(inputline);
	  if (strncasecmp(inputline, "bookmarks:", 9)==0) {
	      
	       if (BookmarkDir == NULL)
		    BookmarkDir = GDnew(32);
	       
	       GDfromLink(BookmarkDir, rcfile, "localhost", 70);
	       
	       GDsetTitle(BookmarkDir, "Bookmarks");
	  }
	  else if (strncasecmp(inputline, "Pagercmd: ", 10) == 0) {
	       STRset(PagerCommand, inputline+10);
	  }
	  else if (strncasecmp(inputline, "Printercmd: ", 12) == 0) {
	       STRset(PrinterCommand, inputline + 12);
	  }
	  else if (strncasecmp(inputline, "Telnetcmd: ", 11) == 0) {
	       STRset(TelnetCommand, inputline + 11);
	  }
	  else if (strncasecmp(inputline, "Mailcmd: ", 9) == 0) {
	       STRset(MailCommand, inputline + 9);
	  }
	  else if (strncasecmp(inputline, "Playcmd: ", 9) == 0) {
	       STRset(PlayCommand, inputline + 9);
	  }
	  else if (strncasecmp(inputline, "TN3270cmd: ", 11) == 0) {
	       STRset(TN3270Command, inputline + 11);
	  }
	  else if (strncasecmp(inputline, "MIMEcmd: ", 9) == 0) {
	       STRset(MIMECommand, inputline + 9);
	  }
	  else if (strncasecmp(inputline, "Imagecmd: ", 10) == 0) {
	       STRset(ImageCommand, inputline+10);
	  }

     }

     close(rcfile);
}

void
set_defs()
{
     STRset(PagerCommand, PAGER_COMMAND);
     STRset(MailCommand, MAIL_COMMAND);
     STRset(PrinterCommand, PRINTER_COMMAND);
     STRset(TelnetCommand, TELNET_COMMAND);
     STRset(PlayCommand, PLAY_COMMAND);
     STRset(TN3270Command, TN3270_COMMAND);
     STRset(MIMECommand, MIME_COMMAND);
     STRset(ImageCommand, IMAGE_COMMAND);
}     


void
read_env()
{
     /** Get the pager command **/
     
     if (getenv("PAGER") != NULL)
	  STRset(PagerCommand, getenv("PAGER"));

     if (getenv("EDITOR") == NULL)
	  STRset(EditorCommand, "vi ");
     else
	  STRset(EditorCommand, getenv("EDITOR"));
     
     if (getenv("GOPHER_MAIL") != NULL)
           STRset(MailCommand, getenv("GOPHER_MAIL"));

      if (getenv("GOPHER_PRINTER") != NULL)
           STRset(PrinterCommand, getenv("GOPHER_PRINTER"));

     if (getenv("GOPHER_TELNET") != NULL)
	  STRset(TelnetCommand, getenv("GOPHER_TELNET"));

     if (getenv("GOPHER_PLAY") != NULL)
	  STRset(PlayCommand, getenv("GOPHER_PLAY"));

     if (getenv("GOPHER_TN3270") != NULL)
	  STRset(TN3270Command, getenv("GOPHER_TN3270"));

     if (getenv("GOPHER_MIME") != NULL)
	  STRset(MIMECommand, getenv("GOPHER_MIME"));
     
     if (getenv("GOPHER_IMAGE") != NULL)
	  STRset(ImageCommand, getenv("GOPHER_IMAGE"));
}


void
write_rc()
{
     int rcfile;
     char rcfilename[512];
     char oldrcfilename[512];
#ifndef VMS
     struct passwd *pwdentry;

     pwdentry = getpwuid(geteuid());

     if (pwdentry == NULL)
	  return;
#endif /* not VMS */

     if (SecureMode)
	  return;

     /** First, let's find out if there is a rc file **/

#ifndef VMS
     strcpy(rcfilename,pwdentry->pw_dir);   /* Home directory */
     strcat(rcfilename,"/.gopherrc");
     strcpy(oldrcfilename,pwdentry->pw_dir); 
     strcat(oldrcfilename,"/.gopherrc~");

     rcfile = open(rcfilename, O_RDONLY);

     if (rcfile > -1)
	  if (rename(rcfilename, oldrcfilename)<0) {
	       CursesErrorMsg("Aborting gopher configuration save!!");
	       return;
	  }

     close(rcfile);

#else
     strcpy(rcfilename,"sys$login:gopherrc");
#endif
 
     rcfile = open(rcfilename, O_WRONLY|O_CREAT|O_TRUNC, 0644);

     if (rcfile < 0) {
#ifdef VMS
          fprintf(stderr,"Can't write gopher configuration file!!");
#else
	  CursesErrorMsg("Can't write gopher configuration file!!");
#endif
	  return;    
     }

     writestring(rcfile, "Pagercmd: ");
     writestring(rcfile, STRget(PagerCommand));
     writestring(rcfile, "\nPrintercmd: ");
     writestring(rcfile, STRget(PrinterCommand));
     writestring(rcfile, "\nTelnetcmd: ");
     writestring(rcfile, STRget(TelnetCommand));
     writestring(rcfile, "\nMailcmd: ");
     writestring(rcfile, STRget(MailCommand));
     writestring(rcfile, "\nPlaycmd: ");
     writestring(rcfile, STRget(PlayCommand));
     writestring(rcfile, "\nTN3270cmd: ");
     writestring(rcfile, STRget(TN3270Command));
     writestring(rcfile, "\nMIMEcmd: ");
     writestring(rcfile, STRget(MIMECommand));
     writestring(rcfile, "\nImagecmd: ");
     writestring(rcfile, STRget(ImageCommand));
     
     if (BookmarkDir != NULL) {
	  writestring(rcfile, "\nbookmarks:\n");
	  GDtoLink(BookmarkDir, rcfile);
     }

     writestring(rcfile, "\n");
     close(rcfile);
}

