/********************************************************************
 * $Author: lindner $
 * $Revision: 1.3 $
 * $Date: 1993/01/08 19:44:21 $
 * $Source: /home/mudhoney/GopherSrc/release1.11/gopher/RCS/globals.h,v $
 * $State: Exp $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: globals.h
 * Global variables and #defines
 *********************************************************************
 * Revision History:
 * $Log: globals.h,v $
 * Revision 1.3  1993/01/08  19:44:21  lindner
 * Updated version number
 *
 * Revision 1.2  1992/12/31  04:04:51  lindner
 * Changes for VMS
 *
 * Revision 1.1  1992/12/10  23:32:16  lindner
 * gopher 1.1 release
 *
 *********************************************************************/

#define MAXRESP      9                  /* Max size of a response list*/
#define WHOLELINE 80                   /* Used in ourutil.c */

/*
 * These are some funky defines that assures that global variables are
 * declared only once.  (when globals.c includes this file with EXTERN
 * defined.
 */

#ifndef EXTERN
#define EXTERN extern
#define INIT(x)
#else
#define EXTERN
#define INIT(x) =(x)
#endif

/*
 * We keep the version line stored here for easy access
 */
EXTERN char    *VERSIONline INIT("Internet Gopher Information Client v1.12S");

/*** Global variables ***/
EXTERN String    *PrinterCommand; /*used for configuration options */
EXTERN String    *PagerCommand;   
EXTERN String    *TelnetCommand;  
EXTERN String    *MailCommand;
EXTERN String    *PlayCommand;
EXTERN String    *EditorCommand;
EXTERN String    *TN3270Command;
EXTERN String    *MIMECommand;
EXTERN String    *ImageCommand;

EXTERN boolean   ChangedDefs INIT(FALSE);

EXTERN char      *Searchstring INIT(NULL);
EXTERN int       iLevel INIT(0);
EXTERN BOOLEAN   SecureMode INIT(FALSE);
EXTERN BOOLEAN   DEBUG INIT(FALSE);

EXTERN GopherDirObj *CurrentDir INIT(NULL);
EXTERN GopherDirObj *OldDirs[30];  /** Should be a stack... **/

EXTERN GopherDirObj *BookmarkDir INIT(NULL);

EXTERN char      USERCAP[WHOLELINE];    /* The validated user capability */
EXTERN int       SOUNDCHILD INIT(0);     /* The pid of the sound player child. */
EXTERN CursesObj *CursesScreen;

EXTERN char *Gopenfile INIT(NULL);

#ifndef VMS
extern int errno;
#endif

/*** Externals ***/

#ifndef VMS
extern char **environ;                  /* User environment array */
extern char *sys_errlist[];
#endif

/*** Prototypes and forward declarations ***/

/*** Ourutils.c ***/
void display_file(/* char *Filename */);
void ZapCRLF( /* char *buffer */ );
int  outchar( /*char c*/ );        
void CursesErrorMsg( /* char* */);
void GetOneOption(/* char*, char* */);

int  process_request(/* ZeGopher*/);
int  Load_Dir(/*ZeGopher*/);
int  Load_Index();
int  Load_Index_or_Dir();
void GetOneOption(/* */);
void check_sock(/* int, char* */);
