/********************************************************************
 * $Author: lindner $
 * $Revision: 1.4 $
 * $Date: 1993/01/14 21:59:30 $
 * $Source: /home/mudhoney/GopherSrc/gopher1.11b/gopher/RCS/download.c,v $
 * $State: Rel $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: download.c
 * Functions relating to downloading data
 *********************************************************************
 * Revision History:
 * $Log: download.c,v $
 * Revision 1.4  1993/01/14  21:59:30  lindner
 * Filenames generated for zmodem now are a bit better.. should work better
 * on VMS
 *
 * Revision 1.3  1993/01/12  20:42:04  lindner
 * Added <stat.h> stuff for VMS, also changed text download for VMS from
 * cat to type
 *
 * Revision 1.2  1993/01/11  19:26:56  lindner
 * Mods to make it work under VMS
 *
 * Revision 1.1  1993/01/07  22:47:20  lindner
 * Initial revision
 *
 *
 *********************************************************************/




#include "gopher.h"
#ifdef VMS
#include <stat.h>
#else
#include <sys/stat.h>
#endif

static char *DLnames[] = {
     "Zmodem",
     "Ymodem",
     "Xmodem-1K",
     "Xmodem-CRC",
     "Kermit",
     "Text",
     NULL
     };

static char *DLcmds[] = {
     "sz ",
     "sb ",
     "sx -k ",
     "sx ",
     "kermit -q -s ",
#ifdef VMS
     "type ",
#else
     "cat -v ",
#endif
     NULL
     };


void
Download_file(gs)
  GopherObj *gs;
{
     char   *titles[10];
     int    choice;
     char   tmpfilename[512], *cp;
     char   command[512];
     int    start, end;
     
     struct stat buf;

     switch (GSgetType(gs)) {
     case A_DIRECTORY:
     case A_CSO:
     case A_ERROR:
     case A_INDEX:
     case A_TELNET:
     case A_TN3270:
	  CursesErrorMsg("Sorry, can't download that!");
	  return;
     }

     choice = CURChoice(CursesScreen, GSgetTitle(gs), DLnames, 
			"Choose a download method");
     
     if (choice == -1)
	  return;
     
     
     /*** Get a reasonable tmp file name ***/
     cp = GSgetPath(gs);
     if ((cp = strrchr(cp,'/')) != NULL)
	  strcpy(tmpfilename, cp+1);
     else
	  strcpy(tmpfilename,GSgetTitle(gs));

#ifdef VMS
     VMSfile(tmpfilename);
#else
     UNIXfile(tmpfilename);
#endif

     for (cp=tmpfilename; *cp != '\0'; cp++) {
	  switch (*cp) {
	  case ' ':
	  case '\"':
	  case '\'':
	       *cp = '_';
	  }
     }

     /*** Retrieve the file ***/
     Save_file(gs, NULL, tmpfilename);

     /*** Check to see which method they're using to download ***/
     
     if (stat(tmpfilename, &buf) < 0) {
	  CursesErrorMsg("File didn't transfer successfully");
	  return;
     }

     /*** Now start the download ... ***/
     
     strcpy(command, DLcmds[choice]);
     strcat(command, tmpfilename);
     
     CURexit(CursesScreen);

     start = time(NULL);

     if (choice == 5) {
	  printf("Start your capture now...\n\n");
	  printf("Press <RETURN> when you're ready\n");
	  fflush(stdout);
	  getchar();
     } else {
	  printf("Start your download now...\n");
	  fflush(stdout);
     }
     system(command);
     end = time(NULL);
     if (end == start)
	  end++;
     

     printf("\nDownload Complete. %d total bytes, %d bytes/sec\n",
	    buf.st_size, buf.st_size/(end-start));

     printf("Press <RETURN> to continue");
     fflush(stdout);
     getchar();
     CURenter(CursesScreen);
     
     unlink(tmpfilename);

}
