/********************************************************************
 * $Author: lindner $
 * $Revision: 1.6 $
 * $Date: 1993/01/08 23:04:48 $
 * $Source: /home/mudhoney/GopherSrc/release1.11/RCS/conf.h,v $
 * $State: Rel $
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: conf.h
 * More configuration parameters.
 *********************************************************************
 * Revision History:
 * $Log: conf.h,v $
 * Revision 1.6  1993/01/08  23:04:48  lindner
 * Changed TN3270_COMMAND for Multinet
 *
 * Revision 1.5  1992/12/31  05:32:43  lindner
 * Added mods for VMS
 *
 * Revision 1.4  1992/12/22  21:45:26  lindner
 * Fixed bug with that zcat code I just added...
 *
 * Revision 1.3  1992/12/21  20:27:25  lindner
 * Added #ifdef to make zcat changable..
 *
 * Revision 1.2  1992/12/13  05:56:32  lindner
 * Added options for connection time-out code in the server (mtm)
 *
 * Revision 1.1  1992/12/11  19:01:58  lindner
 * Gopher1.1 Release
 *
 *********************************************************************/

/*
 * Defaults for the client program
 * On startup the client will contact either the gopher server
 * CLIENT1_HOST or CLIENT2_HOST randomly.
 *
 * Set CLIENT2_PORT to 0 if you only want one root machine
 */

#define CLIENT1_HOST "gopher.csc.fi"
#define CLIENT2_HOST "gopher.funet.fi"

#define CLIENT1_PORT 70
#define CLIENT2_PORT 0


/*
 * Override some defaults for various platforms
 */

#if defined(sun)
#define PLAY_COMMAND "play -v 40 -"
#endif

#if defined(NeXT)
#define NO_VPRINTF
#define PLAY_COMMAND "play -v 40 -"
#endif

#if defined(_SEQUENT_)
#define PRINTER_COMMAND "lp"
#endif

#if defined(VMS)
#  define PRINTER_COMMAND "print"
#  define PAGER_COMMAND   "type/page"
#  define PLAY_COMMAND    "- none -"
#  define GOPHERHELP      "sys_local:gopher.hlp"
#  if defined(MULTINET)
#     define TN3270_COMMAND        "telnet/tn3270"
#  endif
#endif



/*
 * Now set the parameters, only if not set above... 
 */
#ifndef PAGER_COMMAND
#define PAGER_COMMAND "more -d"
#endif

#ifndef MAIL_COMMAND
#define MAIL_COMMAND "/bin/mail"
#endif

#ifndef TELNET_COMMAND
#define TELNET_COMMAND "telnet"
#endif

#ifndef TN3270_COMMAND
#define TN3270_COMMAND "tn3270"
#endif

#ifndef PRINTER_COMMAND
#define PRINTER_COMMAND "lpr"
#endif

#ifndef PLAY_COMMAND
#define PLAY_COMMAND "/bin/false"
#endif

#ifndef MIME_COMMAND
#define MIME_COMMAND "metamail -P" 
#endif

#ifndef IMAGE_COMMAND 
#define IMAGE_COMMAND "xloadimage -fork"
#endif

/****************** gopherd configuration ***********************/

/*
 * This is the default time to cache directory entries on the server.
 */

#define CACHE_TIME 180  /** Default cache time of three minutes. **/


/*
 * The load average at which to restrict connections
 */

#define MAXLOAD 10.0

/*
 * Return type for signal()
 */

#define SIGRETTYPE void

/*
 * Timeout for network reads (5 minutes)
 */

#define READTIMEOUT (5 * 60)


#define LIST            "/tmp/gftp+"            /* Temp list file prefix */

/** Where the zcat command is...  **/
#if defined(M_XENIX)
#define ZCATCMD         "/usr/bin/zcat"
#else
#define ZCATCMD         "/usr/ucb/zcat"
#endif
