#ifndef lint
static char *RCSid = "$Header: /usr/src/ecn/getethers/RCS/vendors.c,v 1.2 92/05/08 14:16:03 davy Exp $";
#endif
/*
 * vendors.c - print ethernet vendor codes
 *
 * Peter Shipley
 * shipley@tfs.com
 *
 * More vendors added, code rearranged by D. Curry.
 *
 * $Log:	vendors.c,v $
 * Revision 1.2  92/05/08  14:16:03  davy
 * Made portable to 4.3BSD, from Peter Shipley (shipley@tfs.com).
 * 
 * Revision 1.1  92/05/08  13:06:39  davy
 * Initial revision
 * 
 */
#include <sys/param.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#if defined(sun) || defined(__convex__)
#  include <net/if_arp.h>
#endif
#include <netinet/if_ether.h>
#include <stdio.h>
#include "defs.h"

#define VENDOR_NUMS_MASK	0xFFFFFF00
#define VEN_MAX		(sizeof(Vendor_nums) / sizeof(struct _vendor_nums))

static struct _vendor_nums  {
    unsigned long addr;
    char *name;
} Vendor_nums[] = { 
    0x00000200, "BBN (internal)",
    0x00000C00, "Cisco Systems",
    0x00000E00, "Fujitsu",
    0x00000F00, "NeXT",
    0x00001000, "Hughes LAN Systems (Sytek)",
    0x00001100, "Tektronix",
    0x00001500, "Datapoint Corporation",
    0x00001800, "Webster (?)",
    0x00001B00, "Novell",
    0x00001D00, "Cabletron",
    0x00002000, "Data Industrier AB (DIAB)",
    0x00002100, "SC&C",
    0x00002200, "Visual Technology",
    0x00002900, "IMC",
    0x00002A00, "TRW",
    0x00003C00, "Auspex",
    0x00003D00, "AT&T",
    0x00004400, "Castelle",
    0x00004600, "ISC-Bunker Ramo (Olivetti)",
    0x00004900, "Apricot, Ltd.",
    0x00004B00, "APT AppleTalk WAN Router",
    0x00004F00, "Logicraft (386-Ware PC Emulator)",
    0x00005200, "ODS",
    0x00005500, "AT&T",
    0x00005A00, "Schneider&Koch/Syskonnect",
    0x00005D00, "RDE",
    0x00005E00, "US Dept. of Defense (IANA)",
    0x00006200, "Honeywell",
    0x00006500, "Network General",
    0x00006900, "Silicon Graphics (?)",
    0x00006B00, "MIPS",
    0x00006E00, "Artisoft, Inc.",
    0x00007700, "MIPS (?), Interphase (?)",
    0x00007900, "Net Ware (?)",
    0x00007A00, "Ardent",
    0x00007B00, "Research Machines",
    0x00007D00, "Harris (3M) (old)",
    0x00007F00, "Linotronic",
    0x00008000, "Imagen (?) Harris (3M) (new)?",
    0x00008100, "Synoptics",
    0x00008400, "Aquila (?), ADI Systems, Inc. (?)",
    0x00008600, "Gateway (?), Megahertz Corp. (?)",
    0x00008900, "Cayman Systems (Gatorbox)",
    0x00008E00, "Jupiter (?), Solbourne (?)",
    0x00009300, "Proteon",
    0x00009400, "Asante MAC",
    0x00009500, "Sony/Tektronix",
    0x00009700, "Epoch",
    0x00009800, "Cross Com",
    0x00009F00, "Ameristar Technology",
    0x0000A000, "Sanyo Electronics",
    0x0000A200, "Wellfleet",
    0x0000A300, "Network Application Technology",
    0x0000A400, "Acorn",
    0x0000A500, "Compatible Systems Corporation",
    0x0000A600, "Network General (internal)",
    0x0000A700, "Network Computing Devices (NCD) (X terminal)",
    0x0000A800, "Stratus Computer, Inc.",
    0x0000A900, "Network Systems Corp. (NSC)",
    0x0000AA00, "Xerox",
    0x0000AC00, "Apollo",
    0x0000AF00, "Nuclear Data",
    0x0000B000, "RAD Network Devices (RND)",
    0x0000B300, "CIMLinc",
    0x0000B500, "Datability",
    0x0000B700, "Dove Fastnet",
    0x0000BB00, "??? (AppleTalk?)",
    0x0000BC00, "Allen-Bradley",
    0x0000C000, "Standard Microsystems Corp. (SMC) (Western Digital)",
    0x0000C600, "HP Intelligent Networks Operation (Eon Systems)",
    0x0000C800, "Altos",
    0x0000C900, "Emulex (terminal server)",
    0x0000D000, "Develcon Electronics, Ltd.",
    0x0000D100, "Adaptec, Inc. (Nodem)",
    0x0000D700, "Dartmouth College (NED router)",
    0x0000D800, "3Com? Novell? (IBM PS/2)",
    0x0000DD00, "Gould",
    0x0000DE00, "Unigraph",
    0x0000E200, "Acer Counterpoint",
    0x0000E800, "Accton Technology Corporation",
    0x0000EE00, "Network Designers Limited (?)",
    0x0000EF00, "Alantec",
    0x0000F000, "Samsung",
    0x0000F300, "Gandalf",
    0x0000F400, "Allied Telesis, Inc.",
    0x0000F600, "Applied Microsystems Corp. (AMC)",
    0x0000FD00, "High Level Hardware (Orion, UK)",
    0x00010200, "BBN (internal)",
    0x00014300, "IEEE 802",
    0x00016300, "National Datacomm Corporation",
    0x00016800, "Wandel & Goltermann",
    0x0001C800, "Thomas Conrad Corp.",
    0x00170000, "Kabel",
    0x00402B00, "TriGem",
    0x0040C500, "Micom Communications Corp.",
    0x0040C800, "Milan Technology Corp.",
    0x00608C00, "3Com (1990 onwards)",
    0x00800F00, "Standard Microsystems Corp. (SMC)",
    0x00801000, "Commodore",
    0x00801700, "PFU",
    0x00801900, "Dayna COmmunications (Etherprint)",
    0x00801B00, "Kodiak Technology",
    0x00802100, "Newbridge Networks Corporation",
    0x00802900, "Microdyne Corporation",
    0x00802D00, "Xylogics (Annex server)",
    0x00802E00, "Plexcom, Inc.",
    0x00803400, "SMT-Goupil",
    0x00803500, "Technology Works",
    0x00805100, "ADC Fibermux",
    0x00805200, "Network Professor",
    0x00805C00, "Agilis (?)",
    0x00807C00, "FiberCom",
    0x00808700, "Okidata",
    0x00808C00, "Frontier Software Development",
    0x00809600, "Human Designed Systems (HDS) (X terminal)",
    0x0080A100, "Microtest",
    0x0080A300, "Lantronix",
    0x0080B200, "Network Equipment Technologies",
    0x0080C700, "Xircom, Inc.",
    0x0080C800, "D-Link, Solectek Pocket Adapters",
    0x0080D000, "Computer Products International",
    0x0080D300, "Shiva (Fastpath)",
    0x0080D400, "Chase Limited",
    0x0080D800, "Network Perihperals",
    0x0080F100, "Opus",
    0x00AA0000, "Intel",
    0x00B0D000, "Computer Products International",
    0x00DD0000, "Ungermann-Bass (IBM RT)",
    0x00DD0100, "Ungermann-Bass",
    0x00EFE500, "3Com (IBM Microchannel card)",
    0x02040600, "BBN (internal)",
    0x02070100, "MICOM/Interlan (UNIBUS/QBUS/Apollo/Cisco)",
    0x02606000, "3Com",
    0x02608600, "Satelcom MegaPac (UK)",
    0x02608C00, "3Com (IBM-PC/Imagen/Valid/Cisco/Macintosh)",
    0x02CF1F00, "CMC (Masscomp/Silicon Graphics)",
    0x02E6D300, "Bus-Tech, Inc. (IBM mainframes)",
    0x08000100, "Computer Vision",
    0x08000200, "3Com (Bridge)",
    0x08000300, "Advanced Computer Communications (ACC)",
    0x08000500, "Symbolics (LISP machine)",
    0x08000700, "Apple",
    0x08000800, "BBN",
    0x08000900, "Hewlett-Packard",
    0x08000A00, "Nestar Systems",
    0x08000B00, "Unisys",
    0x08000D00, "International Computers, Ltd. (ICL)",
    0x08000E00, "NCR/AT&T",
    0x08000F00, "Standard Microsystems Corporation (SMC)",
    0x08001000, "AT&T",
    0x08001100, "Tektronix",
    0x08001400, "Excelan (BBN Butterfly/Masscomp/Silicon Graphics)",
    0x08001700, "National Semiconductor (NSC)",
    0x08001A00, "Data General",
    0x08001B00, "Data General",
    0x08001E00, "Apollo",
    0x08001F00, "Sharp",
    0x08002000, "Sun",
    0x08002200, "NBI",
    0x08002300, "Matsushita Denso",
    0x08002500, "CDC",
    0x08002600, "Norsk Data",
    0x08002700, "PCS Computer Systems GmbH",
    0x08002800, "TI (Explorer)",
    0x08002B00, "Digital Equipment Corp.",
    0x08002E00, "Metaphor",
    0x08002F00, "Prime Computer (50-series LHC300)",
    0x08003600, "Intergraph",
    0x08003700, "Fujitsu-Xerox",
    0x08003800, "Bull",
    0x08003900, "Spider Systems",
    0x08003B00, "Torus Systems",
    0x08003E00, "Motorola (VME bus processor module)",
    0x08004100, "Digital Comm. Association (DCA)",
    0x08004400, "DAVID Systems, Inc. (DSI)",
    0x08004500, "Xylogics (?)",
    0x08004600, "Sony",
    0x08004700, "Sequent",
    0x08004900, "Univation",
    0x08004C00, "Encore",
    0x08004E00, "BICC",
    0x08005100, "Experdata",
    0x08005600, "Stanford University",
    0x08005700, "Evans & Sutherland (?)",
    0x08005800, "??? (DECsystem-20)",
    0x08005A00, "IBM",
    0x08005D00, "Gould",
    0x08006700, "Comdesign",
    0x08006800, "Ridge",
    0x08006900, "Silicon Graphics",
    0x08006A00, "ATTst (?)",
    0x08006E00, "Excelan",
    0x08007000, "Mitsubishi",
    0x08007400, "Casio",
    0x08007500, "Danish Data Elektronik A/S (DDE)",
    0x08007700, "TSL (Retix)",
    0x08007900, "Silicon Graphics",
    0x08007C00, "Vitalink TransLAN III",
    0x08008000, "XIOS",
    0x08008100, "Crosfield Electronics",
    0x08008300, "Seiko Denshi",
    0x08008600, "Imagen/QMS",
    0x08008700, "Xyplex",
    0x08008900, "Kinetics",
    0x08008B00, "Pyramid",
    0x08008D00, "XyVision",
    0x08008E00, "Tandem",
    0x08009000, "Retix",
};

char *
vendor_name(ea)
struct ether_addr *ea;
{
	int ether_num;
	int i;

	ether_num = 0;
	ether_num =
		(ea->ether_addr_octet[0] << 24 ) |
		(ea->ether_addr_octet[1] << 16 ) |
		(ea->ether_addr_octet[2] << 8 );

	/* I should install a binary search */
	for (i=0; i < VEN_MAX; i++) {
		if ((ether_num & VENDOR_NUMS_MASK) ==
		    (Vendor_nums[i].addr & VENDOR_NUMS_MASK)) {
			return(Vendor_nums[i].name);
		}
	}

	return("???");
}
