#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

static char    *test_addr[] =
{
    "128.214.46.0", "128.214.46",
    "128.214.0", "128.214",
    "127.214.46.0", "127.214.46",
    "127.214.0", "127.214",
    "128.214.46.5",
};

typedef union addr_union {
    struct in_addr  in_addr;	       /* ref. by in_addr.s_addr */
    unsigned long   address;
    unsigned char   addr[4];
}

addr_union;

main ()
{
    addr_union      iaddr,
                    naddr,
		    faddr;
    int		    net,
                    lna;
    register int    i;

    for (i = 0; i < sizeof (test_addr) / sizeof (char *); i++) {

	printf ("%s:\n", test_addr[i]);

	iaddr.address = inet_addr (test_addr[i]);

	printf ("\tinet_addr: 0x%08lx = %d.%d.%d.%d\n",
		iaddr.address,
		(int) iaddr.addr[0], (int) iaddr.addr[1],
		(int) iaddr.addr[2], (int) iaddr.addr[3]);

	naddr.address = inet_network (test_addr[i]);

	printf ("\tinet_network: 0x%08lx = %d.%d.%d.%d\n",
		naddr.address,
		(int) naddr.addr[0], (int) naddr.addr[1],
		(int) naddr.addr[2], (int) naddr.addr[3]);

	printf ("\tinet_ntoa: %s (iaddr)  %s (naddr)\n",
		inet_ntoa (iaddr.in_addr),
		inet_ntoa (naddr.in_addr));

	lna = inet_lnaof (iaddr.in_addr);
	printf ("\tinet_lnaof: 0x%08lx\n", (unsigned long) lna);

	net = inet_netof (iaddr.in_addr);
	printf ("\tinet_netof: 0x%08lx\n", (unsigned long) net);

	faddr.in_addr = inet_makeaddr (net, lna);
	printf ("\tinet_makeaddr: 0x%08lx %d.%d.%d.%d\n\n",
		faddr.address,
		(int) faddr.addr[0], (int) faddr.addr[1],
		(int) faddr.addr[2], (int) faddr.addr[3]);
    }
}
