/*
 * machine generated cmd line parser
 */

#include <ctype.h>
#include <stdio.h>
#include "calls.h"

#define ENVOPT 0
#define GETARG 1
#define GETOPT 1
/* @(#)getopt.i  -- literal text included from a tempate
 * based on Keith Bostic's getopt in comp.sources.unix volume1
 * modified for mkcmd use.... by ksb@cc.purdue.edu (Kevin Braunsdorf)
 */

#if GETOPT || GETARG
static int
	optind = 1;		/* index into parent argv vector	*/
static char
	*optarg;		/* argument associated with option	*/
#endif /* only if we use them */

#if ENVOPT
/* breakargs - break a string into a string vector for execv.
 *
 * Note, when done with the vector, mearly "free" the vector.
 * Written by Stephen Uitti, PUCC, Nov '85 for the new version
 * of "popen" - "nshpopen", that doesn't use a shell.
 * (used here for the as filters, a newer option).
 *
 * breakargs is copyright (C) Purdue University, 1985
 *
 * Permission is hereby given for its free reproduction and
 * modification for All purposes.
 * This notice and all embedded copyright notices be retained.
 */

/* this trys to emulate shell quoting, but I doubt it does a good job	(ksb)
 * [[ but not substitution -- that would be silly ]]
 */
static char *
mynext(pch)
register char *pch;
{
	register int fQuote;

	for (fQuote = 0; (*pch != '\000' && *pch != ' ' && *pch != '\t')||fQuote; ++pch) {
		if ('\\' == *pch) {
			continue;
		}
		switch (fQuote) {
		default:
		case 0:
			if ('"' == *pch) {
				fQuote = 1;
			} else if ('\'' == *pch) {
				fQuote = 2;
			}
			break;
		case 1:
			if ('"' == *pch)
				fQuote = 0;
			break;
		case 2:
			if ('\'' == *pch)
				fQuote = 0;
			break;
		}
	}
	return pch;
}

/* given an envirionment variable insert it in the option list		(ksb)
 * (exploded with the above routine)
 */
static int
envopt(cmd, pargc, pargv)
char *cmd, *(**pargv);
int *pargc;
{
	register char *p;		/* tmp				*/
	register char **v;		/* vector of commands returned	*/
	register unsigned sum;		/* bytes for malloc		*/
	register int i, j;		/* number of args		*/
	register char *s;		/* save old position		*/
	register char hold;		/* hold a character for a second*/
	extern char *malloc();
#ifndef AIX
	extern char *strcpy();
#endif

	while (*cmd == ' ' || *cmd == '\t')
		cmd++;
	p = cmd;			/* no leading spaces		*/
	i = 1 + *pargc;
	sum = sizeof(char *) * i;
	while (*p != '\000') {		/* space for argv[];		*/
		++i;
		s = p;
		p = mynext(p);
		sum += sizeof(char *) + 1 + (unsigned)(p - s);
		while (*p == ' ' || *p == '\t')
			p++;
	}
	++i;
	/* vector starts at v, copy of string follows NULL pointer
         * the extra 7 bytes on the end allow use to be alligned
         */
        v = (char **)malloc(sum+sizeof(char *)+7);
	if (v == NULL)
		return 0;
	p = (char *)v + i * sizeof(char *); /* after NULL pointer */
	i = 0;				/* word count, vector index */
	v[i++] = (*pargv)[0];
	while (*cmd != '\000') {
		v[i++] = p;
		s = cmd;
		cmd = mynext(cmd);
		hold = *cmd;
		*cmd = '\000';
		(void)strcpy(p, s);
		p += strlen(p)+1;
		if ('\000' != hold)
			*cmd++ = hold;
		while (*cmd == ' ' || *cmd == '\t')
			++cmd;
	}
	for (j = 1; j < *pargc; ++j)
		v[i++] = (*pargv)[j];
	v[i] = (char *)NULL;
	*pargv = v;
	*pargc = i;
	return i;
}
#endif /* envopt called */

#if GETARG
/*
 * return each non-option argument one at a time, EOF for end of list
 */
static int
getarg(nargc, nargv)
int nargc;
char **nargv;
{
	if (nargc <= optind) {
		optarg = (char *) 0;
		return EOF;
	}
	optarg = nargv[optind++];
	return 0;
}
#endif /* getarg called */


#if GETOPT
static int
	optopt;			/* character checked for validity	*/

/* get option letter from argument vector, also does -number correctly
 * for nice, xargs, and stuff (these extras by ksb)
 */
static int
getopt(nargc, nargv, ostr)
int nargc;
char **nargv, *ostr;
{
	extern char	*strchr();
	register char	*oli;		/* option letter list index	*/
	static char	EMSG[] = "";	/* just a null place		*/
	static char	*place = EMSG;	/* option letter processing	*/

	if ('\000' == *place) {		/* update scanning pointer */
		if (optind >= nargc || nargv[optind][0] != '-')
			return EOF;
		place = nargv[optind];
		if ('\000' == *++place)	/* "-" (stdin)		*/
			return EOF;
		if (*place == '-' && '\000' == place[1]) {
			/* found "--"		*/
			++optind;
			return EOF;
		}
	}				/* option letter okay? */
	/* if we find the letter, (not a `:')
	 * or a digit to match a # in the list
	 */
	if ((optopt = *place++) == ':' ||
	 ((char *)0 == (oli = strchr(ostr,optopt)) &&
	  (!(isdigit(optopt)||'-'==optopt) || (char *)0 == (oli = strchr(ostr, '#'))))) {
		if(!*place) ++optind;
		return('?');
	}
	if ('#' == *oli) {		/* accept as -digits */
		optarg = place -1;
		++optind;
		place = EMSG;
		return '#';
	}
	if (*++oli != ':') {		/* don't need argument */
		optarg = NULL;
		if (!*place)
			++optind;
	} else {				/* need an argument */
		if (*place) {			/* no white space */
			optarg = place;
		} else if (nargc <= ++optind) {	/* no arg */
			place = EMSG;
			return('*');
		} else {
			optarg = nargv[optind];	/* white space */
		}
		place = EMSG;
		++optind;
	}
	return optopt;			/* dump back option letter */
}
#endif /* getopt called */
#undef ENVOPT
#undef GETARG
#undef GETOPT

char
	*pcProg = "$Id$",
#ifndef acUsage
#define acUsage	(aacUsage[0])
#endif
	*aacUsage[] = {
		" [-TVaeiortvx] [-D define] [-F func/file] [-I directory] [-U undefine] [-f func] [-l levels] [-w width] [files]",
		" -h",
		(char *)0
	},
	*apcHelp[] = {
		"D define    as in cpp, set initial definition",
		"F func/file trace from static function in the given C source file",
		"I directory as in cpp, search given include directory",
		"T           output a graph which is useful as input to tsort",
		"U undefine  as in cpp, remove initial definition",
		"V           look for referenced variables also",
		"a           print all calls in every function body",
		"e           index external functions too",
		"f func      start calling trace from given function",
		"h           print this help message",
		"i           print an index of defined functions",
		"l levels    limit the levels of calling graph displayed",
		"o           list only called functions in index output",
		"r           reverse the called/caller relation in the output",
		"t           terse, list only trees that are requested",
		"v           be verbose in output graph",
		"w width     set output width",
		"x           do not show external function in graph",
		"files       files to construct graph from",
		(char *)0
	},
	acCppCmd[1024] = "/lib/cpp ";
int 
	bTsort = 0,
	fLookFor = LOOK_FUNCS,
	bAll = 0,
	bExtern = 0,
	bIndex = 0,
	iLevels = 8,
	bOnly = 0,
	bReverse = 0,
	bTerse = 0,
	bVerbose = 0,
	iWidth = PAPERWIDTH,
	bHideExt = 0;

/* from std_help.m */
/* from calls.m */

static char *rcsid =
	"$Id: calls.m,v 3.7 92/06/05 08:28:55 ksb Exp $";

/*
 * parser
 */
int
options(argc, argv)
int argc;
char **argv;
{
	static char
		sbOpt[] = "D:F:I:TU:Vaef:hil:ortvw:x",
		*pcSplit = (char *)0,
		acTemp[1024] = "",
		*u_pch = (char *)0;
	static int 
		u_loop = 0;
	register int u_curopt;
	extern char *strncpy();
	extern int atoi();
	extern char *strrchr();

	pcProg = strrchr(argv[0], '/');
	if ((char *)0 == pcProg)
		pcProg = argv[0];
	else
		++pcProg;
	while (EOF != (u_curopt = getopt(argc, argv, sbOpt))) {
		switch (u_curopt) {
		case '*':
			fprintf(stderr, "%s: option `%c\' needs a parameter\n", pcProg, optopt);
			exit(1);
		case '?':
			fprintf(stderr, "%s: unknown option `%c\', use -h for help\n", pcProg, optopt);
			exit(1);
		case 'D':
			(void)sprintf(acTemp, "-D%s ", optarg);
			(void)strcat(acCppCmd, acTemp);
			continue;
		case 'F':
			if (0 != (pcSplit = strchr(optarg, '/'))) {
				*pcSplit++ = '\000';
			}
			else {
				pcSplit = acCmd;
			}
			AddFunc(optarg, 1, pcSplit);
			continue;
		case 'I':
			(void)sprintf(acTemp, "-I%s ", optarg);
			(void)strcat(acCppCmd, acTemp);
			continue;
		case 'T':
			bTsort = ! 0;
			continue;
		case 'U':
			(void)sprintf(acTemp, "-U%s ", optarg);
			(void)strcat(acCppCmd, acTemp);
			continue;
		case 'V':
			fLookFor = LOOK_VARS;
			continue;
		case 'a':
			bAll = ! 0;
			continue;
		case 'e':
			bExtern = !0;
			bIndex = 1;
			continue;
		case 'f':
			AddFunc(optarg, 0, acCmd);
			continue;
		case 'h':
			for (u_loop = 0; (char *)0 != (u_pch = aacUsage[u_loop]); ++u_loop) {
				fprintf(stdout, "%s: usage%s\n", pcProg, u_pch);
			}
			for (u_loop = 0; (char *)0 != (u_pch = apcHelp[u_loop]); ++u_loop) {
				fprintf(stdout, "%s\n", u_pch);
			}
			exit(0);
		case 'i':
			bIndex = ! 0;
			continue;
		case 'l':
			iLevels = atoi(optarg);
			continue;
		case 'o':
			bOnly = !0;
			bIndex = 1;
			continue;
		case 'r':
			bReverse = ! 0;
			continue;
		case 't':
			bTerse = ! 0;
			continue;
		case 'v':
			bVerbose = ! 0;
			continue;
		case 'w':
			iWidth = atoi(optarg);
			continue;
		case 'x':
			bHideExt = ! 0;
			continue;
		}
		break;
	}

	u_curopt = 1;
	
	while (EOF != getarg(argc, argv)) {
		u_curopt = 0;
		if ('-' == optarg[0] && '\000' == optarg[1]) {
			Dostdin();
		}
		else {
			Process(optarg, optarg);
		}
	}
	if (u_curopt) {
		if (fLookFor) {
			printf("%s: %s\n", pcProg, rcsid);
		}
	}
	return 0;
}
