*** orig/Makefile	Wed May  4 13:07:48 1994
--- csc/Makefile	Mon May  9 15:43:48 1994
***************
*** 1,7 ****
  #
  # bootpd   - BOOTP server daemon
  #
! # $Header: /afs/andrew.cmu.edu/netdev/src/cmu/bootp-public/RCS/Makefile,v 1.1 1991/10/31 19:15:12 ww0n Exp ww0n $
  #
  
  # The next few lines may be uncommented and changed to alter the default
--- 1,7 ----
  #
  # bootpd   - BOOTP server daemon
  #
! # $Header: Makefile,v 1.1 1991/10/31 19:15:12 Exp ww0n $
  #
  
  # The next few lines may be uncommented and changed to alter the default
***************
*** 8,32 ****
  # filenames bootpd uses for its configuration and dump files.
  #CONFFILE=-DCONFIG_FILE=\"/usr/etc/bootptab\"
  #DUMPFILE=-DDUMP_FILE=\"/usr/etc/bootpd.dump\"
- #FILESPECS=${CONFFILE} ${DUMPFILE}
  
! # Users of SunOS 4.0 and later must add -DSUNOS40 to BOOTPDOPT below.
  # Remove the -DVEND_CMU if you don't wish to support the "CMU vendor format"
  # in addition to the RFC1048 format.
  
! BOOTPDOPT=-DSYSLOG -DDEBUG -DVEND_CMU ${FILESPECS}
  
! INSTALL=/usr/bin/install
! DESTDIR=
! ETCDIR=/etc
! OBJS=bootpd.o readfile.o hash.o
! CFLAGS=${BOOTPDOPT}
  
! all: bootpd
  
! bootpd:	${OBJS} Version.c
  	sh newvers.sh Version.c
! 	${CC} ${CFLAGS} -o bootpd version.c ${OBJS}
  
  bootpd.o: bootpd.c bootpd.h bootp.h
  readfile.o: readfile.c bootpd.h bootp.h
--- 8,60 ----
  # filenames bootpd uses for its configuration and dump files.
  #CONFFILE=-DCONFIG_FILE=\"/usr/etc/bootptab\"
  #DUMPFILE=-DDUMP_FILE=\"/usr/etc/bootpd.dump\"
  
! CONFFILE=-DCONFIG_FILE=\"/etc/bootptab\"
! DUMPFILE=-DBOOTPD_DUMP_FILE=\"/usr/tmp/bootpd.dump\"
! FILESPECS=${CONFFILE} ${DUMPFILE}
! 
! # Users of SunOS 4.0 may have to add -DSUNOS40 to BOOTPDOPT below.
! # For SunOS 4.1.x use SUNOS41.
! #
  # Remove the -DVEND_CMU if you don't wish to support the "CMU vendor format"
  # in addition to the RFC1048 format.
  
! BOOTPDOPT=-DSYSLOG -DDEBUG -DVEND_CMU -DPRIVATE=static ${FILESPECS}
  
! LIBS	= -lresolv+
! INSTALL	= /usr/bin/install
! DESTDIR	= /usr/local
! ETCDIR	= /etc
! OBJS	= bootpd.o readfile.o hash.o
! CFLAGS	= -g -O2 ${BOOTPDOPT} -fpcc-struct-return -fno-builtin -funsigned-char $(XFLAGS)
! CC	= gcc
  
! all:
! 	@echo "usage: make sunos|convex|hpux|alpha|ultrix|aix|other"
  
! convex:
! 	make bootpd
! 
! sunos:
! 	make bootpd CC=cc XFLAGS=-DSUNOS40
! 
! hpux:
! 	make bootpd CC=cc XFLAGS=-Dhpux
! 
! alpha:
! 	make bootpd CC=cc
! 
! ultrix:
! 	make bootpd CC=cc
! 
! aix:
! 	make bootpd CC=cc
! 
! other: bootpd
! 
! bootpd:	${OBJS}
  	sh newvers.sh Version.c
! 	${CC} ${CFLAGS} -o $@ version.c ${OBJS} $(LIBS)
  
  bootpd.o: bootpd.c bootpd.h bootp.h
  readfile.o: readfile.c bootpd.h bootp.h
***************
*** 35,41 ****
  system: install
  
  install: all
! 	${INSTALL} -c -s bootpd ${DESTDIR}${ETCDIR}/bootpd
  
  clean:
  	@rm -f core bootpd *.BAK *.CKP *~ .emacs* *.o version.c
--- 63,69 ----
  system: install
  
  install: all
! 	${INSTALL} -c -s -m 0711 bootpd ${DESTDIR}${ETCDIR}/bootpd
  
  clean:
  	@rm -f core bootpd *.BAK *.CKP *~ .emacs* *.o version.c
No differences encountered
No differences encountered
No differences encountered
No differences encountered
No differences encountered
*** orig/bootp.h	Wed May  4 13:07:48 1994
--- csc/bootp.h	Wed May  4 13:14:51 1994
***************
*** 42,62 ****
  #define BP_VEND_LEN	 64
  
  struct bootp {
!     unsigned char    bp_op;			/* packet opcode type */
!     unsigned char    bp_htype;			/* hardware addr type */
!     unsigned char    bp_hlen;			/* hardware addr length */
!     unsigned char    bp_hops;			/* gateway hops */
!     unsigned long    bp_xid;			/* transaction ID */
      unsigned short   bp_secs;			/* seconds since boot began */
      unsigned short   bp_unused;
!     struct in_addr   bp_ciaddr;			/* client IP address */
!     struct in_addr   bp_yiaddr;			/* 'your' IP address */
!     struct in_addr   bp_siaddr;			/* server IP address */
!     struct in_addr   bp_giaddr;			/* gateway IP address */
!     unsigned char    bp_chaddr[BP_CHADDR_LEN];	/* client hardware address */
!     unsigned char    bp_sname[BP_SNAME_LEN];	/* server host name */
!     unsigned char    bp_file[BP_FILE_LEN];	/* boot file name */
!     unsigned char    bp_vend[BP_VEND_LEN];	/* vendor-specific area */
  };
  
  /*
--- 42,62 ----
  #define BP_VEND_LEN	 64
  
  struct bootp {
!     unsigned char    bp_op;			/* packet opcode type	    */
!     unsigned char    bp_htype;			/* hardware addr type	    */
!     unsigned char    bp_hlen;			/* hardware addr length	    */
!     unsigned char    bp_hops;			/* gateway hops		    */
!     unsigned int     bp_xid;			/* transaction ID	    */
      unsigned short   bp_secs;			/* seconds since boot began */
      unsigned short   bp_unused;
!     struct in_addr   bp_ciaddr;			/* client IP address	    */
!     struct in_addr   bp_yiaddr;			/* 'your' IP address	    */
!     struct in_addr   bp_siaddr;			/* server IP address	    */
!     struct in_addr   bp_giaddr;			/* gateway IP address	    */
!     unsigned char    bp_chaddr[BP_CHADDR_LEN];	/* client hardware address  */
!     unsigned char    bp_sname[BP_SNAME_LEN];	/* server host name	    */
!     unsigned char    bp_file[BP_FILE_LEN];	/* boot file name	    */
!     unsigned char    bp_vend[BP_VEND_LEN];	/* vendor-specific area	    */
  };
  
  /*
*** orig/bootpd.8	Wed May  4 13:07:49 1994
--- csc/bootpd.8	Tue May 10 16:39:47 1994
***************
*** 2,8 ****
  .\"
  .\"	$Header: /afs/andrew.cmu.edu/netdev/src/cmu/bootp-public/RCS/bootpd.8,v 1.1 1991/10/31 19:15:12 ww0n Exp ww0n $
  .\"
! .TH BOOTPD 8 "November 11, 1991" "Carnegie Mellon University"
  .UC 6
  
  .SH NAME
--- 2,9 ----
  .\"
  .\"	$Header: /afs/andrew.cmu.edu/netdev/src/cmu/bootp-public/RCS/bootpd.8,v 1.1 1991/10/31 19:15:12 ww0n Exp ww0n $
  .\"
! .\".TH BOOTPD 8 "November 11, 1991" "Carnegie Mellon University"
! .TH BOOTPD 8 "May 10, 1994" "Centre for Scientific Computing"
  .UC 6
  
  .SH NAME
***************
*** 10,15 ****
--- 11,18 ----
  .SH SYNOPSIS
  .B /etc/bootpd
  [
+ .B \-f
+ .B \-h
  .B \-i
  .B \-s
  .B \-t
***************
*** 88,94 ****
--- 91,117 ----
  .IR bootpd ,
  omitting the numeric parameter (i.e. just -d) will
  simply increment the debug level by one.
+ 
  .PP
+ The
+ .B \-f
+ flag tells
+ .I bootpd
+ to flush all but the last query in the queue before replying to the last one.
+ The last query in the queue has the longest time left before timeout and it
+ is the most likely to be replied in time to avoid the query being resent
+ after a moment. This is sometimes beneficial if there is a chance of huge
+ bursts of almost simultaneous queries being sent from many clients.
+ 
+ .PP
+ The
+ .B \-h
+ flag forces queries being matched and replies being sent always based on
+ the clients' hardware addresses to allow e.g. new IP addresses being
+ delivered correctly to clients when you move them from one network to
+ another etc.
+ 
+ .PP
  Upon startup,
  .I bootpd
  first reads its configuration file,
***************
*** 156,161 ****
--- 179,211 ----
  Added TFTP directory- and server-specification features.  Added automatic
  detection of inetd/standalone mode, making -s switch no longer necessary.
  Other minor improvements and bug fixes.
+ 
+ .TP
+ 30-Sep-1993 Kai Vorma, Helsinki University of Technology
+ .br
+ Added a flag to force queries being matched based on the hardware address
+ independent of whether an IP address is specified in the query.
+ .br
+ Added a flag to flush the queries in the queue before replying to only
+ the last query in the queue. This is sometimes very useful when there is
+ an overwhelming burst of queries flowing in.
+ .br
+ Added a simple version of finding an IP address based
+ on a hostname in any of the fields where IP addresses
+ are used.
+ 
+ .TP
+ 4-May-1994 Jukka A. Ukkonen, Centre for Scientific Computing
+ .br
+ Added feature to forcibly fetch IP-addresses from the DNS.
+ This includes also the possibility to inherit an \fBip\fP-field with
+ a value INADDR_ANY from another bootptab entry.
+ .br
+ Modified some details in Kai Vorma's implementation of
+ using hostnames in the IP-address fields and generalized
+ the parsing mechanism used for Internet addresses.
+ .br
+ Some modifications for better compatibility with the C & POSIX standards.
  
  .SH "SEE ALSO"
  .br
*** orig/bootpd.c	Wed May  4 13:07:49 1994
--- csc/bootpd.c	Tue May 10 13:59:15 1994
***************
*** 25,32 ****
  
  
  #ifndef lint
! static char sccsid[] = "@(#)bootp.c	1.1 (Stanford) 1/22/86";
! static char rcsid[] = "$Header: /afs/andrew.cmu.edu/netdev/src/cmu/bootp-public/RCS/bootpd.c,v 1.3 1991/11/01 10:02:29 ww0n Exp ww0n $";
  #endif
  
  
--- 25,32 ----
  
  
  #ifndef lint
!   static char sccsid[] = "@(#)bootp.c	1.1 (Stanford) 1/22/86";
!   static char rcsid[] = "$Header: bootpd.c,v 1.3 1991/11/01 10:02:29 Exp ww0n $";
  #endif
  
  
***************
*** 34,44 ****
   * BOOTP (bootstrap protocol) server daemon.
   *
   * Answers BOOTP request packets from booting client machines.
!  * See [SRI-NIC]<RFC>RFC951.TXT for a description of the protocol.
!  * See [SRI-NIC]<RFC>RFC1048.TXT for vendor-information extensions.
!  * See accompanying man page -- bootpd.8
   *
   *
   * HISTORY
   *
   * 01/22/86	Bill Croft at Stanford University
--- 34,50 ----
   * BOOTP (bootstrap protocol) server daemon.
   *
   * Answers BOOTP request packets from booting client machines.
!  *  See RFC-951 for a description of the protocol.
!  *	+ ftp from [SRI-NIC]<RFC>RFC951.TXT
!  *  See RFC-1048 for vendor-information extensions.
!  *	+ ftp from [SRI-NIC]<RFC>RFC1048.TXT
!  *  See RFC-1533 for DHCP Options and BOOTP Vendor Extensions.
!  *  See RFC-1534 for Interoperability Between DHCP and BOOTP.
   *
+  *  See RFC-XXXX for Functional Enhancements to bootpd.
+  *  See also the accompanying man page -- bootpd.8
   *
+  *
   * HISTORY
   *
   * 01/22/86	Bill Croft at Stanford University
***************
*** 57,63 ****
--- 63,91 ----
   *		    Added hash table lookup instead of linear search.
   *		    Other cleanups.
   *
+  * 09/30/93     Kai Vorma at Helsinki University of Technology
+  *		- Added a flag to force queries being matched based on the
+  *		  hardware address independent of whether an IP address
+  *		  is specified in the query.
+  *		- Added a flag to flush the queries in the queue before
+  *		  replying to only the last query in the queue. This is
+  *		  sometimes very useful when there is an overwhelming
+  *		  burst of queries flowing in.
+  *		- Added a simplified version of finding an IP address
+  *		  based on a hostname in any of the fields where IP addresses
+  *		  are used.
   *
+  * 4-May-1994	Jukka A. Ukkonen, Centre for Scientific Computing
+  *		- Added feature to forcibly fetch IP-addresses from the DNS.
+  *		  This includes also the possibility to inherit an ip-field
+  *		  with a value INADDR_ANY from another bootptab entry.
+  *		- Modified some details in Kai Vorma's implementation of
+  *		  using hostnames in the IP-address fields and generalized
+  *		  the parsing mechanism used for Internet names and addresses.
+  *		- Some modifications for better compatibility with the
+  *		  C & POSIX standards.
+  *		- Ported to SunOS 4.1.3 and ConvexOS 10.2.
+  *
   * BUGS
   *
   * Currently mallocs memory in a very haphazard manner.  As such, most of
***************
*** 64,74 ****
   * the program ends up core-resident all the time just to follow all the
   * stupid pointers around. . . .
   *
   */
- 
  
- 
- 
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <sys/ioctl.h>
--- 92,100 ----
   * the program ends up core-resident all the time just to follow all the
   * stupid pointers around. . . .
   *
+  *  A Corollary: "But that's just what makes it fast!"
   */
  
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <sys/ioctl.h>
***************
*** 76,99 ****
  #include <sys/time.h>
  #include <sys/stat.h>
  #include <net/if.h>
! #ifdef SUNOS40
! #include <sys/sockio.h>
! #include <net/if_arp.h>
  #endif
  #include <netinet/in.h>
  #include <signal.h>
  #include <stdio.h>
! #include <strings.h>
  #include <errno.h>
  #include <ctype.h>
  #include <netdb.h>
  #ifdef SYSLOG
  #include <syslog.h>
  #endif
  #include "bootp.h"
  #include "hash.h"
  #include "bootpd.h"
  
  #define HASHTABLESIZE		257	/* Hash table size (prime) */
  #define DEFAULT_TIMEOUT		 15L	/* Default timeout in minutes */
  
--- 102,149 ----
  #include <sys/time.h>
  #include <sys/stat.h>
  #include <net/if.h>
! 
! #if defined(SUNOS40) || defined(SUNOS41)
! #  include <sys/sockio.h>
! #  include <net/if_arp.h>
  #endif
+ 
+ #if defined(__convex__)
+ #  include <net/if_arp.h>
+ #endif
+ 
  #include <netinet/in.h>
  #include <signal.h>
  #include <stdio.h>
! 
! #ifdef	__STDC__
! #  include <string.h>
! #else
! #  include <strings.h>
! #endif
! 
  #include <errno.h>
  #include <ctype.h>
  #include <netdb.h>
+ 
+ #ifdef _AIX
+ #  include <sys/select.h>
+ #endif
+ 
  #ifdef SYSLOG
  #include <syslog.h>
  #endif
+ 
  #include "bootp.h"
  #include "hash.h"
  #include "bootpd.h"
  
+ #ifdef	__STDC__
+ #  include <stdarg.h>
+ #else
+ #  include <varargs.h>
+ #endif
+ 
  #define HASHTABLESIZE		257	/* Hash table size (prime) */
  #define DEFAULT_TIMEOUT		 15L	/* Default timeout in minutes */
  
***************
*** 100,109 ****
  #ifndef CONFIG_FILE
  #define CONFIG_FILE		"/etc/bootptab"
  #endif
! #ifndef DUMP_FILE
! #define DUMP_FILE		"/etc/bootpd.dump"
  #endif
  
  
  
  /*
--- 150,163 ----
  #ifndef CONFIG_FILE
  #define CONFIG_FILE		"/etc/bootptab"
  #endif
! #ifndef BOOTPD_DUMP_FILE
! #define BOOTPD_DUMP_FILE	"/etc/bootpd.dump"
  #endif
  
+ #ifndef	FD_ISSET
+ #  define FD_SETSIZE	32
+ #endif
+ 
  
  
  /*
***************
*** 128,134 ****
--- 182,192 ----
  void insert_ip();
  int dumptab();
  int chk_access();
+ #ifdef	__STDC__
+ void report (int priority, char *fmt, ...);
+ #else
  void report();
+ #endif
  char *get_errmsg();
  
  /*
***************
*** 153,165 ****
   * General
   */
  
! int debug = 0;			    /* Debugging flag (level) */
! int s;				    /* Socket file descriptor */
! byte buf[1024];			    /* Receive packet buffer */
! struct timezone tzp;		    /* Time zone offset for clients */
! struct timeval tp;		    /* Time (extra baggage) */
! long secondswest;		    /* Time zone offset in seconds */
! 
  /*
   * Globals below are associated with the bootp database file (bootptab).
   */
--- 211,224 ----
   * General
   */
  
! int debug = 0;			    /* Debugging flag (level)         */
! int s;				    /* Socket file descriptor         */
! byte buf[1024];			    /* Receive packet buffer          */
! struct timezone tzp;		    /* Time zone offset for clients   */
! struct timeval tp;		    /* Time (extra baggage)           */
! long secondswest;		    /* Time zone offset in seconds    */
! int force_haddr = FALSE;	    /* Force hardware address lookup  */
! int flush_requests = FALSE;	    /* Flush pending requests         */
  /*
   * Globals below are associated with the bootp database file (bootptab).
   */
***************
*** 218,230 ****
      int argc;
      char **argv;
  {
!     struct timeval actualtimeout, *timeout;
!     struct bootp *bp = (struct bootp *) buf;
!     struct servent *servp;
!     char *stmp;
!     int n, tolen, fromlen;
!     int nfound, readfds;
!     int standalone;
  
      stmp = NULL;
      standalone = FALSE;
--- 277,290 ----
      int argc;
      char **argv;
  {
!     struct timeval  actualtimeout, *timeout;
!     struct bootp    *bp = (struct bootp *) buf;
!     struct servent  *servp;
!     char	    *stmp;
!     int		    n, tolen, fromlen;
!     int		    nfound;
!     fd_set	    readfds;
!     int		    standalone;
  
      stmp = NULL;
      standalone = FALSE;
***************
*** 232,238 ****
      actualtimeout.tv_sec  = 60 * DEFAULT_TIMEOUT;
      timeout = &actualtimeout;
  
- 
      /*
       * Assume a socket was passed to us from inetd.
       *
--- 292,297 ----
***************
*** 240,249 ****
--- 299,310 ----
       * (and thus we are probably a child of inetd) or if it is instead
       * something else and we are running standalone.
       */
+ 
      s = 0;
      tolen = sizeof(sin);
      bzero((char *) &sin, tolen);
      errno = 0;
+ 
      if (getsockname(s, &sin, &tolen) == 0) {
  	/*
  	 * Descriptor 0 is a socket.  Assume we're running as a child of inetd.
***************
*** 250,256 ****
  	 */
  	bootps_port = ntohs(sin.sin_port);
  	standalone = FALSE;
!     } else {
  	if (errno == ENOTSOCK) {
  	    /*
  	     * Descriptor 0 is NOT a socket.  Run in standalone mode.
--- 311,318 ----
  	 */
  	bootps_port = ntohs(sin.sin_port);
  	standalone = FALSE;
!     }
!     else {
  	if (errno == ENOTSOCK) {
  	    /*
  	     * Descriptor 0 is NOT a socket.  Run in standalone mode.
***************
*** 266,275 ****
  	}
      }
  
- 
      /*
       * Read switches.
       */
      for (argc--, argv++; argc > 0; argc--, argv++) {
  	if (argv[0][0] == '-') {
  	    switch (argv[0][1]) {
--- 328,337 ----
  	}
      }
  
      /*
       * Read switches.
       */
+ 
      for (argc--, argv++; argc > 0; argc--, argv++) {
  	if (argv[0][0] == '-') {
  	    switch (argv[0][1]) {
***************
*** 322,327 ****
--- 384,395 ----
  		case 'i':
  		    standalone = FALSE;
  		    break;
+ 		case 'h':
+ 		    force_haddr = TRUE;
+ 		    break;
+ 		case 'f':
+ 		    flush_requests = TRUE;
+ 		    break;
  		default:
  		    fprintf(stderr, "bootpd: unknown switch: -%c\n",
  			    argv[0][1]);
***************
*** 351,357 ****
      }
  #ifdef DEBUG
      if (!bootpd_dump) {
! 	bootpd_dump = DUMP_FILE;
      }
  #endif
  
--- 419,425 ----
      }
  #ifdef DEBUG
      if (!bootpd_dump) {
! 	bootpd_dump = BOOTPD_DUMP_FILE;
      }
  #endif
  
***************
*** 370,376 ****
--- 438,449 ----
  	    (void) dup2(0, 2);
  	    n = open("/dev/tty", O_RDWR);
  	    if (n >= 0) {
+ 
+ #ifdef	TIOCNOTTY
  		ioctl(n, TIOCNOTTY, (char *) 0);
+ #else
+ 	        setsid ();
+ #endif
  		(void) close(n);
  	    }
  	}
***************
*** 456,462 ****
  	sin.sin_family = AF_INET;
  	sin.sin_addr.s_addr = INADDR_ANY;
  	sin.sin_port = htons(bootps_port);
! 	if (bind(s, &sin, sizeof(sin)) < 0) {
  	    report(LOG_ERR, "bind: %s\n", get_network_errmsg());
  	    exit(1);
  	}
--- 529,535 ----
  	sin.sin_family = AF_INET;
  	sin.sin_addr.s_addr = INADDR_ANY;
  	sin.sin_port = htons(bootps_port);
! 	if (bind(s, (struct sockaddr *) &sin, sizeof(sin)) < 0) {
  	    report(LOG_ERR, "bind: %s\n", get_network_errmsg());
  	    exit(1);
  	}
***************
*** 469,475 ****
      servp = getservbyname("bootpc", "udp");
      if (servp) {
  	bootpc_port = ntohs(servp->s_port);
!     } else {
  	report(LOG_ERR,
  	       "udp/bootpc: unknown service -- assuming port %d\n",
  		IPPORT_BOOTPC);
--- 542,549 ----
      servp = getservbyname("bootpc", "udp");
      if (servp) {
  	bootpc_port = ntohs(servp->s_port);
!     }
!     else {
  	report(LOG_ERR,
  	       "udp/bootpc: unknown service -- assuming port %d\n",
  		IPPORT_BOOTPC);
***************
*** 476,487 ****
  	bootpc_port = (u_short) IPPORT_BOOTPC;
      }
  
- 
      /*
       * Determine network configuration.
       */
      ifconf.ifc_len = sizeof(ifreq);
      ifconf.ifc_req = ifreq;
      if ((ioctl(s, SIOCGIFCONF, (caddr_t) &ifconf) < 0) ||
  	(ifconf.ifc_len <= 0)) {
  	    report(LOG_ERR, "ioctl: %s\n", get_network_errmsg());
--- 550,562 ----
  	bootpc_port = (u_short) IPPORT_BOOTPC;
      }
  
      /*
       * Determine network configuration.
       */
+ 
      ifconf.ifc_len = sizeof(ifreq);
      ifconf.ifc_req = ifreq;
+ 
      if ((ioctl(s, SIOCGIFCONF, (caddr_t) &ifconf) < 0) ||
  	(ifconf.ifc_len <= 0)) {
  	    report(LOG_ERR, "ioctl: %s\n", get_network_errmsg());
***************
*** 492,505 ****
      /*
       * Set up signals to read or dump the table.
       */
!     if ((int) signal(SIGHUP, readtab) < 0) {
! 	report(LOG_ERR, "signal: %s\n", get_errmsg());
! 	exit(1);
      }
  #ifdef DEBUG
!     if ((int) signal(SIGUSR1, dumptab) < 0) {
! 	report(LOG_ERR, "signal: %s\n", get_errmsg());
! 	exit(1);
      }
  #endif
  
--- 567,580 ----
      /*
       * Set up signals to read or dump the table.
       */
!     if (signal (SIGHUP, readtab) == SIG_ERR) {
! 	report (LOG_ERR, "signal: %s\n", get_errmsg());
! 	exit (1);
      }
  #ifdef DEBUG
!     if (signal (SIGUSR1, dumptab) == SIG_ERR) {
! 	report (LOG_ERR, "signal: %s\n", get_errmsg());
! 	exit (1);
      }
  #endif
  
***************
*** 506,534 ****
      /*
       * Process incoming requests.
       */
      for (;;) {
! 	readfds = 1 << s;
! 	nfound = select(s + 1, &readfds, NULL, NULL, timeout);
! 	if (nfound < 0) {
! 	    if (errno != EINTR) {
! 		report(LOG_ERR, "select: %s\n", get_errmsg());
  	    }
- 	    continue;
  	}
! 	if (!(readfds & (1 << s))) {
! 	    report(LOG_INFO, "exiting after %ld minutes of inactivity\n",
! 		   actualtimeout.tv_sec / 60);
! 	    exit(0);
  	}
! 	fromlen = sizeof(from);
! 	n = recvfrom(s, buf, sizeof(buf), 0, &from, &fromlen);
  	if (n <= 0) {
  	    continue;
  	}
  
! 	if (n < sizeof(struct bootp)) {
  	    if (debug) {
! 		report(LOG_INFO, "received short packet\n");
  	    }
  	    continue;
  	}
--- 581,640 ----
      /*
       * Process incoming requests.
       */
+ 
      for (;;) {
!         FD_ZERO (&readfds);
! 	FD_SET (s, &readfds);
! 	n = 0;
! 
! 	if (flush_requests) {
! 	    struct timeval  to;
! 
! 	    to.tv_sec = 0;
! 	    to.tv_usec = 0;
! 
! 	    while (select (s + 1, &readfds, NULL, NULL, &to) > 0) {
! 		fromlen = sizeof(from);
! 		n = recvfrom (s, buf, sizeof(buf), 0,
! 			      (struct sockaddr *) &from, &fromlen);
! 		FD_ZERO(&readfds);
! 		FD_SET(s, &readfds);
  	    }
  	}
! 
! 	FD_ZERO(&readfds);
! 	FD_SET(s, &readfds);
! 
! 	if (n == 0) {  
! 	    nfound = select(s + 1, &readfds, NULL, NULL, timeout);
! 
! 	    if (nfound < 0) {
! 		if (errno != EINTR) {
! 		    report(LOG_ERR, "select: %s\n", get_errmsg());
! 		}
! 		continue;
! 	    }
! 
! 	    if (FD_ISSET (s, &readfds) == 0) {
! 		report (LOG_INFO, "exiting after %ld minutes of inactivity\n",
! 		       actualtimeout.tv_sec / 60);
! 		exit(0);
! 	    }
! 
! 	    fromlen = sizeof(from);
! 	    n = recvfrom (s, buf, sizeof(buf), 0,
! 			  (struct sockaddr *) &from, &fromlen);
  	}
! 
  	if (n <= 0) {
  	    continue;
  	}
  
! 	if (n < sizeof (struct bootp)) {
  	    if (debug) {
! 		report (LOG_INFO,
! 			"received short packet: len = %d, should be %d\n",
! 			n, sizeof (struct bootp));
  	    }
  	    continue;
  	}
***************
*** 556,563 ****
  void usage()
  {
      fprintf(stderr,
! "usage:  bootpd [-d level] [-i] [-s] [-t timeout] [configfile [dumpfile]]\n");
      fprintf(stderr, "\t -d n\tset debug level\n");
      fprintf(stderr, "\t -i\tforce inetd mode (run as child of inetd)\n"); 
      fprintf(stderr, "\t -s\tforce standalone mode (run without inetd)\n");
      fprintf(stderr, "\t -t n\tset inetd exit timeout to n minutes\n");
--- 662,671 ----
  void usage()
  {
      fprintf(stderr,
! "usage:  bootpd [-d level] [-f] [-h] [-i] [-s] [-t timeout] [configfile [dumpfile]]\n");
      fprintf(stderr, "\t -d n\tset debug level\n");
+     fprintf(stderr, "\t -f\tflush pending requests accepting only the last\n");
+     fprintf(stderr, "\t -h\tforce hardware -> ip address lookup\n");
      fprintf(stderr, "\t -i\tforce inetd mode (run as child of inetd)\n"); 
      fprintf(stderr, "\t -s\tforce standalone mode (run without inetd)\n");
      fprintf(stderr, "\t -t n\tset inetd exit timeout to n minutes\n");
***************
*** 579,601 ****
   */
  request()
  {
!     register struct bootp *bp = (struct bootp *) buf;
!     register struct host *hp;
!     register int n;
!     char *path;
!     struct host dummyhost;
!     long bootsize;
!     unsigned hlen, hashcode;
!     char realpath[1024];
  
      bp->bp_op = BOOTREPLY;
!     if (bp->bp_ciaddr.s_addr == 0) { 
  	/*
! 	 * client doesnt know his IP address, 
! 	 * search by hardware address.
  	 */
  	if (debug) {
! 	    report(LOG_INFO, "request from %s address %s\n",
  		    netname(bp->bp_htype),
  		    haddrtoa(bp->bp_chaddr, bp->bp_htype));
  	}
--- 687,712 ----
   */
  request()
  {
!     register struct bootp   *bp = (struct bootp *) buf;
!     register struct host    *hp;
!     register int	    n;
!     char		    *path;
!     struct host		    dummyhost;
!     long		    bootsize;
!     unsigned		    hlen, hashcode;
!     char		    realpath[1024];
  
      bp->bp_op = BOOTREPLY;
! 
!     if (force_haddr || bp->bp_ciaddr.s_addr == 0) {
  	/*
! 	 *  The client doesn't know it's IP address
! 	 *  or we want to forcibly deliver the IP-addresses
! 	 *  depending only on the hardware address of the client.
  	 */
+ 
  	if (debug) {
! 	     report (LOG_INFO, "request from %s address %s\n",
  		    netname(bp->bp_htype),
  		    haddrtoa(bp->bp_chaddr, bp->bp_htype));
  	}
***************
*** 604,609 ****
--- 715,721 ----
  	hlen = haddrlength(bp->bp_htype);
  	bcopy(bp->bp_chaddr, dummyhost.haddr, hlen);
  	hashcode = hash_HashFunction(bp->bp_chaddr, hlen);
+ 
  	hp = (struct host *) hash_Lookup(hwhashtable, hashcode, hwlookcmp,
  					 &dummyhost);
  	if (hp == NULL) {
***************
*** 612,635 ****
  		    haddrtoa(bp->bp_chaddr, bp->bp_htype));
  	    return;	/* not found */
  	}
- 	(bp->bp_yiaddr).s_addr = hp->iaddr.s_addr;
  
!     } else {
  
  	/*
  	 * search by IP address.
  	 */
  	if (debug) {
  	    report(LOG_INFO, "request from IP addr %s\n",
! 		    inet_ntoa(bp->bp_ciaddr));
  	}
  	dummyhost.iaddr.s_addr = bp->bp_ciaddr.s_addr;
! 	hashcode = hash_HashFunction((char *) &(bp->bp_ciaddr.s_addr), 4);
  	hp = (struct host *) hash_Lookup(iphashtable, hashcode, iplookcmp,
  					 &dummyhost);
  	if (hp == NULL) {
  	    report(LOG_NOTICE,
! 		    "IP address not found: %s\n", inet_ntoa(bp->bp_ciaddr));
  	    return;
  	}
      }
--- 724,776 ----
  		    haddrtoa(bp->bp_chaddr, bp->bp_htype));
  	    return;	/* not found */
  	}
  
! 	/*
! 	 *  CSC extension contained in this if-statement.
! 	 *
! 	 *  Find and fill in the address when it gets queried the first time
! 	 *  if we got only a wildcard default INADDR_ANY (= 0.0.0.0) from
! 	 *  the bootptab file.
! 	 */
! 
! 	if (hp->flags.iaddr && (hp->iaddr.s_addr == INADDR_ANY)) {
! 	    struct hostent	*host;
! 	    register char	*h_name = &hp->hostname->string[0];
! 
! 	    host = gethostbyname (h_name);
! 
! 	    if (! host) {
! 		report (LOG_ERR,
! 			"Cannot find ip address for host %s.\n",
! 			hp->hostname->string);
! 		return;
! 	    }
! 
! 	    hp->iaddr.s_addr = ((struct in_addr *)
! 				host->h_addr_list[0])->s_addr;
! 	}
! 
! 	(bp->bp_yiaddr).s_addr = hp->iaddr.s_addr;
!     }
  
+     else {
  	/*
  	 * search by IP address.
  	 */
+ 
  	if (debug) {
  	    report(LOG_INFO, "request from IP addr %s\n",
! 		    inet_ntoa (bp->bp_ciaddr));
  	}
+ 
  	dummyhost.iaddr.s_addr = bp->bp_ciaddr.s_addr;
! 	hashcode = hash_HashFunction ((char *) &(bp->bp_ciaddr.s_addr), 4);
! 
  	hp = (struct host *) hash_Lookup(iphashtable, hashcode, iplookcmp,
  					 &dummyhost);
  	if (hp == NULL) {
  	    report(LOG_NOTICE,
! 		   "IP address not found: %s\n", inet_ntoa (bp->bp_ciaddr));
  	    return;
  	}
      }
***************
*** 638,655 ****
  	report(LOG_INFO, "found %s %s\n", inet_ntoa(hp->iaddr),
  		hp->hostname->string);
      }
! 
      /*
       * If a specific TFTP server address was specified in the bootptab file,
       * fill it in, otherwise zero it.
       */
!     (bp->bp_siaddr).s_addr = (hp->flags.bootserver) ?
! 	hp->bootserver.s_addr : 0L;
  
      /*
       * This next line is a bit of a mystery.  It seems to be vestigial
       * code (from Stanford???) which should probably be axed.
       */
      if (strcmp(bp->bp_file, "sunboot14") == 0)
  	bp->bp_file[0] = 0;	/* pretend it's null */
  
--- 779,798 ----
  	report(LOG_INFO, "found %s %s\n", inet_ntoa(hp->iaddr),
  		hp->hostname->string);
      }
! 	
      /*
       * If a specific TFTP server address was specified in the bootptab file,
       * fill it in, otherwise zero it.
       */
!     (bp->bp_siaddr).s_addr = (hp->flags.bootserver)
! 			   ? hp->bootserver.s_addr
! 			   : INADDR_ANY;
  
      /*
       * This next line is a bit of a mystery.  It seems to be vestigial
       * code (from Stanford???) which should probably be axed.
       */
+ 
      if (strcmp(bp->bp_file, "sunboot14") == 0)
  	bp->bp_file[0] = 0;	/* pretend it's null */
  
***************
*** 681,687 ****
      if (hp->flags.tftpdir) {
  	strcpy(realpath, hp->tftpdir->string);
  	path = &realpath[strlen(realpath)];
!     } else {
  	path = realpath;
      }
  
--- 824,831 ----
      if (hp->flags.tftpdir) {
  	strcpy(realpath, hp->tftpdir->string);
  	path = &realpath[strlen(realpath)];
!     }
!     else {
  	path = realpath;
      }
  
***************
*** 689,719 ****
  	/*
  	 * The client specified a file.
  	 */
  	if (bp->bp_file[0] == '/') {
  	    strcpy(path, bp->bp_file);		/* Absolute pathname */
! 	} else {
  	    if (hp->flags.homedir) {
  		strcpy(path, hp->homedir->string);
  		strcat(path, "/");
  		strcat(path, bp->bp_file);
! 	    } else {
! 		report(LOG_NOTICE,
! 		    "requested file \"%s\" not found: hd unspecified\n",
! 		    bp->bp_file);
  		return;
  	    }
  	}
!     } else {
  	/*
  	 * No file specified by the client.
  	 */
  	if (hp->flags.bootfile && ((hp->bootfile->string)[0] == '/')) {
  	    strcpy(path, hp->bootfile->string);
! 	} else if (hp->flags.homedir && hp->flags.bootfile) {
  	    strcpy(path, hp->homedir->string);
  	    strcat(path, "/");
  	    strcat(path, hp->bootfile->string);
! 	} else {
  	    bzero(bp->bp_file, sizeof(bp->bp_file));
  	    goto skip_file;	/* Don't bother trying to access the file */
  	}
--- 833,880 ----
  	/*
  	 * The client specified a file.
  	 */
+ 
+ 	report(LOG_INFO, "Using client specified file %s\n", bp->bp_file);
+ 
  	if (bp->bp_file[0] == '/') {
  	    strcpy(path, bp->bp_file);		/* Absolute pathname */
! 	}
! 	else {
  	    if (hp->flags.homedir) {
  		strcpy(path, hp->homedir->string);
  		strcat(path, "/");
  		strcat(path, bp->bp_file);
! 	    }
! 	    else {
! 		report (LOG_NOTICE,
! 		        "requested file \"%s\" not found: hd unspecified\n",
! 			bp->bp_file);
  		return;
  	    }
  	}
!     }
!     else {
  	/*
  	 * No file specified by the client.
  	 */
+ 
+ 	if (hp->flags.bootserver && hp->flags.bootfile) {
+ 	    report (LOG_INFO,
+ 		    "Boot server specified, not verifying bootfile: %s\n",
+ 		    hp->bootfile->string);
+ 	    strcpy (bp->bp_file, hp->bootfile->string);
+ 	    goto skip_file;	/* Don't bother if using bootserver */
+ 	}
+ 
  	if (hp->flags.bootfile && ((hp->bootfile->string)[0] == '/')) {
  	    strcpy(path, hp->bootfile->string);
! 	}
! 	else if (hp->flags.homedir && hp->flags.bootfile) {
  	    strcpy(path, hp->homedir->string);
  	    strcat(path, "/");
  	    strcat(path, hp->bootfile->string);
! 	}
! 	else {
  	    bzero(bp->bp_file, sizeof(bp->bp_file));
  	    goto skip_file;	/* Don't bother trying to access the file */
  	}
***************
*** 722,732 ****
--- 883,896 ----
      /*
       * First try to find the file with a ".host" suffix
       */
+ 
      n = strlen(path);
      strcat(path, ".");
      strcat(path, hp->hostname->string);
+ 
      if (chk_access(realpath, &bootsize) < 0) {
  	path[n] = 0;			/* Try it without the suffix */
+ 
  	if (chk_access(realpath, &bootsize) < 0) {
  	    if (bp->bp_file[0]) {
  		/*
***************
*** 736,742 ****
  		report(LOG_NOTICE,
  			"requested file not found: \"%s\"\n", path);
  		return;
! 	    } else {
  		/*
  		 * Client didn't ask for a specific file and we couldn't
  		 * access the default file, so just zero-out the bootfile
--- 900,907 ----
  		report(LOG_NOTICE,
  			"requested file not found: \"%s\"\n", path);
  		return;
! 	    }
! 	    else {
  		/*
  		 * Client didn't ask for a specific file and we couldn't
  		 * access the default file, so just zero-out the bootfile
***************
*** 823,839 ****
  	 * else make a temporary arp cache entry for the client's NEW 
  	 * IP/hardware address and use that.
  	 */
  	if (bp->bp_ciaddr.s_addr) {
  		dst = bp->bp_ciaddr;
! 	} else if (bp->bp_giaddr.s_addr && forward == 0) {
  		dst = bp->bp_giaddr;
  		to.sin_port = htons(bootps_port);
! 	} else {
  		dst = bp->bp_yiaddr;
  		setarp(&dst, bp->bp_chaddr, bp->bp_hlen);
  	}
  
! 	if (forward == 0) {
  		/*
  		 * If we are originating this reply, we
  		 * need to find our own interface address to
--- 988,1007 ----
  	 * else make a temporary arp cache entry for the client's NEW 
  	 * IP/hardware address and use that.
  	 */
+ 
  	if (bp->bp_ciaddr.s_addr) {
  		dst = bp->bp_ciaddr;
! 	}
! 	else if (bp->bp_giaddr.s_addr && forward == 0) {
  		dst = bp->bp_giaddr;
  		to.sin_port = htons(bootps_port);
! 	}
! 	else {
  		dst = bp->bp_yiaddr;
  		setarp(&dst, bp->bp_chaddr, bp->bp_hlen);
  	}
  
! 	if (! forward) {
  		/*
  		 * If we are originating this reply, we
  		 * need to find our own interface address to
***************
*** 842,847 ****
--- 1010,1016 ----
  		 * 'best' interface (the one on the same net
  		 * as the client).
  		 */
+ 
  		int maxmatch = 0;
  		int len, m;
  		register struct ifreq *ifrq, *ifrmax;
***************
*** 848,853 ****
--- 1017,1023 ----
  
  		ifrmax = ifrq = &ifreq[0];
  		len = ifconf.ifc_len;
+ 
  		for (; len > 0; len -= sizeof(ifreq[0]), ifrq++) {
  			m = nmatch(&dst, &((struct sockaddr_in *)
  					  (&ifrq->ifr_addr))->sin_addr);
***************
*** 856,861 ****
--- 1026,1032 ----
  				ifrmax = ifrq;
  			}
  		}
+ 
  		if (bp->bp_giaddr.s_addr == 0) {
  			if (maxmatch == 0) {
  				return;
***************
*** 868,873 ****
--- 1039,1045 ----
  		 * If a specific TFTP server address wasn't specified
  		 * in the bootptab file, fill in our own address.
  		 */
+ 
  		if (bp->bp_siaddr.s_addr == 0) {
  		    bp->bp_siaddr = ((struct sockaddr_in *)
  				     (&ifrmax->ifr_addr))->sin_addr;
***************
*** 875,882 ****
  	}
  
  	to.sin_addr = dst; 
! 	if (sendto(s, bp, sizeof(struct bootp), 0, &to, sizeof(to)) < 0) {
! 	    report(LOG_ERR, "sendto: %s\n", get_network_errmsg());
  	}
  }
  
--- 1047,1055 ----
  	}
  
  	to.sin_addr = dst; 
! 	if (sendto (s, bp, sizeof (struct bootp), 0,
! 		    (struct sockaddr *) &to, sizeof(to)) < 0) {
! 	    report (LOG_ERR, "sendto: %s\n", get_network_errmsg());
  	}
  }
  
***************
*** 999,1008 ****
      fprintf(fp, "#\trl -- resource location protocol servers\n");
      fprintf(fp, "#\tsm -- subnet mask\n");
      fprintf(fp, "#\tto -- time offset (seconds)\n");
      fprintf(fp, "#\tts -- time servers\n\n\n");
  
      n = 0;
!     for (hp = (struct host *) hash_FirstEntry(nmhashtable); hp != NULL;
  	 hp = (struct host *) hash_NextEntry(nmhashtable)) {
  	    dump_host(fp, hp);
  	    fprintf(fp, "\n");
--- 1172,1184 ----
      fprintf(fp, "#\trl -- resource location protocol servers\n");
      fprintf(fp, "#\tsm -- subnet mask\n");
      fprintf(fp, "#\tto -- time offset (seconds)\n");
+     fprintf(fp, "#\tsa -- boot server address\n");
      fprintf(fp, "#\tts -- time servers\n\n\n");
  
      n = 0;
! 
!     for (hp = (struct host *) hash_FirstEntry(nmhashtable);
! 	 hp;
  	 hp = (struct host *) hash_NextEntry(nmhashtable)) {
  	    dump_host(fp, hp);
  	    fprintf(fp, "\n");
***************
*** 1031,1039 ****
--- 1207,1217 ----
  	if (hp->hostname) {
  	    fprintf(fp, "%s:", hp->hostname->string);
  	}
+ 
  	if (hp->flags.bootfile) {
  	    fprintf(fp, "bf=%s:", hp->bootfile->string);
  	}
+ 
  	if (hp->flags.bootsize) {
  	    fprintf(fp, "bs=");
  	    if (hp->flags.bootsize_auto) {
***************
*** 1042,1068 ****
--- 1220,1252 ----
  		fprintf(fp, "%d:", hp->bootsize);
  	    }
  	}
+ 
  	if (hp->flags.cookie_server) {
  	    fprintf(fp, "cs=");
  	    list_ipaddresses(fp, hp->cookie_server);
  	    fprintf(fp, ":");
  	}
+ 
  	if (hp->flags.domain_server) {
  	    fprintf(fp, "ds=");
  	    list_ipaddresses(fp, hp->domain_server);
  	    fprintf(fp, ":");
  	}
+ 
  	if (hp->flags.gateway) {
  	    fprintf(fp, "gw=");
  	    list_ipaddresses(fp, hp->gateway);
  	    fprintf(fp, ":");
  	}
+ 
  	if (hp->flags.homedir) {
  	    fprintf(fp, "hd=%s:", hp->homedir->string);
  	}
+ 
  	if (hp->flags.name_switch && hp->flags.send_name) {
  	    fprintf(fp, "hn:");
  	}
+ 
  	if (hp->flags.htype) {
  	    fprintf(fp, "ht=%u:", (unsigned) hp->htype);
  	    if (hp->flags.haddr) {
***************
*** 1069,1111 ****
--- 1253,1305 ----
  		fprintf(fp, "ha=%s:", haddrtoa(hp->haddr, hp->htype));
  	    }
  	}
+ 
  	if (hp->flags.impress_server) {
  	    fprintf(fp, "im=");
  	    list_ipaddresses(fp, hp->impress_server);
  	    fprintf(fp, ":");
  	}
+ 
  	if (hp->flags.iaddr) {
  	    fprintf(fp, "ip=%s:", inet_ntoa(hp->iaddr));
  	}
+ 
  	if (hp->flags.log_server) {
  	    fprintf(fp, "lg=");
  	    list_ipaddresses(fp, hp->log_server);
  	    fprintf(fp, ":");
  	}
+ 
  	if (hp->flags.lpr_server) {
  	    fprintf(fp, "lp=");
  	    list_ipaddresses(fp, hp->lpr_server);
  	    fprintf(fp, ":");
  	}
+ 
  	if (hp->flags.name_server) {
  	    fprintf(fp, "ns=");
  	    list_ipaddresses(fp, hp->name_server);
  	    fprintf(fp, ":");
  	}
+ 
  	if (hp->flags.rlp_server) {
  	    fprintf(fp, "rl=");
  	    list_ipaddresses(fp, hp->rlp_server);
  	    fprintf(fp, ":");
  	}
+ 
  	if (hp->flags.bootserver) {
  	    fprintf(fp, "sa=%s:", inet_ntoa(hp->bootserver));
  	}
+ 
  	if (hp->flags.subnet_mask) {
  	    fprintf(fp, "sm=%s:", inet_ntoa(hp->subnet_mask));
  	}
+ 
  	if (hp->flags.tftpdir) {
  	    fprintf(fp, "td=%s:", hp->tftpdir->string);
  	}
+ 
  	if (hp->flags.time_offset) {
  	    if (hp->flags.timeoff_auto) {
  		fprintf(fp, "to=auto:");
***************
*** 1113,1132 ****
  		fprintf(fp, "to=%ld:", hp->time_offset);
  	    }
  	}
  	if (hp->flags.time_server) {
  	    fprintf(fp, "ts=");
  	    list_ipaddresses(fp, hp->time_server);
  	    fprintf(fp, ":");
  	}
  	if (hp->flags.vendor_magic) {
  	    fprintf(fp, "vm=");
  	    if (hp->flags.vm_auto) {
  		fprintf(fp, "auto:");
! 	    } else if (!bcmp(hp->vm_cookie, vm_cmu, 4)) {
  		fprintf(fp, "cmu:");
! 	    } else if (!bcmp(hp->vm_cookie, vm_rfc1048, 4)) {
  		fprintf(fp, "rfc1048");
! 	    } else {
  		fprintf(fp, "%d.%d.%d.%d:",
  			    (int) ((hp->vm_cookie)[0]),
  			    (int) ((hp->vm_cookie)[1]),
--- 1307,1331 ----
  		fprintf(fp, "to=%ld:", hp->time_offset);
  	    }
  	}
+ 
  	if (hp->flags.time_server) {
  	    fprintf(fp, "ts=");
  	    list_ipaddresses(fp, hp->time_server);
  	    fprintf(fp, ":");
  	}
+ 
  	if (hp->flags.vendor_magic) {
  	    fprintf(fp, "vm=");
  	    if (hp->flags.vm_auto) {
  		fprintf(fp, "auto:");
! 	    }
! 	    else if (!bcmp(hp->vm_cookie, vm_cmu, 4)) {
  		fprintf(fp, "cmu:");
! 	    }
! 	    else if (!bcmp(hp->vm_cookie, vm_rfc1048, 4)) {
  		fprintf(fp, "rfc1048");
! 	    }
! 	    else {
  		fprintf(fp, "%d.%d.%d.%d:",
  			    (int) ((hp->vm_cookie)[0]),
  			    (int) ((hp->vm_cookie)[1]),
***************
*** 1134,1145 ****
--- 1333,1347 ----
  			    (int) ((hp->vm_cookie)[3]));
  	    }
  	}
+ 
  	if (hp->flags.generic) {
  	    fprintf(fp, "generic=");
  	    dataptr = hp->generic->data;
+ 
  	    for (i = hp->generic->length; i > 0; i--) {
  		fprintf(fp, "%02X", (int) *dataptr++);
  	    }
+ 
  	    fprintf(fp, ":");
  	}
      }
***************
*** 1562,1568 ****
  }
  
  
- 
  /*
   * This routine reports errors and such via stderr and syslog() if
   * appopriate.  It just helps avoid a lot of "#ifdef SYSLOG" constructs
--- 1764,1769 ----
***************
*** 1575,1585 ****
   * newlines and adds its own at the end).
   */
  
! /*VARARGS2*/
! void report(priority, fmt, p0, p1, p2, p3, p4)
!     int priority;
!     char *fmt;
  {
  #ifdef LOG_SALERT
      static char *levelnames[] = {
  	"unknown level: ",
--- 1776,1799 ----
   * newlines and adds its own at the end).
   */
  
! #ifdef	__STDC__
! 
! void
! report (int priority, char *fmt, ...)
! 
! #else
! 
! void
! report (priority, fmt, va_alist)
!     int	    priority;
!     char    *fmt;
!     va_dcl
! 
! #endif
  {
+   char	    buf[2048];
+   va_list   ap;
+ 
  #ifdef LOG_SALERT
      static char *levelnames[] = {
  	"unknown level: ",
***************
*** 1612,1625 ****
  	priority = sizeof(levelnames) / sizeof(char *) - 1;
      }
  
      /*
       * Print the message
       */
      if (debug > 2) {
  	fprintf(stderr, "bootpd: %s ", levelnames[priority]);
! 	fprintf(stderr, fmt, p0, p1, p2, p3, p4);
      }
  #ifdef SYSLOG
!     syslog(priority, fmt, p0, p1, p2, p3, p4);
  #endif
  }
--- 1826,1851 ----
  	priority = sizeof(levelnames) / sizeof(char *) - 1;
      }
  
+ #ifdef	__STDC__
+     va_start(ap, fmt);
+ #else
+     va_start(ap);
+ #endif
+ 
+     vsprintf (buf, fmt, ap);
+ 
+     va_end(ap);
+ 
      /*
       * Print the message
       */
+ 
      if (debug > 2) {
  	fprintf(stderr, "bootpd: %s ", levelnames[priority]);
! 	fprintf(stderr, buf);
      }
  #ifdef SYSLOG
!     syslog(priority, buf);
  #endif
  }
+ 
*** orig/bootpd.h	Wed May  4 13:07:49 1994
--- csc/bootpd.h	Thu May  5 16:50:20 1994
***************
*** 44,49 ****
--- 44,53 ----
  #define SIGUSR1			 30	/* From 4.3 <signal.h> */
  #endif
  
+ #ifndef SIG_ERR
+ #define SIG_ERR -1
+ #endif
+ 
  #define MAXHTYPES		  7	/* Number of htypes defined */
  #define MAXHADDRLEN		  6	/* Max hw address length in bytes */
  #define MAXSTRINGLEN		 80	/* Max string length */
***************
*** 82,88 ****
--- 86,97 ----
   * Functions shared among modules
   */
  
+ #ifdef	__STDC__
+ extern void report (int priority, char *fmt, ...);
+ #else
  extern void report();
+ #endif
+ 
  extern char *get_errmsg();
  extern char *haddrtoa();
  extern int readtab();
No differences encountered
*** orig/bootptab.5	Wed May  4 13:07:49 1994
--- csc/bootptab.5	Tue May 10 14:45:18 1994
***************
*** 2,8 ****
  .\"
  .\"	$Header: /afs/andrew.cmu.edu/netdev/src/cmu/bootp-public/RCS/bootpd.8,v 1.1 1991/10/31 19:15:12 ww0n Exp ww0n $
  .\"
! .TH BOOTPTAB 5 "October 31, 1991" "Carnegie Mellon University"
  .UC 6
  
  .SH NAME
--- 2,9 ----
  .\"
  .\"	$Header: /afs/andrew.cmu.edu/netdev/src/cmu/bootp-public/RCS/bootpd.8,v 1.1 1991/10/31 19:15:12 ww0n Exp ww0n $
  .\"
! .\".TH BOOTPTAB 5 "October 31, 1991" "Carnegie Mellon University"
! .TH BOOTPTAB 5 "May 10, 1994" "Centre for Scientific Computing"
  .UC 6
  
  .SH NAME
***************
*** 106,114 ****
  and
  .B sm
  tags each take a single IP address.
! All IP addresses are specified in standard Internet "dot" notation and may use
! decimal, octal, or hexadecimal numbers (octal numbers begin with 0,
! hexadecimal numbers begin with '0x' or '0X').
  .PP
  The
  .B ht
--- 107,137 ----
  and
  .B sm
  tags each take a single IP address.
! All IP addresses can be specified in standard Internet dotted-quad notation
! and may use decimal, octal, or hexadecimal numbers (octal numbers begin
! with 0, hexadecimal numbers begin with '0x' or '0X'). The addresses can be
! given also as hostnames. If an addresses is given as a hostname it is
! canonicalized and resolved to an Internet address using the standard library
! routine gethostbyname().
! .br
! \fBN.B.\fP The local view of a canonical name may not necessarily be the
! normal DNS style FQDN because there are still sites at which gethostbyname()
! uses only /etc/hosts or do even weirder things like using NIS for resolving
! the names and addresses. The preferred method is DNS!
! .sp
! There is also a special case address known to bootpd. It uses the address
! 0.0.0.0 (== INADDR_ANY) as a wildcard which forces bootpd to look up the
! true address by passing the name field from an entry as the name parameter
! to gethostbyname(). This is only done when the entry is known to be a true
! host-entry which is judged by the fields \fBht\fP (hardware type) and
! \fBha\fP (hardware address) being specified for the entry.
! Normally an \fBip\fP-field will never be inherited from another entry but
! the field ip=0 makes an exception in this rule and allows you effectively
! tell bootpd to canonify and resolve all \fBip\fP-fields using gethostbyname().
! This simplifies a lot the job of composing the /etc/bootptab files.
! .br
! \fBN.B.\fP Using the address 0.0.0.0 with any other field than \fBip\fP is
! illegal and might lead to catastrophic results.
  .PP
  The
  .B ht
No differences encountered
No differences encountered
No differences encountered
No differences encountered
*** orig/readfile.c	Wed May  4 13:07:50 1994
--- csc/readfile.c	Fri May  6 17:51:57 1994
***************
*** 47,52 ****
--- 47,53 ----
  #include <sys/file.h>
  #include <sys/time.h>
  #include <netinet/in.h>
+ #include <netdb.h>
  #ifdef SYSLOG
  #include <syslog.h>
  #endif
***************
*** 298,306 ****
  	    continue;
  	}
  
! 	if ((hp->flags.htype && hp->flags.haddr) || hp->flags.iaddr) {
  	    nhosts++;
  	}
  	if (hp->flags.htype && hp->flags.haddr) {
  	    hashcode = hash_HashFunction(hp->haddr, haddrlength(hp->htype));
  	    if (hash_Insert(hwhashtable, hashcode, hwinscmp, hp, hp) < 0) {
--- 299,313 ----
  	    continue;
  	}
  
! 	if ((hp->flags.htype && hp->flags.haddr) ||
! 	    (hp->flags.iaddr && (hp->iaddr.s_addr != INADDR_ANY))) {
! 	    /*
! 	     *	We don't want to count wildcarded ip-entries
! 	     *	from common tc=xxx records.
! 	     */
  	    nhosts++;
  	}
+ 
  	if (hp->flags.htype && hp->flags.haddr) {
  	    hashcode = hash_HashFunction(hp->haddr, haddrlength(hp->htype));
  	    if (hash_Insert(hwhashtable, hashcode, hwinscmp, hp, hp) < 0) {
***************
*** 311,327 ****
  		continue;
  	    }
  	}
  	if (hp->flags.iaddr) {
! 	    hashcode = hash_HashFunction(&(hp->iaddr.s_addr), 4);
! 	    if (hash_Insert(iphashtable, hashcode, nullcmp, hp, hp) < 0) {
  		report(LOG_ERR,
! 			"hash_Insert() failed on IP address insertion\n");
  	    }
  	}
  
  	hashcode = hash_HashFunction(hp->hostname->string,
  				     strlen(hp->hostname->string));
! 	if (hash_Insert(nmhashtable, hashcode, nullcmp, hp->hostname->string, hp) < 0) {
  	    report(LOG_ERR,
  		   "hash_Insert() failed on insertion of hostname: \"%s\"\n",
  		   hp->hostname->string);
--- 318,338 ----
  		continue;
  	    }
  	}
+ 
  	if (hp->flags.iaddr) {
! 	    hashcode = hash_HashFunction (&(hp->iaddr.s_addr), 4);
! 
! 	    if (hash_Insert (iphashtable, hashcode, nullcmp, hp, hp) < 0) {
  		report(LOG_ERR,
! 		       "hash_Insert() failed on IP address insertion\n");
  	    }
  	}
  
  	hashcode = hash_HashFunction(hp->hostname->string,
  				     strlen(hp->hostname->string));
! 
! 	if (hash_Insert(nmhashtable, hashcode,
! 			nullcmp, hp->hostname->string, hp) < 0) {
  	    report(LOG_ERR,
  		   "hash_Insert() failed on insertion of hostname: \"%s\"\n",
  		   hp->hostname->string);
***************
*** 496,504 ****
   * (Some errors probably shouldn't be so completely fatal. . . .)
   */
  
! PRIVATE int process_entry(host, src)
! struct host *host;
! char *src;
  {
      int retval;
  
--- 507,516 ----
   * (Some errors probably shouldn't be so completely fatal. . . .)
   */
  
! int
! process_entry(host, src)
!     struct host	    *host;
!     char	    *src;
  {
      int retval;
  
***************
*** 567,572 ****
--- 579,585 ----
  		 * This algorithm is also not entirely correct.
  		 */
  		if (!(hp->flags.subnet_mask)) {
+ 		    register unsigned long  value = hp->iaddr;
  		    /*
  		     * Try to deduce the subnet mask from the network class
  		     */
***************
*** 606,614 ****
   * Obviously, this need a few more comments. . . .
   */
  
! PRIVATE eval_symbol(symbol, hp)
! char **symbol;
! struct host *hp;
  {
      char tmpstr[MAXSTRINGLEN];
      byte *tmphaddr, *ustr;
--- 619,628 ----
   * Obviously, this need a few more comments. . . .
   */
  
! int
! eval_symbol(symbol, hp)
!     char	    **symbol;
!     struct host	    *hp;
  {
      char tmpstr[MAXSTRINGLEN];
      byte *tmphaddr, *ustr;
***************
*** 878,893 ****
  	case SYM_IPADDR:
  	    switch (optype) {
  		case OP_ADDITION:
! 		    if (prs_inetaddr(symbol, &value) < 0) {
  			return E_BAD_IPADDR;
- 		    } else {
- 			hp->iaddr.s_addr = value;
- 			hp->flags.iaddr = TRUE;
  		    }
  		    break;
  		case OP_DELETION:
  		    hp->flags.iaddr = FALSE;
  		    break;
  		case OP_BOOLEAN:
  		    return E_SYNTAX_ERROR;
  	    }
--- 892,925 ----
  	case SYM_IPADDR:
  	    switch (optype) {
  		case OP_ADDITION:
! 		    if (prs_inetaddr (symbol, &value) < 0) {
  			return E_BAD_IPADDR;
  		    }
+ 
+ 		    if (value == INADDR_ANY) {
+ 			struct hostent	*host;
+ 			register char	*h_name = &hp->hostname->string[0];
+ 
+ 			host = gethostbyname (h_name);
+ 
+ 			if (! host) {
+ 			    if (hp->flags.htype && hp->flags.haddr)
+ 				return E_BAD_IPADDR;
+ 			}
+ 			else {
+ 			    value = ((struct in_addr *)
+ 				     host->h_addr_list[0])->s_addr;
+ 			}
+ 		    }
+ 
+ 		    hp->iaddr.s_addr = value;
+ 		    hp->flags.iaddr = TRUE;
  		    break;
+ 
  		case OP_DELETION:
  		    hp->flags.iaddr = FALSE;
  		    break;
+ 
  		case OP_BOOLEAN:
  		    return E_SYNTAX_ERROR;
  	    }
***************
*** 982,995 ****
  		case OP_ADDITION:
  		    if (prs_inetaddr(symbol, &value) < 0) {
  			return E_BAD_SMASK;
- 		    } else {
- 			hp->subnet_mask.s_addr = value;
- 			hp->flags.subnet_mask = TRUE;
  		    }
  		    break;
  		case OP_DELETION:
  		    hp->flags.subnet_mask = FALSE;
  		    break;
  		case OP_BOOLEAN:
  		    return E_SYNTAX_ERROR;
  	    }
--- 1014,1028 ----
  		case OP_ADDITION:
  		    if (prs_inetaddr(symbol, &value) < 0) {
  			return E_BAD_SMASK;
  		    }
+ 		    hp->subnet_mask.s_addr = value;
+ 		    hp->flags.subnet_mask = TRUE;
  		    break;
+ 
  		case OP_DELETION:
  		    hp->flags.subnet_mask = FALSE;
  		    break;
+ 
  		case OP_BOOLEAN:
  		    return E_SYNTAX_ERROR;
  	    }
***************
*** 1047,1061 ****
  		case OP_ADDITION:
  		    if (!strncmp(*symbol, "auto", 4)) {
  			hp->flags.vm_auto = TRUE;	/* Make it auto */
! 		    } else if (!strncmp(*symbol, "rfc1048", 7) ||
  			       !strncmp(*symbol, "rfc1084", 7)) {
  			hp->flags.vm_auto = FALSE;	/* Make it manual */
  			bcopy(vm_rfc1048, hp->vm_cookie, 4);
! 		    } else if (!strncmp(*symbol, "cmu", 3)) {
  			hp->flags.vm_auto = FALSE;	/* Make it manual */
  			bcopy(vm_cmu, hp->vm_cookie, 4);
! 		    } else {
! 			if (prs_inetaddr(symbol, &value) < 0) {
  			    return E_BAD_VM_COOKIE;
  			}
  			hp->flags.vm_auto = FALSE;	/* Make it manual */
--- 1080,1097 ----
  		case OP_ADDITION:
  		    if (!strncmp(*symbol, "auto", 4)) {
  			hp->flags.vm_auto = TRUE;	/* Make it auto */
! 		    }
! 		    else if (!strncmp(*symbol, "rfc1048", 7) ||
  			       !strncmp(*symbol, "rfc1084", 7)) {
  			hp->flags.vm_auto = FALSE;	/* Make it manual */
  			bcopy(vm_rfc1048, hp->vm_cookie, 4);
! 		    }
! 		    else if (!strncmp(*symbol, "cmu", 3)) {
  			hp->flags.vm_auto = FALSE;	/* Make it manual */
  			bcopy(vm_cmu, hp->vm_cookie, 4);
! 		    }
! 		    else {
! 			if (prs_inetaddr (symbol, &value) < 0) {
  			    return E_BAD_VM_COOKIE;
  			}
  			hp->flags.vm_auto = FALSE;	/* Make it manual */
***************
*** 1064,1072 ****
--- 1100,1110 ----
  		    }
  		    hp->flags.vendor_magic = TRUE;
  		    break;
+ 
  		case OP_DELETION:
  		    hp->flags.vendor_magic = FALSE;
  		    break;
+ 
  		case OP_BOOLEAN:
  		    hp->flags.vm_auto = TRUE;
  		    hp->flags.vendor_magic = TRUE;
***************
*** 1124,1139 ****
  	case SYM_BOOT_SERVER:
  	    switch (optype) {
  		case OP_ADDITION:
! 		    if (prs_inetaddr(symbol, &value) < 0) {
  			return E_BAD_BOOT_SERVER;
- 		    } else {
- 			hp->bootserver.s_addr = value;
- 			hp->flags.bootserver = TRUE;
  		    }
  		    break;
  		case OP_DELETION:
  		    hp->flags.bootserver = FALSE;
  		    break;
  		case OP_BOOLEAN:
  		    return E_SYNTAX_ERROR;
  	    }
--- 1162,1179 ----
  	case SYM_BOOT_SERVER:
  	    switch (optype) {
  		case OP_ADDITION:
! 		    if (prs_inetaddr (symbol, &value) < 0) {
  			return E_BAD_BOOT_SERVER;
  		    }
+ 
+ 		    hp->bootserver.s_addr = value;
+ 		    hp->flags.bootserver = TRUE;
  		    break;
+ 
  		case OP_DELETION:
  		    hp->flags.bootserver = FALSE;
  		    break;
+ 
  		case OP_BOOLEAN:
  		    return E_SYNTAX_ERROR;
  	    }
***************
*** 1192,1200 ****
   * null-terminated.
   */
  
! PRIVATE char *get_string(src, dest, length)
! char **src, *dest;
! unsigned *length;
  {
      int n, len, quoteflag;
  
--- 1232,1241 ----
   * null-terminated.
   */
  
! PRIVATE char *
! get_string(src, dest, length)
!     char	**src, *dest;
!     unsigned	*length;
  {
      int n, len, quoteflag;
  
***************
*** 1223,1228 ****
--- 1264,1270 ----
      /*
       * Remove that troublesome trailing whitespace. . .
       */
+ 
      while ((n > 0) && isspace(dest[-1])) {
  	dest--;
  	n--;
***************
*** 1243,1250 ****
   * The string is read using the same rules as get_string() above.
   */
  
! PRIVATE struct shared_string *get_shared_string(src)
! char **src;
  {
      char retstring[MAXSTRINGLEN];
      struct shared_string *s;
--- 1285,1293 ----
   * The string is read using the same rules as get_string() above.
   */
  
! PRIVATE struct shared_string *
! get_shared_string(src)
!     char **src;
  {
      char retstring[MAXSTRINGLEN];
      struct shared_string *s;
***************
*** 1279,1288 ****
   * characters (the quotes are required).
   */
  
! PRIVATE void process_generic(src, dest, tagvalue)
! char **src;
! struct shared_bindata **dest;
! byte tagvalue;
  {
      byte tmpbuf[MAXBUFLEN];
      byte *str;
--- 1322,1332 ----
   * characters (the quotes are required).
   */
  
! PRIVATE void
! process_generic(src, dest, tagvalue)
!     char		    **src;
!     struct shared_bindata   **dest;
!     byte		    tagvalue;
  {
      byte tmpbuf[MAXBUFLEN];
      byte *str;
***************
*** 1292,1326 ****
      str = tmpbuf;
      *str++ = tagvalue;	    /* Store tag value */
      str++;		    /* Skip over length field */
      if ((*src)[0] == '"') {				/* ASCII data */
  	newlength = sizeof(tmpbuf) - 2;	/* Set maximum allowed length */
  	(void) get_string(src, str, &newlength);
!     } else {						/* Numeric data */
  	newlength = 0;
  	while (newlength < sizeof(tmpbuf) - 2) {
  	    if (interp_byte(src, str++) < 0) {
  		break;
! 	    } else {
  		newlength++;
  	    }
  	    if (**src == '.') {
  		(*src)++;
  	    }
  	}    
      }
      tmpbuf[1] = (byte) (newlength & 0xFF);
      oldlength = ((*dest)->length);
      bdata = (struct shared_bindata *) smalloc(sizeof(struct shared_bindata)
  						+ oldlength + newlength + 1);
      if (oldlength > 0) {
  	bcopy((*dest)->data, bdata->data, oldlength);
      }
      bcopy(tmpbuf, bdata->data + oldlength, newlength + 2);
      bdata->length = oldlength + newlength + 2;
      bdata->linkcount = 1;
      if (*dest) {
! 	del_bindata(*dest);
      }
      *dest = bdata;
  }
  
--- 1336,1380 ----
      str = tmpbuf;
      *str++ = tagvalue;	    /* Store tag value */
      str++;		    /* Skip over length field */
+ 
      if ((*src)[0] == '"') {				/* ASCII data */
  	newlength = sizeof(tmpbuf) - 2;	/* Set maximum allowed length */
  	(void) get_string(src, str, &newlength);
!     }
!     else {						/* Numeric data */
  	newlength = 0;
+ 
  	while (newlength < sizeof(tmpbuf) - 2) {
  	    if (interp_byte(src, str++) < 0) {
  		break;
! 	    }
! 	    else {
  		newlength++;
  	    }
+ 
  	    if (**src == '.') {
  		(*src)++;
  	    }
  	}    
      }
+ 
      tmpbuf[1] = (byte) (newlength & 0xFF);
      oldlength = ((*dest)->length);
+ 
      bdata = (struct shared_bindata *) smalloc(sizeof(struct shared_bindata)
  						+ oldlength + newlength + 1);
      if (oldlength > 0) {
  	bcopy((*dest)->data, bdata->data, oldlength);
      }
+ 
      bcopy(tmpbuf, bdata->data + oldlength, newlength + 2);
      bdata->length = oldlength + newlength + 2;
      bdata->linkcount = 1;
+ 
      if (*dest) {
! 	del_bindata (*dest);
      }
+ 
      *dest = bdata;
  }
  
***************
*** 1333,1351 ****
   * Return TRUE for good names, FALSE otherwise.
   */
  
! PRIVATE boolean goodname(hostname)
! register char *hostname;
  {
      do {
  	if (!isalpha(*hostname++)) {	/* First character must be a letter */
  	    return FALSE;
  	}
  	while (isalnum(*hostname) || (*hostname == '-')) {
  	    hostname++;			/* Alphanumeric or a hyphen */
  	}
  	if (!isalnum(hostname[-1])) {	/* Last must be alphanumeric */
  	    return FALSE;
  	}
  	if (*hostname == '\0') {	/* Done? */
  	    return TRUE;
  	}
--- 1387,1409 ----
   * Return TRUE for good names, FALSE otherwise.
   */
  
! boolean
! goodname(hostname)
!     register char   *hostname;
  {
      do {
  	if (!isalpha(*hostname++)) {	/* First character must be a letter */
  	    return FALSE;
  	}
+ 
  	while (isalnum(*hostname) || (*hostname == '-')) {
  	    hostname++;			/* Alphanumeric or a hyphen */
  	}
+ 
  	if (!isalnum(hostname[-1])) {	/* Last must be alphanumeric */
  	    return FALSE;
  	}
+ 
  	if (*hostname == '\0') {	/* Done? */
  	    return TRUE;
  	}
***************
*** 1362,1369 ****
   * existing element).
   */
  
! PRIVATE boolean nullcmp(host1, host2)
! struct host *host1, *host2;
  {
      return FALSE;
  }
--- 1420,1428 ----
   * existing element).
   */
  
! PRIVATE boolean
! nullcmp(host1, host2)
!     struct host *host1, *host2;
  {
      return FALSE;
  }
***************
*** 1374,1382 ****
   * structure.
   */
  
! PRIVATE boolean nmcmp(name, hp)
! char *name;
! struct host *hp;
  {
      return !strcmp(name, hp->hostname->string);
  }
--- 1433,1442 ----
   * structure.
   */
  
! PRIVATE boolean
! nmcmp(name, hp)
!     char	    *name;
!     struct host	    *hp;
  {
      return !strcmp(name, hp->hostname->string);
  }
***************
*** 1394,1401 ****
   * hash table.
   */
  
! PRIVATE boolean hwinscmp(host1, host2)
! struct host *host1, *host2;
  {
      if (host1->htype != host2->htype) {
  	return FALSE;
--- 1454,1462 ----
   * hash table.
   */
  
! PRIVATE boolean
! hwinscmp(host1, host2)
!     struct host	    *host1, *host2;
  {
      if (host1->htype != host2->htype) {
  	return FALSE;
***************
*** 1422,1564 ****
   * current host entry are inferred from the template entry.
   */
  
! PRIVATE void fill_defaults(hp, src)
! struct host *hp;
! char **src;
  {
!     unsigned tlen, hashcode;
!     struct host *hp2, thp;
!     char tstring[MAXSTRINGLEN];
  
      tlen = sizeof(tstring);
      (void) get_string(src, tstring, &tlen);
!     if (goodname(tstring)) {
  	hashcode = hash_HashFunction(tstring, tlen);
  	hp2 = (struct host *) hash_Lookup(nmhashtable, hashcode, nmcmp,
  					  tstring);
!     } else {
  	thp.iaddr.s_addr = inet_addr(tstring);
  	hashcode = hash_HashFunction(&(thp.iaddr.s_addr), 4);
  	hp2 = (struct host *) hash_Lookup(iphashtable, hashcode, iplookcmp,
  					  &thp);
      }
      if (hp2 == NULL) {
  	report(LOG_ERR, "can't find tc=\"%s\"\n", tstring);
!     } else {
  	/*
  	 * Assignments inside "if" conditionals are intended here.
  	 */
! 	if (!hp->flags.cookie_server) {
  	    if (hp->flags.cookie_server = hp2->flags.cookie_server) {
  		hp->cookie_server = hp2->cookie_server;
  		(hp->cookie_server->linkcount)++;
  	    }
  	}
! 	if (!hp->flags.domain_server) {
  	    if (hp->flags.domain_server = hp2->flags.domain_server) {
  		hp->domain_server = hp2->domain_server;
  		(hp->domain_server->linkcount)++;
  	    }
  	}
! 	if (!hp->flags.gateway) {
  	    if (hp->flags.gateway = hp2->flags.gateway) {
  		hp->gateway = hp2->gateway;
  		(hp->gateway->linkcount)++;
  	    }
  	}
! 	if (!hp->flags.impress_server) {
  	    if (hp->flags.impress_server = hp2->flags.impress_server) {
  		hp->impress_server = hp2->impress_server;
  		(hp->impress_server->linkcount)++;
  	    }
  	}
! 	if (!hp->flags.log_server) {
  	    if (hp->flags.log_server = hp2->flags.log_server) {
  		hp->log_server = hp2->log_server;
  		(hp->log_server->linkcount)++;
  	    }
  	}
! 	if (!hp->flags.lpr_server) {
  	    if (hp->flags.lpr_server = hp2->flags.lpr_server) {
  		hp->lpr_server = hp2->lpr_server;
  		(hp->lpr_server->linkcount)++;
  	    }
  	}
! 	if (!hp->flags.name_server) {
  	    if (hp->flags.name_server = hp2->flags.name_server) {
  		hp->name_server = hp2->name_server;
  		(hp->name_server->linkcount)++;
  	    }
  	}
! 	if (!hp->flags.rlp_server) {
  	    if (hp->flags.rlp_server = hp2->flags.rlp_server) {
  		hp->rlp_server = hp2->rlp_server;
  		(hp->rlp_server->linkcount)++;
  	    }
  	}
! 	if (!hp->flags.time_server) {
  	    if (hp->flags.time_server = hp2->flags.time_server) {
  		hp->time_server = hp2->time_server;
  		(hp->time_server->linkcount)++;
  	    }
  	}
! 	if (!hp->flags.homedir) {
  	    if (hp->flags.homedir = hp2->flags.homedir) {
  		hp->homedir = hp2->homedir;
  		(hp->homedir->linkcount)++;
  	    }
  	}
! 	if (!hp->flags.bootfile) {
  	    if (hp->flags.bootfile = hp2->flags.bootfile) {
  		hp->bootfile = hp2->bootfile;
  		(hp->bootfile->linkcount)++;
  	    }
  	}
! 	if (!hp->flags.generic) {
  	    if (hp->flags.generic = hp2->flags.generic) {
  		hp->generic = hp2->generic;
  		(hp->generic->linkcount)++;
  	    }
  	}
! 	if (!hp->flags.vendor_magic) {
  	    hp->flags.vm_auto = hp2->flags.vm_auto;
  	    if (hp->flags.vendor_magic = hp2->flags.vendor_magic) {
  		bcopy(hp2->vm_cookie, hp->vm_cookie, 4);
  	    }
  	}
! 	if (!hp->flags.name_switch) {
  	    if (hp->flags.name_switch = hp2->flags.name_switch) {
  		hp->flags.send_name = hp2->flags.send_name;
  	    }
  	}
! 	if (!hp->flags.htype) {
  	    if (hp->flags.htype = hp2->flags.htype) {
  		hp->htype = hp2->htype;
  	    }
  	}
! 	if (!hp->flags.time_offset) {
  	    if (hp->flags.time_offset = hp2->flags.time_offset) {
  		hp->flags.timeoff_auto = hp2->flags.timeoff_auto;
  		hp->time_offset = hp2->time_offset;
  	    }
  	}
! 	if (!hp->flags.subnet_mask) {
  	    if (hp->flags.subnet_mask = hp2->flags.subnet_mask) {
  		hp->subnet_mask.s_addr = hp2->subnet_mask.s_addr;
  	    }
  	}
! 	if (!hp->flags.bootsize) {
  	    if (hp->flags.bootsize = hp2->flags.bootsize) {
  		hp->flags.bootsize_auto = hp2->flags.bootsize_auto;
  		hp->bootsize = hp2->bootsize;
  	    }
  	}
! 	if (!hp->flags.tftpdir) {
  	    if (hp->flags.tftpdir = hp2->flags.tftpdir) {
  		hp->tftpdir = hp2->tftpdir;
  		(hp->tftpdir->linkcount)++;
  	    }
  	}
      }
  }
  
--- 1483,1674 ----
   * current host entry are inferred from the template entry.
   */
  
! PRIVATE void
! fill_defaults(hp, src)
!     struct host	    *hp;
!     char	    **src;
  {
!     unsigned	    tlen, hashcode;
!     struct host	    *hp2, thp;
!     char	    tstring[MAXSTRINGLEN];
  
      tlen = sizeof(tstring);
      (void) get_string(src, tstring, &tlen);
! 
!     if (goodname (tstring)) {
  	hashcode = hash_HashFunction(tstring, tlen);
  	hp2 = (struct host *) hash_Lookup(nmhashtable, hashcode, nmcmp,
  					  tstring);
!     }
!     else {
  	thp.iaddr.s_addr = inet_addr(tstring);
  	hashcode = hash_HashFunction(&(thp.iaddr.s_addr), 4);
  	hp2 = (struct host *) hash_Lookup(iphashtable, hashcode, iplookcmp,
  					  &thp);
      }
+ 
      if (hp2 == NULL) {
  	report(LOG_ERR, "can't find tc=\"%s\"\n", tstring);
!     }
!     else {
  	/*
  	 * Assignments inside "if" conditionals are intended here.
  	 */
! 
! 	if (! hp->flags.cookie_server) {
  	    if (hp->flags.cookie_server = hp2->flags.cookie_server) {
  		hp->cookie_server = hp2->cookie_server;
  		(hp->cookie_server->linkcount)++;
  	    }
  	}
! 
! 	if (! hp->flags.domain_server) {
  	    if (hp->flags.domain_server = hp2->flags.domain_server) {
  		hp->domain_server = hp2->domain_server;
  		(hp->domain_server->linkcount)++;
  	    }
  	}
! 
! 	if (! hp->flags.gateway) {
  	    if (hp->flags.gateway = hp2->flags.gateway) {
  		hp->gateway = hp2->gateway;
  		(hp->gateway->linkcount)++;
  	    }
  	}
! 
! 	if (! hp->flags.impress_server) {
  	    if (hp->flags.impress_server = hp2->flags.impress_server) {
  		hp->impress_server = hp2->impress_server;
  		(hp->impress_server->linkcount)++;
  	    }
  	}
! 
! 	if (! hp->flags.log_server) {
  	    if (hp->flags.log_server = hp2->flags.log_server) {
  		hp->log_server = hp2->log_server;
  		(hp->log_server->linkcount)++;
  	    }
  	}
! 
! 	if (! hp->flags.lpr_server) {
  	    if (hp->flags.lpr_server = hp2->flags.lpr_server) {
  		hp->lpr_server = hp2->lpr_server;
  		(hp->lpr_server->linkcount)++;
  	    }
  	}
! 
! 	if (! hp->flags.name_server) {
  	    if (hp->flags.name_server = hp2->flags.name_server) {
  		hp->name_server = hp2->name_server;
  		(hp->name_server->linkcount)++;
  	    }
  	}
! 
! 	if (! hp->flags.rlp_server) {
  	    if (hp->flags.rlp_server = hp2->flags.rlp_server) {
  		hp->rlp_server = hp2->rlp_server;
  		(hp->rlp_server->linkcount)++;
  	    }
  	}
! 
! 	if (! hp->flags.time_server) {
  	    if (hp->flags.time_server = hp2->flags.time_server) {
  		hp->time_server = hp2->time_server;
  		(hp->time_server->linkcount)++;
  	    }
  	}
! 
! 	if (! hp->flags.homedir) {
  	    if (hp->flags.homedir = hp2->flags.homedir) {
  		hp->homedir = hp2->homedir;
  		(hp->homedir->linkcount)++;
  	    }
  	}
! 
! 	if (! hp->flags.bootfile) {
  	    if (hp->flags.bootfile = hp2->flags.bootfile) {
  		hp->bootfile = hp2->bootfile;
  		(hp->bootfile->linkcount)++;
  	    }
  	}
! 
! 	if (! hp->flags.generic) {
  	    if (hp->flags.generic = hp2->flags.generic) {
  		hp->generic = hp2->generic;
  		(hp->generic->linkcount)++;
  	    }
  	}
! 
! 	if (! hp->flags.vendor_magic) {
  	    hp->flags.vm_auto = hp2->flags.vm_auto;
  	    if (hp->flags.vendor_magic = hp2->flags.vendor_magic) {
  		bcopy(hp2->vm_cookie, hp->vm_cookie, 4);
  	    }
  	}
! 
! 	if (! hp->flags.name_switch) {
  	    if (hp->flags.name_switch = hp2->flags.name_switch) {
  		hp->flags.send_name = hp2->flags.send_name;
  	    }
  	}
! 
! 	if (! hp->flags.htype) {
  	    if (hp->flags.htype = hp2->flags.htype) {
  		hp->htype = hp2->htype;
  	    }
  	}
! 
! 	if (! hp->flags.time_offset) {
  	    if (hp->flags.time_offset = hp2->flags.time_offset) {
  		hp->flags.timeoff_auto = hp2->flags.timeoff_auto;
  		hp->time_offset = hp2->time_offset;
  	    }
  	}
! 
! 	if (! hp->flags.subnet_mask) {
  	    if (hp->flags.subnet_mask = hp2->flags.subnet_mask) {
  		hp->subnet_mask.s_addr = hp2->subnet_mask.s_addr;
  	    }
  	}
! 
! 	if (! hp->flags.bootsize) {
  	    if (hp->flags.bootsize = hp2->flags.bootsize) {
  		hp->flags.bootsize_auto = hp2->flags.bootsize_auto;
  		hp->bootsize = hp2->bootsize;
  	    }
  	}
! 
! 	if (! hp->flags.tftpdir) {
  	    if (hp->flags.tftpdir = hp2->flags.tftpdir) {
  		hp->tftpdir = hp2->tftpdir;
  		(hp->tftpdir->linkcount)++;
  	    }
  	}
+ 
+ 	if (! hp->flags.bootserver) {
+ 	    if (hp->flags.bootserver = hp2->flags.bootserver) {
+ 		hp->bootserver.s_addr = hp2->bootserver.s_addr;
+ 	    }
+ 	}
+ 
+ 	if (! hp->flags.iaddr) {
+ 	    if ((hp2->iaddr.s_addr == INADDR_ANY) &&
+ 		(hp->flags.iaddr = hp2->flags.iaddr)) {
+ 		hp->iaddr = hp2->iaddr;
+ 
+ 		if (hp->iaddr.s_addr == INADDR_ANY) {
+ 		    struct hostent	*host;
+ 		    register char	*h_name = &hp->hostname->string[0];
+ 
+ 		    host = gethostbyname (h_name);
+ 
+ 		    if (host) {
+ 			hp->iaddr.s_addr = ((struct in_addr *)
+ 					    host->h_addr_list[0])->s_addr;
+ 		    }
+ 		}
+ 	    }
+ 	}
      }
  }
  
***************
*** 1570,1587 ****
   * the pointer pointing to it.
   */
  
! PRIVATE void adjust(s)
! char **s;
  {
      register char *t;
  
      t = *s;
      while (*t && (*t != ':')) {
  	t++;
      }
      if (*t) {
  	t++;
      }
      *s = t;
  }
  
--- 1680,1701 ----
   * the pointer pointing to it.
   */
  
! PRIVATE void
! adjust(s)
!     char **s;
  {
      register char *t;
  
      t = *s;
+ 
      while (*t && (*t != ':')) {
  	t++;
      }
+ 
      if (*t) {
  	t++;
      }
+ 
      *s = t;
  }
  
***************
*** 1594,1601 ****
   * the pointer pointing to it.
   */
  
! PRIVATE void eat_whitespace(s)
! char **s;
  {
      register char *t;
  
--- 1708,1716 ----
   * the pointer pointing to it.
   */
  
! PRIVATE void
! eat_whitespace(s)
!     char **s;
  {
      register char *t;
  
***************
*** 1652,1659 ****
   * "src" is updated to point to the first non-address (illegal) character.
   */
  
! PRIVATE struct in_addr_list *get_addresses(src)
! char **src;
  {
      struct in_addr tmpaddrlist[MAXINADDRS];
      struct in_addr *address1, *address2;
--- 1767,1775 ----
   * "src" is updated to point to the first non-address (illegal) character.
   */
  
! PRIVATE struct in_addr_list
! *get_addresses(src)
!     char **src;
  {
      struct in_addr tmpaddrlist[MAXINADDRS];
      struct in_addr *address1, *address2;
***************
*** 1661,1681 ****
      unsigned addrcount, totalsize;
  
      address1 = tmpaddrlist;
      for (addrcount = 0; addrcount < MAXINADDRS; addrcount++) {
  	while (**src && isspace(**src)) {	/* Skip whitespace */
  	    (*src)++;
  	}
  	if (! **src) {				/* Quit if nothing more */
  	    break;
  	}
  	if (prs_inetaddr(src, &(address1->s_addr)) < 0) {
  	    break;
  	}
  	address1++;			/* Point to next address slot */
      }
      if (addrcount < 1) {
  	result = NULL;
!     } else {
  	totalsize = sizeof(struct in_addr_list)
  		    + (addrcount - 1) * sizeof(struct in_addr);
  	result = (struct in_addr_list *) smalloc(totalsize);
--- 1777,1804 ----
      unsigned addrcount, totalsize;
  
      address1 = tmpaddrlist;
+ 
      for (addrcount = 0; addrcount < MAXINADDRS; addrcount++) {
+ 
  	while (**src && isspace(**src)) {	/* Skip whitespace */
  	    (*src)++;
  	}
+ 
  	if (! **src) {				/* Quit if nothing more */
  	    break;
  	}
+ 
  	if (prs_inetaddr(src, &(address1->s_addr)) < 0) {
  	    break;
  	}
+ 
  	address1++;			/* Point to next address slot */
      }
+ 
      if (addrcount < 1) {
  	result = NULL;
!     }
!     else {
  	totalsize = sizeof(struct in_addr_list)
  		    + (addrcount - 1) * sizeof(struct in_addr);
  	result = (struct in_addr_list *) smalloc(totalsize);
***************
*** 1683,1688 ****
--- 1806,1812 ----
  	result->addrcount = addrcount;
  	address1 = tmpaddrlist;
  	address2 = result->addr;
+ 
  	for (; addrcount > 0; addrcount--) {
  	    address2->s_addr = address1->s_addr;
  	    address1++;
***************
*** 1708,1727 ****
   * to by "result" is unchanged.  Successful calls return 0.
   */
  
! PRIVATE prs_inetaddr(src, result)
! char **src;
! u_long *result;
  {
!     register u_long value;
!     u_long parts[4], *pp = parts;
!     int n;
  
!     if (!isdigit(**src)) {
! 	return -1;
      }
  loop:
!     value = get_u_long(src);
!     if (**src == '.') {
  	/*
  	 * Internet format:
  	 *	a.b.c.d
--- 1832,1867 ----
   * to by "result" is unchanged.  Successful calls return 0.
   */
  
! int
! prs_inetaddr(src, result)
!     char    **src;
!     u_long  *result;
  {
!     register u_long	value;
!     u_long		parts[4],
! 			*pp = parts;
!     int			n;
!     char		*ptr = *src;
  
!     if (*ptr == '*') {
! 	*result = 0;
! 
! 	while (*ptr && ! isspace (*ptr) && (*ptr != ':'))
! 	    ptr++;	    /* Skip garbage at the end of the wildcard. */
! 
! 	*src = ptr;
! 	
! 	return (0);
      }
+ 
+     if (! isdigit(*ptr)) {
+ 	goto Try_DNS;
+     }
+ 
  loop:
!     value = get_u_long(&ptr);
! 
!     if (*ptr == '.') {
  	/*
  	 * Internet format:
  	 *	a.b.c.d
***************
*** 1729,1752 ****
  	 *	a.b	(with b treated as 24 bits)
  	 */
  	if (pp >= parts + 4) {
! 	    return (-1);
  	}
  	*pp++ = value;
! 	(*src)++;
  	goto loop;
      }
      /*
       * Check for trailing characters.
       */
!     if (**src && !(isspace(**src) || (**src == ':'))) {
! 	return (-1);
      }
      *pp++ = value;
      /*
       * Construct the address according to
       * the number of parts specified.
       */
      n = pp - parts;
      switch (n) {
  	case 1:				/* a -- 32 bits */
  	    value = parts[0];
--- 1869,1898 ----
  	 *	a.b	(with b treated as 24 bits)
  	 */
  	if (pp >= parts + 4) {
! 	    goto Try_DNS;
  	}
  	*pp++ = value;
! 	ptr++;
  	goto loop;
      }
+ 
      /*
       * Check for trailing characters.
       */
! 
!     if (*ptr && ! (isspace(*ptr) || (*ptr == ':'))) {
! 	goto Try_DNS;
      }
+ 
      *pp++ = value;
+ 
      /*
       * Construct the address according to
       * the number of parts specified.
       */
+ 
      n = pp - parts;
+ 
      switch (n) {
  	case 1:				/* a -- 32 bits */
  	    value = parts[0];
***************
*** 1763,1776 ****
  		    ((parts[2] & 0xFF) << 8) | (parts[3] & 0xFF);
  	    break;
  	default:
! 	    return (-1);
      }
      *result = htonl(value);
      return (0);
- }
  
! 
  
  /*
   * "src" points to a pointer which in turn points to a hexadecimal ASCII
   * string.  This string is interpreted as a hardware address and returned
--- 1909,1963 ----
  		    ((parts[2] & 0xFF) << 8) | (parts[3] & 0xFF);
  	    break;
  	default:
! 	    goto Try_DNS;
      }
+ 
+     *src = ptr;		    /* Consumed the contents of the entry. */
+ 
      *result = htonl(value);
+ 
      return (0);
  
! Try_DNS:
!     {
! 	char		name_tag[257];	/* Max DNS + '\0' !! */
! 	int		i = 0;
! 	struct hostent	*host;
  
+ 	ptr = *src;
+ 
+ 	if (! isalnum (*ptr))
+ 	    return (-1);
+ 
+ 	while ((i < sizeof (name_tag) - 1)
+ 	     && (isalnum(*ptr) || (*ptr == '-') || (*ptr == '.'))) {
+ 	    name_tag[i++] = *ptr++;
+ 	}
+ 
+ 	name_tag[i] = '\0';
+ 
+ 	while (*ptr && ! isspace (*ptr) && (*ptr != ':'))
+ 	    ptr++;	    /* Skip garbage at the end of a valid DNS name. */
+ 
+ 	*src = ptr;	    /* Consumed the contents of the entry. */
+ 
+ 	if (! (host = gethostbyname (name_tag))) {
+ 	    /*
+ 	     *	Only here do we really fail if we fail at all!
+ 	     */
+ 
+ 	    report (LOG_INFO,
+ 		    "Failed to convert \"%s\" to an IP address.\n",
+ 		    name_tag);
+ 	    return (-1);
+ 	}
+ 
+ 	*result = ((struct in_addr *) host->h_addr_list[0])->s_addr;
+ 
+ 	return 0;
+     }
+ }
+ 
  /*
   * "src" points to a pointer which in turn points to a hexadecimal ASCII
   * string.  This string is interpreted as a hardware address and returned
***************
*** 1807,1815 ****
      }
      return haddr;       
  }
- 
  
- 
  /*
   * "src" is a pointer to a character pointer which in turn points to a
   * hexadecimal ASCII representation of a byte.  This byte is read, the
--- 1994,2000 ----
***************
*** 1822,1832 ****
   * Successful calls return 0.
   */
  
! PRIVATE int interp_byte(src, retbyte)
! char **src;
! byte *retbyte;
  {
!     int v;
  
      if ((*src)[0] == '0' && (*src)[1] == 'x' || (*src)[1] == 'X') {
  	(*src) += 2;	/* allow 0x for hex, but don't require it */
--- 2007,2018 ----
   * Successful calls return 0.
   */
  
! int
! interp_byte(src, retbyte)
!     char    **src;
!     byte    *retbyte;
  {
!     int	    v;
  
      if ((*src)[0] == '0' && (*src)[1] == 'x' || (*src)[1] == 'X') {
  	(*src) += 2;	/* allow 0x for hex, but don't require it */
