/*  File: helpnongraphic.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1992
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
 * Exported functions:
 * HISTORY:
 * Last edited: Mar  4 01:58 1992 (rd)
 * Created: Thu Feb 20 14:49:27 1992 (mieg)
 *-------------------------------------------------------------------
 */

#include "acedb.h"
#include "array.h"

static Array entries = 0 ;
static Array helpRing = 0 ;
static int ring = 0 ;
static Stack helpText = 0 ;

/**********************************************************************/

static int locateHelp(char *text)
{
  register int i, n , j ;
  
  /* First look in helpRing */
  for (j=0 ; j < arrayMax(helpRing) ;  j++)
    { i = arr(helpRing,j,int) ;
      n = arr(entries,i, int) ;
      if(!strcmp(text, stackText(helpText,n)))
	{ ring = j ;
	  return i ;
	}
    }
  
  for (i=0 ; i < arrayMax(entries) ; i++)
    { n = arr(entries,i,int) ;
      if(!strcmp(text, stackText(helpText,n)))
	{ j = arrayMax(helpRing) ;
	  array(helpRing, j, int) = i ;
	  ring = j ;
	  return i ;
	}
    }
  
  /* Target HELP not found */
  return 0 ;
}


/********************************************************************/

static BOOL helpInit(void)
{ 
  FILE* fil = filopen("wspec/help","wrm","r");
  int nEntries = 1 ,
                     /* Thus the first array entry is implicitly 0
			however, arrayMax(entries) remains 0 
			until the first **entry is read
			*/
      i , j ;
  char c , *cp ;
  Array buf ; 
  
  if (!fil)
    { messout("Sorry, I cannot find the help file.") ;
      return FALSE ;
    }
  buf = arrayCreate(256,char) ;
  helpText = stackCreate(1000) ;
  entries = arrayCreate(32, int) ;
  helpRing = arrayCreate(32, int) ;
  ring = 0 ;

 while(TRUE)
   {        /* get line */
     i = arrayMax(buf) = 0 ;
     while ((c = getc(fil) ) != EOF && c!='\n' && c)
       if (c == '\t')  /* I treat \t as 8 spaces */
	 for (j = 8 ; j-- ; ) 
	   array (buf, i++, char) = ' ' ;
       else
	 array (buf, i++, char) = c ;
     if(c == EOF)  /* EOF */
       break ;
     array(buf,i,char) = 0 ;
     cp = arrp(buf,0,char) ;

        /* New entry in the table */
     if (*cp == '*' && *(cp+1) == '*' && i>=3 )
       { array(entries, nEntries++, int) = stackMark(helpText) + 2;
	 for(i=0;i<arrayMax(buf) ;i++)
	   if(array(buf,i,char) == ' ')
	     { arr(buf,i,char) = 0; break ;}
       }
     pushText(helpText, cp ) ;
   }
     
  fclose(fil) ;
  if(!stackTextMax(helpText))
    pushText(helpText,"Sorry, the help file wspec/help.wrm is empty" ) ;
  arrayDestroy(buf) ;
  return TRUE ;
}

/**********************************************************************/

void helpPrintf (FILE *fil, char *text)
{ int n = 0 ;
  char *cp ;
  static BOOL isInit = FALSE ;

  if (!isInit && !(isInit = helpInit()))
    return ;

  if (!text || !*text)
    text = "acedb" ;

  if (!(n = locateHelp (text)))
    { fprintf (fil, "Help not found for '%s'\n", text) ;
      return ;
    }

  stackCursor(helpText, array(entries,n,int)) ;
  cp = stackNextText(helpText) ;
  while(cp = stackNextText(helpText))
    { if( *cp == '*' && *(cp+1) == '*')
	break ;
      fprintf (fil, "%s\n", cp) ;
    }
}

/**********************************************************************/
/**********************************************************************/
