/*  Last edited: Apr  5 04:21 1992 (mieg) */
/* wcomm.h			definitions for worm communications
*		t.friedman		7/15/91 - first major overhaul
*/
#include <X11/Xlib.h>

/* NOTE: "WComm_v1" flags the old way of doing things (objects are ints).
 * just for temporary use; the default (WComm_v1 not defined) is the
 * new way: objects are strings
 */

#if defined(__cplusplus) || defined(c_plusplus)
#define C_CALL	extern "C"	/* c++ linkage information */
#else
#define C_CALL		/* nothing needed for normal C */
#endif /* c++ external definitions */

typedef enum {
		ImHere,			/* maintenance function, no message */
		ImLeaving,		/* ditto */	
			    /* room for other functions */
		MaintainLink=5,		/* maintenance function, no message */
		MakeAnnotation,		/* to wcs: create an annotation */
		ShowAnnotation,		/* to wcs: display one */
		ShowGenMap,		/* to ace: display genetic map */
		ShowObject,		/* to ace: display tree */
		ShowPhysMap,		/* to ace: display physical map */
		ShowSummary,		/* to ace: not implemented yet */
		SearchString		/* to wcs: search on a string */
	} WMsgType;

typedef enum {unset=0, readonly, readwrite, writeonly} WCommType;

typedef struct {
#ifdef WComm_v1
	long	obj;	/* old internal reference */
#else
	char	*obj;	/* co-program internal reference */
#endif
	char	*note;	/* various uses */
	    /* either vbl can be void, depending on message type */
    } WHandle;

typedef struct wcb {
		Atom	WC_atom;		/* gets X atom */
		Window	WC_window; 
		Display	*WC_display;
		char	*WC_name;
		int	WC_name_len;
		WCommType  WC_comm_type;
		struct wcb  *WC_nextblock;
		void	(*WC_handler)();	/* routine to handle data */
       } WCommBlock;
typedef	WCommBlock *	WCommLink;

/* #define	GOT_WCOMM	1		temporary, while batch testing */
/*#define	WCDefaultLink  (WCommLink) 0  until we build up */
#define	WCNoLink  (WCommLink) -1  	/*  no usable external program */

/* subroutine return type definitions */
C_CALL void	WCleanup ();
C_CALL void    WFree (
#if NeedFunctionPrototypes
    WHandle     *h_buffer
#endif
);

C_CALL Bool WPropMessage (
#if NeedFunctionPrototypes
    XEvent *xevt
#endif
);

#ifdef WCOMM_INTERN
C_CALL Bool    WGetMsg (
#if NeedFunctionPrototypes
    XPropertyEvent *myPevent,   /* redefine myevent structure */
    WCommLink   *who_from,
    WMsgType    *msg_type,
    int         *num_handles,
    WHandle     **h_buffer
#endif
);
#endif	/*WCOMM_INTERN*/

C_CALL Bool    WInitComm (
#if NeedFunctionPrototypes
    char    *my_name,       /* my program name */
    Display *zdisplay, /* if non-zero, use the Disp & Window given */
    Window  zwindow,
    WCommType mycomm,	/* what comm my program will do */
    void    (* handler)()   /* default routine to handle incoming data */
#endif
);

C_CALL int WSendMsg (
#if NeedFunctionPrototypes
    WCommLink   who_to,     /* ignored for now */
    WMsgType    msg_type,
    int         num_handles,
    WHandle     *h_buff
#endif
);

C_CALL int  W_show_external_reference (
#if NeedFunctionPrototypes
    WCommLink whoto,   /* ignored for now */
#ifdef WComm_v1 
    int ext_obj,
#else 
    char *ext_obj,
#endif 
    char *name
#endif
);

C_CALL WCommLink  WOpenCommLink (
#if NeedFunctionPrototypes
    char * whoto,   /* moniker of external program */
    WCommType comm_type,
    void    (* handler)()   /* routine to handle incoming data */
#endif
);

  int	WEndComm  (WCommLink whowith) ;
  void WCleanup () ;
  WCommLink wcsLink ;
/*
  void wcsAccept (WMsgType, int, WHandle*, WCommLink) ;
*/

