/*  Last edited: Mar 31 19:51 1992 (mieg) */

#ifndef DEF_REGULAR_H
#define DEF_REGULAR_H

#include <stdio.h>      /* because need FILE definition for prototypes */
#include "mystdlib.h" /* contains full prototypes of system calls */

#ifdef FALSE
  typedef int BOOL ;
#else
  typedef enum {FALSE=0,TRUE=1} BOOL ;
#endif

typedef unsigned int KEY ;

typedef void (*VoidRoutine)(void) ;

typedef struct freestruct
  { KEY  key ;
    char *text ;
  } FREEOPT ;

/* put "break invokeDebugger" in your favourite debugger init file */
/* this function is empty, it is defined in messubs.c used in
   messerror, messcrash and when ever you need it.
*/
void invokeDebugger(void) ;

void freeinit (void) ;
BOOL freecard (int level) ;	/* FALSE if below level (returned by freeset*) */
void freeforcecard (char *string);
int  freesettext (char *string, char *parms) ; /* returns level to be used in freecard () */
int  freesetfile (FILE *fil, char *parms) ;
void freespecial (char *set) ;	/* set of chars to be recognized from "\n;/%\\@$" */
BOOL freeread (FILE *fil) ;	/* returns FALSE if EOF */
int  freeline (FILE *fil) ;	/* line number in file */
int  freestreamline (int level) ;/* line number in stream(level)*/
char *freeword (void) ;
char *freewordcut (char *cutset, char *cutter) ;
void freeback (void) ;		/* goes back one word */
BOOL freeint (int *p) ;
BOOL freefloat (float *p) ;
BOOL freedouble (double *p) ;
FILE *freeopen (char *name, char *end, char *op) ;
BOOL freekey (KEY *kpt, FREEOPT *options) ;
BOOL freekeymatch (char *text, KEY *kpt, FREEOPT *options) ;
void freemenu (void (*proc)(KEY), FREEOPT *options) ;
BOOL freeselect (KEY *kpt, FREEOPT *options) ;
void freedump (FREEOPT *options) ;
BOOL freestep (char x) ;
void freenext (void) ;
BOOL freeprompt (char *prompt, char *dfault, char *fmt) ;/* gets a card */
BOOL freecheck (char *fmt) ;	/* checks remaining card fits fmt */
int  freefmtlength (char *fmt) ;
BOOL freequery (char *query) ;
char *freepos (void) ;		/* pointer to present position in card */

extern char FREE_UPPER[] ;
#define freeupper(x)	(FREE_UPPER[x & 0xff])  /* table is only 128 long */

extern char FREE_LOWER[] ;
#define freelower(x)	(FREE_LOWER[x & 0xff])

void messout (char *format,...) ;
void messdump (char *format,...) ;
void messdumpset (char *cp) ;			/* set dump file name */
void messerror (char *format,...) ;
void messbeep (void) ;

VoidRoutine crashroutine (VoidRoutine cleanup) ; /* returns old one */
void messcrash (char *format,...) ; /* frees messcrashbuf before cleanup */
char *messprintf (char *format,...) ;   /* sprintf into (static!) string */
char *messalloc (int size) ;	/* malloc with messcrash if fail */
#define messfree(cp)	((cp) ? free(cp),(cp)=0,TRUE : FALSE)

char *filsetdir (char *s) ; /* returns old value - report only if s == 0 */
FILE *filopen (char *name, char *ending, char *spec) ;
FILE *filopent (char *name, int t, char *ending, char *spec) ;
FILE *filqueryopen (char *dirname, char *filname, /* [48], [24] */
		    char *ending, char *spec) ;

double randfloat (void) ;
double randgauss (void) ;
int randint (void) ;
void randsave (int *arr) ;
void randrestore (int *arr) ;

#endif
