/*  Last edited: Nov 18 18:38 1991 (rd) */


/*  header file for gmap.c modelled on look.h */

#ifndef DEFINE_GMAP_h
#define DEFINE_GMAP_h

#include "bs.h"
#include "array.h"

typedef struct GMAPSTUFF *GMAP;
typedef struct GMAPSTUFF
  {
    int   magic;        /* ==GMAPMAGIC*/
    KEY   key;
    OBJ   objet;
    int   redraw;       /* Boolean */
    int   activebox ;
    void *treeflip;     /* current flip node. NB Richard's change here */
    int   mapflip;      /* maps have a different flipper simply based on box
                           numbers */
    Array content,      /* content of each box: BS for Trees, SEG for maps */
          box2key ;     /* registers key to display if a box is selected */
   } ;

#define GMAPMAGIC  27183

                        /* local routines with calls across source files */
void gmapDestroy (GMAP gmap) ;
void gmapMenu (GMAP gmap, KEY k) ;
void gmapFlip (GMAP gmap) ;

#endif




